/*
 * Decompiled with CFR 0.152.
 */
package com.metabit.custom.safe.iip;

import com.metabit.custom.safe.iip.AsymmetricEncryptionWithIIP;
import com.metabit.custom.safe.iip.SymmetricEncryptionWithIntegrityPadding;
import com.metabit.custom.safe.iip.shared.AlgorithmSpec;
import com.metabit.custom.safe.iip.shared.CryptoFactory;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyAgreement;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.SecretKeySpec;
import javax.security.auth.DestroyFailedException;

public class ECDHEWithIntegrityPadding
implements AsymmetricEncryptionWithIIP {
    private final CryptoFactory cf;
    private final AlgorithmSpec algorithmSpec;
    private SecureRandom rng;
    private KeyAgreement keyAgreement;
    private SymmetricEncryptionWithIntegrityPadding symmetricEncryption;

    public ECDHEWithIntegrityPadding(CryptoFactory cryptoFactory, AlgorithmSpec spec) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, NoSuchProviderException {
        this.cf = cryptoFactory;
        this.algorithmSpec = spec;
        this.rng = new SecureRandom();
        this.keyAgreement = KeyAgreement.getInstance("ECDH");
        Cipher symmetricCipher = cryptoFactory.getCipherFromCipherSpec(spec);
        this.symmetricEncryption = new SymmetricEncryptionWithIntegrityPadding(symmetricCipher, cryptoFactory);
    }

    SecretKey createEphemeralAESKey(PublicKey otherSideECPublicKey, PrivateKey ourECPrivateKey, byte[] uniqueID) throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException {
        this.keyAgreement.init(ourECPrivateKey);
        this.keyAgreement.doPhase(otherSideECPublicKey, true);
        MessageDigest kdf = MessageDigest.getInstance("SHA-256");
        kdf.update(uniqueID);
        kdf.update(this.keyAgreement.generateSecret());
        SecretKeySpec secretKeySpec = new SecretKeySpec(kdf.digest(), "AES");
        SecretKey ephKey = SecretKeyFactory.getInstance("AES").generateSecret(secretKeySpec);
        return ephKey;
    }

    SecretKey createEphemeralAESKey(PublicKey[] multipleRecipientKeys, PrivateKey ourECPrivateKey, byte[] uniqueID) throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException {
        this.keyAgreement.init(ourECPrivateKey);
        for (PublicKey publicKey : multipleRecipientKeys) {
            this.keyAgreement.doPhase(publicKey, true);
        }
        MessageDigest kdf = MessageDigest.getInstance("SHA-256");
        kdf.update(uniqueID);
        kdf.update(this.keyAgreement.generateSecret());
        SecretKeySpec secretKeySpec = new SecretKeySpec(kdf.digest(), "AES");
        SecretKey ephKey = SecretKeyFactory.getInstance("AES").generateSecret(secretKeySpec);
        return ephKey;
    }

    @Override
    public byte[] padEncryptAndPackage(byte[] data, PublicKey otherSideECPublicKey, PrivateKey ourECPrivateKey, byte[] keyDiversification) throws NoSuchAlgorithmException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException, DestroyFailedException, InvalidKeySpecException {
        SecretKey ephemeralKey = this.createEphemeralAESKey(otherSideECPublicKey, ourECPrivateKey, keyDiversification);
        byte[] rawEncrypted = this.symmetricEncryption.padAndEncrypt(data, ephemeralKey);
        return rawEncrypted;
    }

    @Override
    public byte[] padEncryptAndPackage(byte[] contentToSeal, PublicKey[] recipientKeys, PrivateKey senderKey, byte[] keyDiversificationForEC) throws NoSuchAlgorithmException, InvalidKeySpecException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        SecretKey ephemeralKey = this.createEphemeralAESKey(recipientKeys, senderKey, keyDiversificationForEC);
        byte[] rawEncrypted = this.symmetricEncryption.padAndEncrypt(contentToSeal, ephemeralKey);
        return rawEncrypted;
    }

    @Override
    public byte[] decryptAndVerify(byte[] encryptedData, PublicKey otherSideECPublicKey, PrivateKey ourECPrivateKey, byte[] keyDiversificationForEC, byte[] ivForSymmetricCrypto) throws NoSuchAlgorithmException, InvalidKeySpecException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        SecretKey ephemeralKey = this.createEphemeralAESKey(otherSideECPublicKey, ourECPrivateKey, keyDiversificationForEC);
        byte[] decrypted = this.symmetricEncryption.decryptAndCheck(encryptedData, ephemeralKey, ivForSymmetricCrypto);
        return decrypted;
    }

    @Override
    public byte[] getSymmetricIV() {
        return this.symmetricEncryption.getIV();
    }
}

