/*
 * Decompiled with CFR 0.152.
 */
package com.metabit.custom.safe.iip;

import com.metabit.custom.safe.iip.SharedCode;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.SecureRandom;
import javax.crypto.BadPaddingException;

public final class InterleavedIntegrityPadding_V1_0 {
    static final byte[] MAGIC_ID_VERSION_1_0 = new byte[]{62, 122, -79, 112, 90, -2, -28, 16};
    private static final int MAGIC_ID_LENGTH = 8;
    public static final int NONCE_SIZE = 4;
    static final int PAYLOAD_LENGTH_SIZE = 4;
    private final SecureRandom rng;
    private final int payloadBytesPerBlock;
    private final int cipherBlockSize;

    public InterleavedIntegrityPadding_V1_0(int cipherBlockSize) {
        if (cipherBlockSize < 9) {
            throw new IllegalArgumentException("cipher block size too small");
        }
        this.cipherBlockSize = cipherBlockSize;
        this.payloadBytesPerBlock = cipherBlockSize - 4;
        this.rng = new SecureRandom();
    }

    public byte[] performPaddingWithAllocation(byte[] payload) {
        long bufferSizeRequiredLong = InterleavedIntegrityPadding_V1_0.calculateNumberOfBytesOverall(payload.length, this.cipherBlockSize);
        if (bufferSizeRequiredLong > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("payload too large, maximum size in byte is 2147483647");
        }
        int bufferSizeRequired = Math.toIntExact(bufferSizeRequiredLong);
        byte[] buffer = new byte[bufferSizeRequired];
        this.performPaddingInPlace(payload, buffer);
        return buffer;
    }

    int performPaddingInPlace(byte[] input, byte[] outputBuffer) {
        assert (input != null);
        assert (outputBuffer != null);
        byte[] nonce = new byte[4];
        this.rng.nextBytes(nonce);
        long nonceWithCounter = SharedCode.get4ByteUnsignedIntFromBuffer(nonce, 0);
        ByteBuffer bb = ByteBuffer.wrap(outputBuffer);
        bb.order(ByteOrder.BIG_ENDIAN);
        if (!bb.hasArray()) {
            throw new UnsupportedOperationException("something's really wrong with the ByteBuffer in this JRE");
        }
        int idSizeUsed = this.calculateIDsizeUsed();
        bb.put(MAGIC_ID_VERSION_1_0, 0, idSizeUsed);
        for (int numHeaderPaddingBytes = this.cipherBlockSize - (idSizeUsed + 4 + 4); numHeaderPaddingBytes > 0; --numHeaderPaddingBytes) {
            bb.put((byte)this.rng.nextInt(256));
        }
        bb.put(nonce);
        bb.putInt(input.length);
        assert (bb.position() == this.cipherBlockSize);
        for (int offset = 0; offset < input.length; offset += this.payloadBytesPerBlock) {
            bb.putInt((int)(++nonceWithCounter & 0xFFFFFFFFL));
            int remainder = input.length - offset;
            bb.put(input, offset, remainder > this.payloadBytesPerBlock ? this.payloadBytesPerBlock : remainder);
        }
        this.padToBlockSizeWithRandom(bb);
        if (input.length % this.payloadBytesPerBlock == 0) {
            bb.putInt((int)(++nonceWithCounter & 0xFFFFFFFFL));
            this.padToBlockSizeWithRandom(bb);
        }
        return bb.position();
    }

    public byte[] checkAndExtract(byte[] paddedData) throws BadPaddingException {
        if (paddedData.length % this.cipherBlockSize != 0) {
            throw new IllegalArgumentException("buffer size invalid");
        }
        byte[] id = new byte[8];
        byte[] nonce = new byte[4];
        byte[] lengthBuffer = new byte[4];
        byte[] payloadBuffer = null;
        int idLengthExpected = this.calculateIDsizeUsed();
        boolean success = true;
        ByteBuffer bb = ByteBuffer.wrap(paddedData);
        bb.order(ByteOrder.BIG_ENDIAN);
        try {
            bb.get(id, 0, idLengthExpected);
            for (int numHeaderPaddingBytes = this.cipherBlockSize - (idLengthExpected + 4 + 4); numHeaderPaddingBytes > 0; --numHeaderPaddingBytes) {
                bb.get();
            }
            bb.get(nonce);
            bb.get(lengthBuffer);
            int payloadLength = Math.toIntExact(SharedCode.get4ByteUnsignedIntFromBuffer(lengthBuffer, 0));
            if (!SharedCode.compareBytes(id, 0, MAGIC_ID_VERSION_1_0, 0, idLengthExpected)) {
                success = false;
            }
            if (payloadLength >= paddedData.length) {
                throw new BadPaddingException();
            }
            int expectedPayloadBlocks = SharedCode.calculateNumberOfPayloadBlocks(payloadLength, this.payloadBytesPerBlock);
            long nonceCounter = SharedCode.get4ByteUnsignedIntFromBuffer(nonce, 0);
            payloadBuffer = new byte[payloadLength];
            int payloadOffset = 0;
            for (int i = 0; i < expectedPayloadBlocks; ++i) {
                int remainder;
                long givenCounterValue = Integer.toUnsignedLong(bb.getInt());
                if (givenCounterValue != ++nonceCounter) {
                    success = false;
                }
                bb.get(payloadBuffer, payloadOffset, (remainder = payloadLength - payloadOffset) > this.payloadBytesPerBlock ? this.payloadBytesPerBlock : remainder);
                payloadOffset += this.payloadBytesPerBlock;
            }
            if (payloadLength % this.payloadBytesPerBlock == 0) {
                this.skipToBlockSize(bb);
                long givenCounterValue = Integer.toUnsignedLong(bb.getInt());
                if (givenCounterValue != ++nonceCounter) {
                    success = false;
                }
                this.skipToBlockSize(bb);
            }
            if (payloadOffset < payloadLength) {
                success = false;
            }
            if (bb.hasArray() && bb.arrayOffset() % this.cipherBlockSize > this.payloadBytesPerBlock) {
                success = false;
            }
        }
        catch (ArithmeticException ex) {
            success = false;
        }
        if (!success) {
            throw new BadPaddingException();
        }
        return payloadBuffer;
    }

    private void padToBlockSizeWithRandom(ByteBuffer bb) {
        int currentOffset = bb.position();
        for (int currentDiff = SharedCode.calculatePadding(currentOffset, this.cipherBlockSize); currentDiff != 0; --currentDiff) {
            bb.put((byte)this.rng.nextInt(256));
        }
    }

    private void skipToBlockSize(ByteBuffer bb) {
        int currentOffset = bb.position();
        for (int currentDiff = SharedCode.calculatePadding(currentOffset, this.cipherBlockSize); currentDiff != 0; --currentDiff) {
            bb.get();
        }
    }

    private int calculateIDsizeUsed() {
        int headerPad = this.cipherBlockSize - 16;
        if (headerPad == 0) {
            headerPad = -1;
        }
        if (headerPad < 0) {
            return 8 + headerPad;
        }
        return 8;
    }

    public static long calculateNumberOfBytesOverall(int payloadLengthInBytes, int cipherBlockSize) {
        int payloadBytesPerBlock = cipherBlockSize - 4;
        return (long)cipherBlockSize * (long)InterleavedIntegrityPadding_V1_0.calculateNumberOfBlocksOverall(payloadLengthInBytes, payloadBytesPerBlock);
    }

    private static int calculateNumberOfBlocksOverall(int payloadLengthInBytes, int payloadBytesPerBlock) {
        int numberOfDataBlocks = SharedCode.calculateNumberOfPayloadBlocks(payloadLengthInBytes + 4, payloadBytesPerBlock);
        int numberOfBlocks = 1 + numberOfDataBlocks;
        return numberOfBlocks;
    }
}

