/*
 * Decompiled with CFR 0.152.
 */
package com.metabit.custom.safe.iip;

import com.metabit.custom.safe.iip.AsymmetricEncryptionWithIIP;
import com.metabit.custom.safe.iip.InterleavedIntegrityPadding_V1_0;
import com.metabit.custom.safe.iip.shared.AlgorithmSpec;
import com.metabit.custom.safe.iip.shared.CryptoFactory;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.RSAPrivateKey;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;

public class RSAWithIntegrityPadding
implements AsymmetricEncryptionWithIIP {
    private final CryptoFactory cf;
    private final AlgorithmSpec algorithmSpec;
    private final Cipher cipher;
    private final SecureRandom rng;
    private final InterleavedIntegrityPadding_V1_0 integrityPaddingInstance;

    public RSAWithIntegrityPadding(CryptoFactory cryptoFactory, AlgorithmSpec spec) throws NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException, InvalidKeyException {
        this.cf = cryptoFactory;
        this.algorithmSpec = spec;
        this.rng = new SecureRandom();
        this.cipher = this.cf.getCipherFromCipherSpec(this.algorithmSpec);
        this.integrityPaddingInstance = new InterleavedIntegrityPadding_V1_0(this.algorithmSpec.getUsableBlockSize());
    }

    @Override
    public byte[] padEncryptAndPackage(byte[] data, PublicKey otherSidePublicKey, PrivateKey ourPrivateKey, byte[] diversification) throws InvalidKeyException, IllegalBlockSizeException, ShortBufferException, BadPaddingException {
        int RSA_blocksize = this.algorithmSpec.getCipherBlockSize();
        int usable_blocksize = this.algorithmSpec.getUsableBlockSize();
        RSAPrivateKey rsaPrivKey = (RSAPrivateKey)ourPrivateKey;
        assert (rsaPrivKey.getModulus().bitLength() == this.algorithmSpec.getKeySizeInBit());
        byte[] padded = this.integrityPaddingInstance.performPaddingWithAllocation(data);
        assert (padded.length % usable_blocksize == 0);
        this.cipher.init(1, (Key)ourPrivateKey, this.rng);
        int inputLength = padded.length;
        int outputLength = inputLength / usable_blocksize * RSA_blocksize;
        byte[] encrypted = new byte[outputLength];
        int numBlocksInput = outputLength / RSA_blocksize;
        for (int i = 0; i < numBlocksInput; ++i) {
            this.cipher.doFinal(padded, i * usable_blocksize, usable_blocksize, encrypted, i * RSA_blocksize);
        }
        Arrays.fill(padded, (byte)0);
        return encrypted;
    }

    @Override
    public byte[] padEncryptAndPackage(byte[] contentToSeal, PublicKey[] recipientKeys, PrivateKey senderKey, byte[] keyDiversificationForEC) throws InvalidKeyException, IllegalBlockSizeException, BadPaddingException, ShortBufferException {
        return this.padEncryptAndPackage(contentToSeal, (PublicKey)null, senderKey, null);
    }

    @Override
    public byte[] decryptAndVerify(byte[] encryptedData, PublicKey senderPublicKey, PrivateKey recipientPrivateKey, byte[] diversification, byte[] iv) throws InvalidKeyException, IllegalBlockSizeException, BadPaddingException, ShortBufferException {
        int RSA_blocksize = this.algorithmSpec.getCipherBlockSize();
        int usable_blocksize = this.algorithmSpec.getUsableBlockSize();
        if (encryptedData.length % RSA_blocksize != 0) {
            throw new IllegalArgumentException("input length doesn't fit with key size");
        }
        int numBlocks = encryptedData.length / RSA_blocksize;
        int decryptedLength = encryptedData.length;
        byte[] decrypted = new byte[numBlocks * usable_blocksize];
        this.cipher.init(2, (Key)senderPublicKey, this.rng);
        int inputOffset = 0;
        int outputOffset = 0;
        for (int i = numBlocks; i > 0; --i) {
            this.cipher.doFinal(encryptedData, inputOffset, RSA_blocksize, decrypted, outputOffset);
            inputOffset += RSA_blocksize;
            outputOffset += usable_blocksize;
        }
        byte[] payload = this.integrityPaddingInstance.checkAndExtract(decrypted);
        Arrays.fill(decrypted, (byte)0);
        return payload;
    }

    @Override
    public byte[] getSymmetricIV() {
        return null;
    }
}

