/*
 * Decompiled with CFR 0.152.
 */
package com.metabit.custom.safe.iip;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class SharedCode {
    public static int calculateNumberOfPayloadBlocks(int payloadLengthInBytes, int payloadBytesPerBlock) {
        int paddedDataBytes = payloadLengthInBytes + SharedCode.calculatePadding(payloadLengthInBytes, payloadBytesPerBlock);
        int numberOfDataBlocks = paddedDataBytes / payloadBytesPerBlock;
        return numberOfDataBlocks;
    }

    static final int calculatePadding(int number, int alignment) {
        int diff = number % alignment;
        return diff != 0 ? alignment - diff : 0;
    }

    public static long get4ByteUnsignedIntFromBuffer(byte[] input, int offset) {
        ByteBuffer tmpReader = ByteBuffer.wrap(input);
        tmpReader.order(ByteOrder.BIG_ENDIAN);
        int intValue = tmpReader.getInt(offset);
        return Integer.toUnsignedLong(intValue);
    }

    public static void write8ByteUnsignedLongToBuffer(Long value, byte[] buffer) {
        assert (buffer.length >= 8);
        ByteBuffer wrap = ByteBuffer.wrap(buffer);
        wrap.order(ByteOrder.BIG_ENDIAN);
        wrap.putLong(value);
    }

    protected static boolean compareBytes(byte[] sourceA, int offsetInA, byte[] sourceB, int offsetInB, int maxBytesToCompare) {
        for (int i = 0; i < maxBytesToCompare; ++i) {
            if (sourceA[offsetInA + i] == sourceB[offsetInB + i]) continue;
            return false;
        }
        return true;
    }
}

