/*
 * Decompiled with CFR 0.152.
 */
package com.metabit.custom.safe.iip;

import com.metabit.custom.safe.iip.InterleavedIntegrityPadding_V1_0;
import com.metabit.custom.safe.iip.shared.CryptoFactory;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.SecureRandom;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;

public class SymmetricEncryptionWithIntegrityPadding {
    static final String[] CHAINING_WITHOUT_DIFFUSION = new String[]{"CFB", "OFB", "CTR", "GCM"};
    private SecureRandom rng;
    private Cipher cipher;
    private int cipherBlockSize;
    private InterleavedIntegrityPadding_V1_0 integrityPaddingInstance;

    public SymmetricEncryptionWithIntegrityPadding(Cipher cipher, CryptoFactory cryptoFactory) throws InvalidKeyException {
        String cipherSpec = cipher.getAlgorithm();
        if (Arrays.stream(CHAINING_WITHOUT_DIFFUSION).anyMatch(cipherSpec::contains)) {
            throw new IllegalArgumentException("NEVER use streaming ciphers which just XOR their stream in combination with this padding!");
        }
        int blockSize = cipher.getBlockSize();
        if (blockSize != 16) {
            throw new UnsupportedOperationException("this implementation is optimised for blocksize 16");
        }
        this.init(cipher);
    }

    private void init(Cipher cipher) throws InvalidKeyException {
        this.cipherBlockSize = cipher.getBlockSize();
        this.cipher = cipher;
        this.integrityPaddingInstance = new InterleavedIntegrityPadding_V1_0(this.cipherBlockSize);
        this.rng = new SecureRandom();
    }

    byte[] encryptOnly(byte[] dataToEncrypt, SecretKey secretKey) throws IllegalBlockSizeException, BadPaddingException, InvalidKeyException {
        this.cipher.init(1, (Key)secretKey, this.rng);
        return this.cipher.doFinal(dataToEncrypt);
    }

    public byte[] padAndEncrypt(byte[] input, SecretKey secretKey) throws IllegalBlockSizeException, BadPaddingException, InvalidKeyException {
        byte[] padded = this.integrityPaddingInstance.performPaddingWithAllocation(input);
        return this.encryptOnly(padded, secretKey);
    }

    public byte[] getIV() {
        return this.cipher.getIV();
    }

    public byte[] decryptAndCheck(byte[] input, SecretKey secretKey, byte[] iv) throws InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        if (iv != null) {
            IvParameterSpec ivPS = new IvParameterSpec(iv);
            this.cipher.init(2, (Key)secretKey, ivPS);
        } else {
            this.cipher.init(2, secretKey);
        }
        byte[] decryptedData = this.cipher.doFinal(input);
        byte[] payloadData = this.integrityPaddingInstance.checkAndExtract(decryptedData);
        return payloadData;
    }

    public String getAlgorithm() {
        return this.cipher.getAlgorithm();
    }
}

