/*
 * Decompiled with CFR 0.152.
 */
package com.metabit.custom.safe.iip.shared;

import org.bouncycastle.asn1.ASN1ObjectIdentifier;

public class AlgorithmSpec {
    private ASN1ObjectIdentifier cipherID;
    boolean asymmetric;
    String name;
    private Type type;
    int keySizeInBit;
    int cipherBlockSize;
    int usableBlockSize;

    public ASN1ObjectIdentifier getOID() {
        return this.cipherID;
    }

    public String getName() {
        return this.name;
    }

    public boolean isAsymmetricCipher() {
        return this.asymmetric;
    }

    public Type getType() {
        return this.type;
    }

    public int getKeySizeInBit() {
        return this.keySizeInBit;
    }

    public int getCipherBlockSize() {
        return this.cipherBlockSize;
    }

    public int getUsableBlockSize() {
        return this.usableBlockSize;
    }

    public String toString() {
        switch (this.type) {
            case CIPHER: {
                return this.name + " " + Integer.toString(this.getKeySizeInBit());
            }
            case COMPRESSION: 
            case DIGEST: 
            case KEY_AGREEMENT: 
            case PADDING: {
                return this.name;
            }
        }
        throw new UnsupportedOperationException("internal error, invalid type");
    }

    AlgorithmSpec(ASN1ObjectIdentifier oid, String name, Type type) {
        this.cipherID = oid;
        this.name = name;
        this.type = type;
    }

    public AlgorithmSpec(ASN1ObjectIdentifier oid, String name, Type type, boolean asymmetricFlag, int keySize, int cipherBlockSize, int tara) {
        this.cipherID = oid;
        this.name = name;
        this.type = type;
        this.asymmetric = asymmetricFlag;
        this.keySizeInBit = keySize;
        this.cipherBlockSize = cipherBlockSize;
        this.usableBlockSize = cipherBlockSize - tara;
    }

    public static enum Type {
        COMPRESSION,
        CIPHER,
        DIGEST,
        KEY_AGREEMENT,
        PADDING,
        ELLIPTIC_CURVE;

    }
}

