/*
 * Decompiled with CFR 0.152.
 */
package com.metabit.custom.safe.iip.shared;

import com.metabit.custom.safe.iip.shared.AlgorithmSpec;
import com.metabit.custom.safe.iip.shared.SharedConstants;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;

public class AlgorithmSpecCollection {
    public static final AlgorithmSpec ECDH = new AlgorithmSpec(SharedConstants.OID_ECDH_ALGORITHM, "ECDH", AlgorithmSpec.Type.KEY_AGREEMENT);
    public static final AlgorithmSpec ECSECP256R1 = new AlgorithmSpec(SharedConstants.OID_EC_NAMED_CURVE_SECP256R1, "secp256r1", AlgorithmSpec.Type.ELLIPTIC_CURVE, true, 0, 0, 0);
    public static final AlgorithmSpec SHA256 = new AlgorithmSpec(SharedConstants.OID_SHA256, "SHA-256", AlgorithmSpec.Type.DIGEST);
    public static final AlgorithmSpec COMPRESSION_NONE = new AlgorithmSpec(SharedConstants.OID_COMPRESSION_NONE, "no compression", AlgorithmSpec.Type.COMPRESSION);
    public static final AlgorithmSpec COMPRESSION_GZIP = new AlgorithmSpec(SharedConstants.OID_COMPRESSION_GZIP, "gzip", AlgorithmSpec.Type.COMPRESSION);
    public static final AlgorithmSpec AES256ECB_PADDED = new AlgorithmSpec(SharedConstants.OID_AES_256_ECB_NOPAD, "AES/ECB", AlgorithmSpec.Type.CIPHER, false, 256, 16, 0);
    public static final AlgorithmSpec AES256CBC_PADDED = new AlgorithmSpec(SharedConstants.OID_AES_256_CBC_PAD, "AES/CBC", AlgorithmSpec.Type.CIPHER, false, 256, 16, 0);
    public static final AlgorithmSpec AES256CBC = new AlgorithmSpec(SharedConstants.OID_AES_256_CBC_NOPAD, "AES/CBC/NoPadding", AlgorithmSpec.Type.CIPHER, false, 256, 16, 0);
    public static final AlgorithmSpec AES128CBC = new AlgorithmSpec(SharedConstants.OID_AES_128_CBC_NOPAD, "AES/CBC/NoPadding", AlgorithmSpec.Type.CIPHER, false, 128, 16, 0);
    public static final AlgorithmSpec IIP = new AlgorithmSpec(SharedConstants.OID_IIP_ALGORITHM, "IIP", AlgorithmSpec.Type.PADDING);
    public static final AlgorithmSpec IIP2 = new AlgorithmSpec(SharedConstants.OID_IIP_ALGORITHM, "IIP2", AlgorithmSpec.Type.PADDING);
    public static final AlgorithmSpec RSA1024 = new AlgorithmSpec(SharedConstants.OID_RSA_ECB, "RSA/ECB/NoPadding", AlgorithmSpec.Type.CIPHER, true, 1024, 128, 1);
    public static final AlgorithmSpec RSA2048 = new AlgorithmSpec(SharedConstants.OID_RSA_ECB, "RSA/ECB/NoPadding", AlgorithmSpec.Type.CIPHER, true, 2048, 256, 1);
    public static final AlgorithmSpec RSA4096 = new AlgorithmSpec(SharedConstants.OID_RSA_ECB, "RSA/ECB/NoPadding", AlgorithmSpec.Type.CIPHER, true, 4096, 512, 1);
    public static AlgorithmSpec RSA2048_on_SunJCE = new AlgorithmSpec(SharedConstants.OID_RSA_ECB, "RSA/ECB/NoPadding", AlgorithmSpec.Type.CIPHER, true, 2048, 256, 0);
    private static final Map<ASN1ObjectIdentifier, AlgorithmSpec> algorithms = new HashMap<ASN1ObjectIdentifier, AlgorithmSpec>();

    public static AlgorithmSpec lookupByOID(ASN1ObjectIdentifier oid) {
        return algorithms.get(oid);
    }

    public static Collection<AlgorithmSpec> getAllDefined() {
        return algorithms.values();
    }

    static {
        algorithms.put(SharedConstants.OID_AES_256_ECB_NOPAD, AES256ECB_PADDED);
        algorithms.put(SharedConstants.OID_AES_256_CBC_PAD, AES256CBC_PADDED);
        algorithms.put(SharedConstants.OID_AES_256_CBC_NOPAD, AES256CBC);
        algorithms.put(SharedConstants.OID_IIP_ALGORITHM, IIP);
        algorithms.put(SharedConstants.OID_IIP2_ALGORITHM, IIP2);
        algorithms.put(SharedConstants.OID_RSA_ECB, RSA2048);
        algorithms.put(SharedConstants.OID_COMPRESSION_NONE, COMPRESSION_NONE);
        algorithms.put(SharedConstants.OID_COMPRESSION_GZIP, COMPRESSION_GZIP);
        algorithms.put(SharedConstants.OID_ECDH_ALGORITHM, ECDH);
        algorithms.put(SharedConstants.OID_EC_NAMED_CURVE_SECP256R1, ECSECP256R1);
        algorithms.put(SharedConstants.OID_SHA256, SHA256);
    }
}

