/*
 * Decompiled with CFR 0.152.
 */
package com.metabit.custom.safe.iip.shared;

public class ByteIntegerConversion {
    public static long readBigEndianIntegerFromByteArray(byte[] input, int offset, int sizeInBytes) {
        assert (sizeInBytes <= 8);
        long tmp = 0L;
        while (sizeInBytes > 0) {
            tmp <<= 8;
            tmp |= (long)(input[offset++] & 0xFF);
            --sizeInBytes;
        }
        return tmp;
    }

    public static void writeBigEndianIntegerToByteArray(long value, byte[] output, int startOffset, int sizeInBytes) {
        int pos = startOffset + sizeInBytes - 1;
        if (pos > output.length) {
            throw new IndexOutOfBoundsException();
        }
        while (sizeInBytes > 0) {
            output[pos--] = (byte)(value & 0xFFL);
            value >>= 8;
            --sizeInBytes;
        }
    }
}

