/*
 * Decompiled with CFR 0.152.
 */
package com.metabit.custom.safe.iip.shared;

import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.gnu.GNUObjectIdentifiers;
import org.bouncycastle.asn1.kisa.KISAObjectIdentifiers;
import org.bouncycastle.asn1.misc.MiscObjectIdentifiers;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.ntt.NTTObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;

public final class SharedConstants {
    public static final ASN1ObjectIdentifier OID_SAFE_SEAL = new ASN1ObjectIdentifier("1.3.6.1.4.1.60279.1.1");
    public static final ASN1ObjectIdentifier OID_SAFE_SEAL_AUTH = new ASN1ObjectIdentifier("1.3.6.1.4.1.60279.1.2");
    public static final ASN1ObjectIdentifier OID_RSA_ECB = new ASN1ObjectIdentifier("1.2.840.113549.1.1.1");
    public static final ASN1ObjectIdentifier OID_EL_GAMAL = new ASN1ObjectIdentifier("1.3.6.1.4.1.3029.1.2");
    public static final ASN1ObjectIdentifier OID_ECDH_PUBLIC_KEY = new ASN1ObjectIdentifier("1.2.840.10045.2.1");
    public static final ASN1ObjectIdentifier OID_EC_NAMED_CURVE_SECP256R1 = new ASN1ObjectIdentifier("1.2.840.10045.3.1.7");
    public static final ASN1ObjectIdentifier OID_EC_NAMED_CURVE_SECP192R1 = new ASN1ObjectIdentifier("1.2.840.10045.3.1.1");
    public static final ASN1ObjectIdentifier OID_EC_NAMED_CURVE_X25519 = new ASN1ObjectIdentifier("1.3.6.1.4.1.3029.1.5.1");
    public static final ASN1ObjectIdentifier OID_COMPRESSION_NONE = new ASN1ObjectIdentifier("1.3.6.1.4.1.21876.1.1.1.1.0");
    public static final ASN1ObjectIdentifier OID_COMPRESSION_DEFLATE = new ASN1ObjectIdentifier("1.3.6.1.4.1.21876.1.1.1.1.1");
    public static final ASN1ObjectIdentifier OID_COMPRESSION_GZIP = new ASN1ObjectIdentifier("1.3.6.1.4.1.21876.1.1.1.1.2");
    public static final ASN1ObjectIdentifier OID_COMPRESSION_BROTLI = new ASN1ObjectIdentifier("1.3.6.1.4.1.21876.1.1.1.1.3");
    static final ASN1ObjectIdentifier oracle_id_ct_compressedData = new ASN1ObjectIdentifier("1.2.840.113549.1.9.16.1.9");
    static final ASN1ObjectIdentifier oraclie_id_alg_zlibCompress = new ASN1ObjectIdentifier("1.2.840.113549.1.3.86.2.14");
    public static final ASN1ObjectIdentifier OID_AES_128_ECB = new ASN1ObjectIdentifier("2.16.840.1.101.3.4.1.1");
    public static final ASN1ObjectIdentifier OID_AES_128_CBC_PAD = new ASN1ObjectIdentifier("2.16.840.1.101.3.4.1.2");
    public static final ASN1ObjectIdentifier OID_AES_128_CBC_NOPAD = new ASN1ObjectIdentifier("1.3.6.1.4.1.21876.1.1.1.2.1.2");
    public static final ASN1ObjectIdentifier OID_AES_192_ECB = new ASN1ObjectIdentifier("2.16.840.1.101.3.4.1.21");
    public static final ASN1ObjectIdentifier OID_AES_192_CBC_PAD = new ASN1ObjectIdentifier("2.16.840.1.101.3.4.1.22");
    public static final ASN1ObjectIdentifier OID_AES_192_CBC_NOPAD = new ASN1ObjectIdentifier("1.3.6.1.4.1.21876.1.1.1.2.1.41");
    public static final ASN1ObjectIdentifier OID_AES_256_ECB_NOPAD = new ASN1ObjectIdentifier("2.16.840.1.101.3.4.1.41");
    public static final ASN1ObjectIdentifier OID_AES_256_CBC_PAD = new ASN1ObjectIdentifier("2.16.840.1.101.3.4.1.42");
    public static final ASN1ObjectIdentifier OID_AES_256_CBC_NOPAD = new ASN1ObjectIdentifier("1.3.6.1.4.1.21876.1.1.1.2.1.42");
    public static final ASN1ObjectIdentifier OID_SHA_512 = new ASN1ObjectIdentifier("1.2.840.1.101.3.4.2.3");
    public static final ASN1ObjectIdentifier OID_SHA256 = new ASN1ObjectIdentifier("2.16.840.1.101.3.4.2.1");
    public static final ASN1ObjectIdentifier OID_SHA512 = new ASN1ObjectIdentifier("2.16.840.1.101.3.4.2.3");
    public static final ASN1ObjectIdentifier OID_SHA512_256 = new ASN1ObjectIdentifier("2.16.840.1.101.3.4.2.6");
    public static final ASN1ObjectIdentifier OID_SHA3_256 = new ASN1ObjectIdentifier("2.16.840.1.101.3.4.2.8");
    public static final ASN1ObjectIdentifier OID_SHA3_512 = new ASN1ObjectIdentifier("2.16.840.1.101.3.4.2.10");
    public static final ASN1ObjectIdentifier OID_ECDH_ALGORITHM = new ASN1ObjectIdentifier("1.3.132.1.12");
    public static final ASN1ObjectIdentifier OID_EC_PUBLIC_KEY_TYPE = new ASN1ObjectIdentifier("1.2.840.10045.62.2");
    public static final ASN1ObjectIdentifier OID_EC_PUBLIC_KEY = new ASN1ObjectIdentifier("1.2.840.10045.62.2.1");
    public static final ASN1ObjectIdentifier OID_EC_UNRESTRICTED = new ASN1ObjectIdentifier("1.2.840.10045.2.1");
    private static final Map keyExchange = new HashMap();
    private static final Map keyExchangeAlgorithms;
    private static final Map keyDiversificationAlgorithms;
    private static final Map ciphers;
    private static final Map futureCiphers;
    public static final ASN1ObjectIdentifier OID_IIP_ALGORITHM;
    public static final ASN1ObjectIdentifier OID_IIP2_ALGORITHM;
    private static final Map<ASN1ObjectIdentifier, String> paddings;
    private static final Map<ASN1ObjectIdentifier, String> combinedForwardMap;
    private static final Map<String, ASN1ObjectIdentifier> combinedReverseMap;

    private SharedConstants() {
    }

    public static String getNameForOID(ASN1ObjectIdentifier oid) throws NoSuchAlgorithmException {
        if (combinedForwardMap.containsKey(oid)) {
            return String.valueOf(combinedForwardMap.get(oid));
        }
        throw new NoSuchAlgorithmException(oid.getId());
    }

    public static ASN1ObjectIdentifier getOIDForName(String algorithmName) throws NoSuchAlgorithmException {
        if (combinedReverseMap.containsKey(algorithmName)) {
            return combinedReverseMap.get(algorithmName);
        }
        throw new NoSuchAlgorithmException(algorithmName);
    }

    public static Set<ASN1ObjectIdentifier> getCiphersOIDs() {
        return ciphers.keySet();
    }

    public static Set<ASN1ObjectIdentifier> getKeyDiversificationOIDs() {
        return keyDiversificationAlgorithms.keySet();
    }

    public static Set<ASN1ObjectIdentifier> getKeyExchangeAlgorithmsOIDs() {
        return keyExchangeAlgorithms.keySet();
    }

    static {
        keyExchange.put(OID_ECDH_ALGORITHM, "ECDH");
        keyExchangeAlgorithms = new HashMap();
        keyDiversificationAlgorithms = new HashMap();
        keyDiversificationAlgorithms.put(NISTObjectIdentifiers.id_sha224, "SHA224");
        keyDiversificationAlgorithms.put(NISTObjectIdentifiers.id_sha256, "SHA256");
        keyDiversificationAlgorithms.put(NISTObjectIdentifiers.id_sha384, "SHA384");
        keyDiversificationAlgorithms.put(NISTObjectIdentifiers.id_sha512, "SHA512");
        keyDiversificationAlgorithms.put(NISTObjectIdentifiers.id_sha3_224, "SHA3-224");
        keyDiversificationAlgorithms.put(NISTObjectIdentifiers.id_sha3_256, "SHA3-256");
        keyDiversificationAlgorithms.put(NISTObjectIdentifiers.id_sha3_384, "SHA3-384");
        keyDiversificationAlgorithms.put(NISTObjectIdentifiers.id_sha3_512, "SHA3-512");
        ciphers = new HashMap();
        futureCiphers = new HashMap();
        ciphers.put(NISTObjectIdentifiers.id_aes256_CBC, "AES-256/CBC");
        ciphers.put(NISTObjectIdentifiers.id_aes256_ECB, "AES-256/ECB");
        ciphers.put(NISTObjectIdentifiers.id_aes128_ECB, "AES-128/ECB");
        ciphers.put(NISTObjectIdentifiers.id_aes192_ECB, "AES-192/ECB");
        ciphers.put(NISTObjectIdentifiers.id_aes128_CBC, "AES-128/CBC");
        ciphers.put(NISTObjectIdentifiers.id_aes192_CBC, "AES-192/CBC");
        futureCiphers.put(PKCSObjectIdentifiers.rsaEncryption, "RSA");
        futureCiphers.put(NTTObjectIdentifiers.id_camellia128_cbc, "CAMELLIA-128/CBC");
        futureCiphers.put(NTTObjectIdentifiers.id_camellia192_cbc, "CAMELLIA-192/CBC");
        futureCiphers.put(NTTObjectIdentifiers.id_camellia256_cbc, "CAMELLIA-256/CBC");
        futureCiphers.put(KISAObjectIdentifiers.id_seedCBC, "SEED/CBC");
        futureCiphers.put(MiscObjectIdentifiers.as_sys_sec_alg_ideaCBC, "IDEA/CBC");
        futureCiphers.put(MiscObjectIdentifiers.cast5CBC, "CAST5/CBC");
        futureCiphers.put(MiscObjectIdentifiers.cryptlib_algorithm_blowfish_ECB, "Blowfish/ECB");
        futureCiphers.put(MiscObjectIdentifiers.cryptlib_algorithm_blowfish_CBC, "Blowfish/CBC");
        futureCiphers.put(GNUObjectIdentifiers.Serpent_128_ECB, "Serpent-128/ECB");
        futureCiphers.put(GNUObjectIdentifiers.Serpent_128_CBC, "Serpent-128/CBC");
        futureCiphers.put(GNUObjectIdentifiers.Serpent_192_ECB, "Serpent-192/ECB");
        futureCiphers.put(GNUObjectIdentifiers.Serpent_192_CBC, "Serpent-192/CBC");
        futureCiphers.put(GNUObjectIdentifiers.Serpent_256_ECB, "Serpent-256/ECB");
        futureCiphers.put(GNUObjectIdentifiers.Serpent_256_CBC, "Serpent-256/CBC");
        OID_IIP_ALGORITHM = new ASN1ObjectIdentifier("1.3.6.1.4.1.21876.4.3.1");
        OID_IIP2_ALGORITHM = new ASN1ObjectIdentifier("1.3.6.1.4.1.21876.4.3.2");
        paddings = new HashMap<ASN1ObjectIdentifier, String>();
        paddings.put(OID_IIP_ALGORITHM, "IIP");
        paddings.put(OID_IIP2_ALGORITHM, "IIP2");
        combinedForwardMap = new HashMap<ASN1ObjectIdentifier, String>();
        combinedReverseMap = new HashMap<String, ASN1ObjectIdentifier>();
        combinedForwardMap.putAll(keyExchange);
        combinedForwardMap.putAll(keyExchangeAlgorithms);
        combinedForwardMap.putAll(keyDiversificationAlgorithms);
        combinedForwardMap.putAll(ciphers);
        combinedForwardMap.putAll(paddings);
        combinedForwardMap.entrySet().stream().forEach(entry -> combinedReverseMap.put((String)entry.getValue(), (ASN1ObjectIdentifier)entry.getKey()));
    }
}

