/*
 * Decompiled with CFR 0.152.
 */
package com.metabit.custom.safe.iip2;

import com.metabit.custom.safe.iip.shared.AlgorithmSpec;
import com.metabit.custom.safe.iip.shared.CryptoFactory;
import com.metabit.custom.safe.iip2.SharedCode;
import com.metabit.custom.safe.safeseal.impl.CryptoSettingsStruct;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;
import lombok.NonNull;
import org.bouncycastle.crypto.DataLengthException;

public final class IntegrityPaddingSignature {
    static final byte[] MAGIC_ID = new byte[]{62, 122, -79, 112, 90, -2, -28, 33, -22, 65, -108, -28, 4, 7, 7, -22};
    static final int LENGTH_SIZE = 4;
    static final int SEQUENCE_SIZE = 4;
    private final int RSA_PREFIX_SIZE = 2;
    private final SecureRandom rng = new SecureRandom();
    private final IvParameterSpec constantSK1IV;
    private final IvParameterSpec constantSK2IV;
    private final IvParameterSpec constantSK3IV;
    private final Cipher symmetricCipher;
    private final Cipher asymmetricCipher;
    private final AlgorithmSpec asymmetricEncryptionSpec;
    private final int innerBlockSize;
    private final int nonceSize;
    private final int headerSize;
    private final int outerBlockSize;
    private final int numPayloadBytesPerOuterBlock;

    public IntegrityPaddingSignature(CryptoFactory cf, CryptoSettingsStruct css) throws NoSuchPaddingException, NoSuchAlgorithmException, NoSuchProviderException {
        this.asymmetricEncryptionSpec = css.getEncryption();
        this.asymmetricCipher = cf.getCipherFromCipherSpec(this.asymmetricEncryptionSpec);
        AlgorithmSpec symmetricEncryptionSpec = css.getSig1();
        this.symmetricCipher = cf.getCipherFromCipherSpec(symmetricEncryptionSpec);
        this.innerBlockSize = symmetricEncryptionSpec.getUsableBlockSize();
        this.outerBlockSize = SharedCode.outerBlockSize(css);
        this.nonceSize = this.innerBlockSize - 8;
        this.headerSize = MAGIC_ID.length + this.nonceSize + 4 + 4;
        this.numPayloadBytesPerOuterBlock = this.outerBlockSize - this.headerSize;
        byte[] iv = new byte[this.innerBlockSize];
        this.constantSK1IV = new IvParameterSpec(iv);
        iv[0] = 64;
        this.constantSK2IV = new IvParameterSpec(iv);
        iv[0] = -128;
        this.constantSK3IV = new IvParameterSpec(iv);
    }

    public byte[] performEncryption(byte[] plaintext, PrivateKey senderPrivateKey, Key sig2SK1, Key sig2SK2, Key sig2SK3) throws InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, ShortBufferException {
        if (plaintext == null || senderPrivateKey == null || sig2SK1 == null || sig2SK2 == null || sig2SK3 == null) {
            throw new IllegalArgumentException("parameters must not be null");
        }
        int plaintextLength = plaintext.length;
        int numPayloadBlocks = (plaintextLength + this.numPayloadBytesPerOuterBlock - 1) / this.numPayloadBytesPerOuterBlock;
        if (numPayloadBlocks == 0) {
            numPayloadBlocks = 1;
        }
        int officialBufferSize = numPayloadBlocks * this.outerBlockSize;
        byte[] buffer = new byte[officialBufferSize + 2];
        this.prepareBufferWithPadding(buffer, numPayloadBlocks, plaintext, plaintextLength);
        this.performEncryptionSteps(buffer, officialBufferSize, numPayloadBlocks, senderPrivateKey, sig2SK1, sig2SK2, sig2SK3);
        return buffer;
    }

    private void prepareBufferWithPadding(byte[] buffer, int numPayloadBlocks, byte[] plaintext, int plaintextLength) {
        int plaintextOffset = 0;
        int offset = 0;
        byte[] nonce = new byte[this.nonceSize];
        this.rng.nextBytes(nonce);
        offset += 2;
        for (int blockCounter = 0; blockCounter < numPayloadBlocks; ++blockCounter) {
            if (plaintextOffset != blockCounter * this.numPayloadBytesPerOuterBlock) {
                throw new UnsupportedOperationException("offset calculation mismatch");
            }
            System.arraycopy(MAGIC_ID, 0, buffer, offset, MAGIC_ID.length);
            System.arraycopy(nonce, 0, buffer, offset += MAGIC_ID.length, this.nonceSize);
            SharedCode.put4ByteUnsignedIntToBuffer(buffer, offset += this.nonceSize, plaintextLength);
            SharedCode.put4ByteUnsignedIntToBuffer(buffer, offset += 4, blockCounter);
            int numBytes = plaintextOffset + this.numPayloadBytesPerOuterBlock < plaintextLength ? this.numPayloadBytesPerOuterBlock : plaintextLength - plaintextOffset;
            System.arraycopy(plaintext, plaintextOffset, buffer, offset += 4, numBytes);
            plaintextOffset += numBytes;
            offset += numBytes;
        }
    }

    private void performEncryptionSteps(byte[] buffer, int officialBufferSize, int numPayloadBlocks, PrivateKey ourPrivateKey, Key sk1, Key sk2, Key sk3) throws InvalidKeyException, IllegalBlockSizeException, BadPaddingException, ShortBufferException, InvalidAlgorithmParameterException {
        int sBlockSize = this.symmetricCipher.getBlockSize();
        this.symmetricCipher.init(1, sk1, this.constantSK1IV, this.rng);
        int step2 = this.symmetricCipher.doFinal(buffer, 2, officialBufferSize, buffer, 2);
        assert (step2 == officialBufferSize);
        this.symmetricCipher.init(1, sk2, this.constantSK2IV, this.rng);
        int step3 = this.symmetricCipher.doFinal(buffer, 2, officialBufferSize, buffer, 2);
        assert (step3 == officialBufferSize);
        IntegrityPaddingSignature.reverseBuffer(buffer, 2, officialBufferSize, sBlockSize);
        this.symmetricCipher.init(1, sk3, this.constantSK3IV, this.rng);
        int step4 = this.symmetricCipher.doFinal(buffer, 2, officialBufferSize, buffer, 2);
        assert (step4 == officialBufferSize);
        buffer[0] = 62;
        buffer[1] = 122;
        RSAPrivateKey rsaPrivKey = (RSAPrivateKey)ourPrivateKey;
        assert (rsaPrivKey.getModulus().bitLength() == this.asymmetricEncryptionSpec.getKeySizeInBit());
        this.asymmetricCipher.init(1, rsaPrivKey);
        this.asymmetricCipher.doFinal(buffer, 0, 256, buffer, 0);
    }

    @NonNull
    public byte[] performDecryptionAndValidation(byte[] ciphertext, PublicKey rsaPubKey, Key sk1, Key sk2, Key sk3) throws BadPaddingException, InvalidAlgorithmParameterException, InvalidKeyException, ShortBufferException, IllegalBlockSizeException, DataLengthException {
        assert (((RSAPublicKey)rsaPubKey).getModulus().bitLength() == this.asymmetricEncryptionSpec.getKeySizeInBit());
        byte[] buffer = ciphertext;
        int inputSize = buffer.length;
        if (inputSize % this.innerBlockSize != 2) {
            throw new BadPaddingException();
        }
        int numSymmetricalBlocks = (inputSize - 2) / this.innerBlockSize;
        int officialBufferSize = numSymmetricalBlocks * this.innerBlockSize;
        if (officialBufferSize % this.outerBlockSize != 0) {
            throw new BadPaddingException();
        }
        int numBlocks = (officialBufferSize + this.outerBlockSize - 1) / this.outerBlockSize;
        if (officialBufferSize % this.outerBlockSize != 0) {
            throw new BadPaddingException();
        }
        this.performDecryptionSteps(rsaPubKey, sk1, sk2, sk3, buffer, officialBufferSize, this.innerBlockSize);
        return this.verify_after_decryption(numBlocks, buffer, inputSize);
    }

    private void performDecryptionSteps(PublicKey rsaPubKey, Key sk1, Key sk2, Key sk3, byte[] buffer, int officialBufferSize, int sBlockSize) throws InvalidKeyException, ShortBufferException, IllegalBlockSizeException, BadPaddingException, InvalidAlgorithmParameterException {
        this.asymmetricCipher.init(2, (Key)rsaPubKey, this.rng);
        this.asymmetricCipher.doFinal(buffer, 0, this.outerBlockSize, buffer, 0);
        this.symmetricCipher.init(2, sk3, this.constantSK3IV, this.rng);
        int step4 = this.symmetricCipher.doFinal(buffer, 2, officialBufferSize, buffer, 2);
        assert (step4 == officialBufferSize);
        IntegrityPaddingSignature.reverseBuffer(buffer, 2, officialBufferSize, sBlockSize);
        this.symmetricCipher.init(2, sk2, this.constantSK2IV, this.rng);
        int step3 = this.symmetricCipher.doFinal(buffer, 2, officialBufferSize, buffer, 2);
        assert (step3 == officialBufferSize);
        this.symmetricCipher.init(2, sk1, this.constantSK1IV, this.rng);
        int step2 = this.symmetricCipher.doFinal(buffer, 2, officialBufferSize, buffer, 2);
        assert (step2 == officialBufferSize);
    }

    private byte[] verify_after_decryption(int numBlocks, byte[] buffer, int inputSize) throws BadPaddingException {
        int offset = 2;
        int plaintextOffset = 0;
        int plaintextLength = -1;
        int sequenceID = 0;
        byte[] plaintext = null;
        byte[] nonce = null;
        for (int i = 0; i < numBlocks; ++i) {
            if (!SharedCode.compareBytes(buffer, offset, MAGIC_ID, 0, MAGIC_ID.length)) {
                throw new BadPaddingException();
            }
            offset += MAGIC_ID.length;
            if (nonce == null) {
                nonce = new byte[this.nonceSize];
                System.arraycopy(buffer, offset, nonce, 0, this.nonceSize);
            } else if (!SharedCode.compareBytes(buffer, offset, nonce, 0, this.nonceSize)) {
                throw new BadPaddingException();
            }
            int tmp = Math.toIntExact(SharedCode.get4ByteUnsignedIntFromBuffer(buffer, offset += this.nonceSize));
            offset += 4;
            if (plaintextLength < 0) {
                if (tmp >= inputSize) {
                    throw new BadPaddingException();
                }
                if (tmp / this.numPayloadBytesPerOuterBlock > numBlocks) {
                    throw new BadPaddingException();
                }
                plaintextLength = tmp;
                plaintext = new byte[plaintextLength];
            } else if (plaintextLength != tmp) {
                throw new BadPaddingException();
            }
            tmp = Math.toIntExact(SharedCode.get4ByteUnsignedIntFromBuffer(buffer, offset));
            offset += 4;
            if (tmp != sequenceID) {
                throw new BadPaddingException();
            }
            ++sequenceID;
            tmp = Math.min(plaintextLength - plaintextOffset, this.numPayloadBytesPerOuterBlock);
            System.arraycopy(buffer, offset, plaintext, plaintextOffset, tmp);
            plaintextOffset += tmp;
            offset += tmp;
        }
        if (plaintextOffset != plaintextLength) {
            throw new BadPaddingException();
        }
        return plaintext;
    }

    public static final void reverseBuffer(byte[] buffer, int baseOffset, int length, int sBlockSize) {
        if (length % sBlockSize != 0) {
            throw new IllegalArgumentException("size mismatch: blocks do not fit in without remainder");
        }
        byte[] tmp = new byte[sBlockSize];
        int numBlocksOverall = length / sBlockSize;
        int numBlocksToSwap = numBlocksOverall / 2;
        for (int i = 0; i < numBlocksToSwap; ++i) {
            int offsetA = baseOffset + i * sBlockSize;
            int offsetB = baseOffset + (numBlocksOverall - 1 - i) * sBlockSize;
            System.arraycopy(buffer, offsetA, tmp, 0, sBlockSize);
            System.arraycopy(buffer, offsetB, buffer, offsetA, sBlockSize);
            System.arraycopy(tmp, 0, buffer, offsetB, sBlockSize);
        }
    }
}

