/*
 * Decompiled with CFR 0.152.
 */
package com.metabit.custom.safe.iip2;

import com.metabit.custom.safe.iip.AsymmetricEncryptionWithIIP;
import com.metabit.custom.safe.iip.RSAWithIntegrityPadding;
import com.metabit.custom.safe.iip.shared.AlgorithmSpecCollection;
import com.metabit.custom.safe.iip.shared.CryptoFactory;
import com.metabit.custom.safe.iip2.IntegrityPaddingSignature;
import com.metabit.custom.safe.iip2.SharedCode;
import com.metabit.custom.safe.safeseal.impl.CryptoSettingsStruct;
import com.metabit.custom.safe.safeseal.impl.InternalTransportTuple;
import com.metabit.custom.safe.safeseal.impl.TransportFormatConverter;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.crypto.DataLengthException;

public class SAFESeal2 {
    private final CryptoFactory cryptoFactory;
    private TransportFormatConverter formatConverter;
    private AsymmetricEncryptionWithIIP asymmetricLayer;
    private boolean compressionMode;
    private CryptoSettingsStruct css;

    public SAFESeal2(CryptoFactory cf, int version, int revision) throws NoSuchPaddingException, NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        this.cryptoFactory = cf;
        this.compressionMode = false;
        this.init(version, revision);
    }

    public boolean getCompressionMode() {
        return this.compressionMode;
    }

    public void setCompressionMode(boolean compressionMode) {
        this.compressionMode = compressionMode;
    }

    private static byte[] tryToCompress(byte[] rawPayload, InternalTransportTuple itt) throws NoSuchAlgorithmException {
        byte[] payload;
        int inputSize = rawPayload.length;
        byte[] tmp = new byte[inputSize];
        Deflater deflater = new Deflater(9, true);
        deflater.setInput(rawPayload);
        deflater.finish();
        int outputSize = deflater.deflate(tmp);
        if (outputSize >= inputSize) {
            payload = rawPayload;
            itt.getCryptoSettings().setCompressionOID(AlgorithmSpecCollection.COMPRESSION_NONE.getOID());
        } else {
            payload = new byte[outputSize];
            System.arraycopy(tmp, 0, payload, 0, outputSize);
            itt.getCryptoSettings().setCompressionOID(AlgorithmSpecCollection.COMPRESSION_GZIP.getOID());
        }
        deflater.end();
        return payload;
    }

    private void init(int version, int revision) {
        this.formatConverter = new TransportFormatConverter();
        this.css = new CryptoSettingsStruct(version, revision);
    }

    public byte[] seal(byte[] contentToSeal, PrivateKey senderKey, PublicKey[] recipientKeys, Long uniqueID) throws NoSuchPaddingException, NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, IllegalBlockSizeException, InvalidKeySpecException, BadPaddingException, IOException, ShortBufferException, InvalidAlgorithmParameterException {
        String description = senderKey.toString();
        int privateKeyLength = SharedCode.getRSAPrivateKeyLengthInBits(description);
        switch (privateKeyLength) {
            case 1024: {
                this.asymmetricLayer = new RSAWithIntegrityPadding(this.cryptoFactory, AlgorithmSpecCollection.RSA1024);
                break;
            }
            case 2048: {
                this.asymmetricLayer = new RSAWithIntegrityPadding(this.cryptoFactory, AlgorithmSpecCollection.RSA2048);
                break;
            }
            case 4096: {
                this.asymmetricLayer = new RSAWithIntegrityPadding(this.cryptoFactory, AlgorithmSpecCollection.RSA4096);
                break;
            }
            default: {
                throw new InvalidKeySpecException("key of unsupported size " + privateKeyLength);
            }
        }
        InternalTransportTuple itt = new InternalTransportTuple(new CryptoSettingsStruct(2, 0));
        itt.getCryptoSettings().setEncryptionKeySize(privateKeyLength);
        KeyGenerator keyGenerator = KeyGenerator.getInstance("AES");
        SecretKey key1 = keyGenerator.generateKey();
        SecretKey key2 = keyGenerator.generateKey();
        SecretKey key3 = keyGenerator.generateKey();
        itt.setEphemeralSymmetricKeyBytes(key1.getEncoded(), key2.getEncoded(), key3.getEncoded());
        byte[] payload = !this.compressionMode ? contentToSeal : SAFESeal2.tryToCompress(contentToSeal, itt);
        IntegrityPaddingSignature iip2 = new IntegrityPaddingSignature(this.cryptoFactory, this.css);
        byte[] encryptedData = iip2.performEncryption(payload, senderKey, key1, key2, key3);
        itt.setEncryptedData(encryptedData);
        return this.formatConverter.wrapForTransport(itt);
    }

    public byte[] reveal(byte[] sealedInput, PrivateKey recipientKey, PublicKey senderPublicKey) throws BadPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, NoSuchAlgorithmException, InvalidKeySpecException, InvalidKeyException, NoSuchPaddingException, NoSuchProviderException, IOException, ShortBufferException {
        InternalTransportTuple tuple = this.formatConverter.unwrapTransportFormat(sealedInput);
        if (tuple.getEphemeralSymmetricKeyBytes(1) == null || tuple.getEphemeralSymmetricKeyBytes(2) == null || tuple.getEphemeralSymmetricKeyBytes(3) == null) {
            throw new IllegalArgumentException("ephemeral keys required for algorithm version 2");
        }
        ASN1ObjectIdentifier compressionOID = tuple.getCryptoSettings().getCompressionOID();
        if (compressionOID.equals(AlgorithmSpecCollection.COMPRESSION_GZIP.getOID())) {
            this.compressionMode = true;
        } else if (compressionOID.equals(AlgorithmSpecCollection.COMPRESSION_NONE.getOID())) {
            this.compressionMode = false;
        } else {
            throw new NoSuchAlgorithmException("invalid compression");
        }
        switch (tuple.getCryptoSettings().getEncryptionKeySize()) {
            case 1024: {
                this.asymmetricLayer = new RSAWithIntegrityPadding(this.cryptoFactory, AlgorithmSpecCollection.RSA1024);
                break;
            }
            case 2048: {
                this.asymmetricLayer = new RSAWithIntegrityPadding(this.cryptoFactory, AlgorithmSpecCollection.RSA2048);
                break;
            }
            case 4096: {
                this.asymmetricLayer = new RSAWithIntegrityPadding(this.cryptoFactory, AlgorithmSpecCollection.RSA4096);
                break;
            }
            default: {
                throw new InvalidKeyException("specified key size not supported");
            }
        }
        try {
            IntegrityPaddingSignature cipherInstance = new IntegrityPaddingSignature(this.cryptoFactory, this.css);
            SecretKeySpec key1 = new SecretKeySpec(tuple.getEphemeralSymmetricKeyBytes(1), 0, 16, "AES");
            SecretKeySpec key2 = new SecretKeySpec(tuple.getEphemeralSymmetricKeyBytes(2), 0, 16, "AES");
            SecretKeySpec key3 = new SecretKeySpec(tuple.getEphemeralSymmetricKeyBytes(3), 0, 16, "AES");
            byte[] payload = cipherInstance.performDecryptionAndValidation(tuple.getEncryptedData(), senderPublicKey, key1, key2, key3);
            if (this.compressionMode) {
                payload = this.inflateZLIBcompressedData(payload);
            }
            return payload;
        }
        catch (ArrayIndexOutOfBoundsException | DataFormatException | DataLengthException ex) {
            throw new BadPaddingException();
        }
    }

    private byte[] inflateZLIBcompressedData(byte[] payload) throws DataFormatException {
        int outputSize;
        Inflater inflater = new Inflater(true);
        int inputSize = payload.length;
        int tmpSize = 0;
        do {
            inflater.setInput(payload);
            byte[] tmp = new byte[tmpSize += inputSize];
            outputSize = inflater.inflate(tmp);
            if (outputSize == 0) {
                throw new IllegalArgumentException("input compression level not handled");
            }
            inflater.reset();
        } while (tmpSize == outputSize);
        byte[] result = new byte[outputSize];
        inflater.setInput(payload);
        inflater.inflate(result);
        inflater.end();
        return result;
    }
}

