/*
 * Decompiled with CFR 0.152.
 */
package com.metabit.custom.safe.iip2;

import com.metabit.custom.safe.safeseal.impl.CryptoSettingsStruct;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SharedCode {
    protected static boolean compareBytes(byte[] sourceA, int offsetInA, byte[] sourceB, int offsetInB, int maxBytesToCompare) {
        for (int i = 0; i < maxBytesToCompare; ++i) {
            if (sourceA[offsetInA + i] == sourceB[offsetInB + i]) continue;
            return false;
        }
        return true;
    }

    static int getRSAPrivateKeyLengthInBits(String description) {
        Pattern keyLengthFromDescription = Pattern.compile(".+RSA private CRT key,\\s+(\\d{4})\\sbits(?m:$)");
        Matcher matcher = keyLengthFromDescription.matcher(description);
        if (!matcher.find()) {
            throw new UnsupportedOperationException("could not determine key size");
        }
        int privateKeyLength = Integer.valueOf(matcher.group(1));
        return privateKeyLength;
    }

    public void checks(CryptoSettingsStruct css) {
        int sig1KeySize;
        int encKeySize = css.getEncryptionKeySize() / 8;
        if (encKeySize % (sig1KeySize = css.getSig1KeySize() / 8) != 0) {
            throw new IllegalArgumentException("key sizes mismatch");
        }
        int numRawBlocks = encKeySize / sig1KeySize;
        if (numRawBlocks < 3) {
            throw new IllegalArgumentException("key size relation error");
        }
    }

    public static long get4ByteUnsignedIntFromBuffer(byte[] input, int offset) {
        ByteBuffer tmpReader = ByteBuffer.wrap(input);
        tmpReader.order(ByteOrder.BIG_ENDIAN);
        int intValue = tmpReader.getInt(offset);
        return Integer.toUnsignedLong(intValue);
    }

    public static void put4ByteUnsignedIntToBuffer(byte[] input, int offset, int value) {
        ByteBuffer tmpWriter = ByteBuffer.wrap(input);
        tmpWriter.order(ByteOrder.BIG_ENDIAN);
        tmpWriter.putInt(offset, value);
    }

    public static int outerBlockSize(CryptoSettingsStruct css) {
        return css.getEncryptionKeySize() / 8;
    }

    public static int innerBlockSize(CryptoSettingsStruct css) {
        return css.getSig1KeySize() / 8;
    }
}

