/*
 * Decompiled with CFR 0.152.
 */
package com.metabit.custom.safe.safeseal;

import com.metabit.custom.safe.safeseal.SAFESealRevealer;
import com.metabit.custom.safe.safeseal.SAFESealSealer;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import javax.crypto.BadPaddingException;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import picocli.CommandLine;

public class CommandLineMain
implements Runnable {
    private final KeyFactory keyFactory;
    @CommandLine.Option(names={"-a", "--algorithm"}, defaultValue="2")
    String algorithmVersionString = "2";
    @CommandLine.Option(names={"-P", "--privateKey"})
    Path privateKeyInfo;
    @CommandLine.Option(names={"-p", "--publicKey"})
    Path publicKeyInfo;
    @CommandLine.Option(names={"-u", "--uniqueID"})
    private Long uniqueIDValue;
    @CommandLine.Option(names={"-i", "--input"}, defaultValue="-")
    String inputName;
    @CommandLine.Option(names={"-o", "--output"}, defaultValue="-")
    String outputName;

    public static void main(String[] args) throws NoSuchAlgorithmException {
        CommandLineMain instance = new CommandLineMain();
        CommandLine.run((Runnable)instance, (String[])args);
    }

    CommandLineMain() throws NoSuchAlgorithmException {
        Provider securityProvider = Security.getProvider("BC");
        if (securityProvider == null) {
            securityProvider = new BouncyCastleProvider();
            Security.addProvider(securityProvider);
        }
        this.keyFactory = KeyFactory.getInstance("RSA");
    }

    @Override
    public void run() {
        CommandLine.usage((Object)new CommandLineMain(), (PrintStream)System.out);
    }

    @CommandLine.Command(name="seal")
    void seal() {
        int algorithmVersion = Integer.parseInt(this.algorithmVersionString);
        try {
            InputStream input = this.inputName.equals("-") ? System.in : new FileInputStream(this.inputName);
            OutputStream output = this.outputName.equals("-") ? System.out : Files.newOutputStream(Paths.get(this.outputName, new String[0]), new OpenOption[0]);
            String fileContents = new String(Files.readAllBytes(this.privateKeyInfo), Charset.defaultCharset());
            RSAPrivateKey sealerKey = this.readRSAPrivateKeyFromPKCS8PEM(fileContents);
            assert (sealerKey.getAlgorithm().equals("RSA"));
            byte[] payload = input.readAllBytes();
            SAFESealSealer sealer = new SAFESealSealer(algorithmVersion);
            sealer.setCompressionMode(true);
            byte[] sealed = sealer.seal(sealerKey, null, payload, this.uniqueIDValue);
            output.write(sealed);
            output.flush();
        }
        catch (IOException | NoSuchAlgorithmException | InvalidKeySpecException e) {
            System.err.println(e.getMessage());
            System.exit(1);
        }
        catch (BadPaddingException e) {
            System.err.println(e.getMessage());
            System.exit(2);
        }
    }

    @CommandLine.Command(name="reveal")
    void unseal() {
        int algorithmVersion = Integer.parseInt(this.algorithmVersionString);
        String fileContents = null;
        try {
            InputStream input = this.inputName.equals("-") ? System.in : new FileInputStream(this.inputName);
            OutputStream output = this.outputName.equals("-") ? System.out : Files.newOutputStream(Paths.get(this.outputName, new String[0]), new OpenOption[0]);
            fileContents = new String(Files.readAllBytes(this.publicKeyInfo), Charset.defaultCharset());
            RSAPublicKey sealerPublicKey = this.readRSAPublicKeyFromPEM(fileContents);
            assert (sealerPublicKey.getAlgorithm().equals("RSA"));
            byte[] sealedData = input.readAllBytes();
            SAFESealRevealer revealer = new SAFESealRevealer(algorithmVersion);
            byte[] revealedData = revealer.reveal(sealerPublicKey, null, sealedData);
            output.write(revealedData);
            output.flush();
        }
        catch (IOException | NoSuchAlgorithmException | InvalidKeySpecException e) {
            System.err.println(e.getMessage());
            System.exit(1);
        }
        catch (BadPaddingException e) {
            System.err.println(e.getMessage());
            System.exit(2);
        }
    }

    RSAPublicKey readRSAPublicKeyFromPEM(String pemEncodedRSAPublicKey) throws NoSuchAlgorithmException, InvalidKeySpecException {
        String publicKeyPEM = pemEncodedRSAPublicKey.replace("-----BEGIN PUBLIC KEY-----", "").replaceAll(System.lineSeparator(), "").replace("-----END PUBLIC KEY-----", "");
        byte[] encoded = Base64.getDecoder().decode(publicKeyPEM);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(encoded);
        return (RSAPublicKey)keyFactory.generatePublic(keySpec);
    }

    RSAPrivateKey readRSAPrivateKeyFromPKCS8PEM(String pkcs8encodedRSAPrivateKey) throws NoSuchAlgorithmException, InvalidKeySpecException {
        String privateKeyPEM = pkcs8encodedRSAPrivateKey.replace("-----BEGIN PRIVATE KEY-----", "").replaceAll(System.lineSeparator(), "").replace("-----END PRIVATE KEY-----", "");
        byte[] encoded = Base64.getDecoder().decode(privateKeyPEM);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(encoded);
        return (RSAPrivateKey)keyFactory.generatePrivate(keySpec);
    }
}

