/*
 * Decompiled with CFR 0.152.
 */
package com.metabit.custom.safe.safeseal;

import com.metabit.custom.safe.iip2.SAFESeal2;
import com.metabit.custom.safe.safeseal.impl.CryptoFactoryImpl;
import com.metabit.custom.safe.safeseal.impl.SAFESeal;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class SAFESealRevealer {
    private final int version;
    private Provider securityProvider;
    private final CryptoFactoryImpl cryptoFactory;

    public SAFESealRevealer(int version) {
        this.version = version;
        this.securityProvider = Security.getProvider("BC");
        if (this.securityProvider == null) {
            this.securityProvider = new BouncyCastleProvider();
            Security.addProvider(this.securityProvider);
        }
        this.cryptoFactory = new CryptoFactoryImpl(this.securityProvider);
    }

    public byte[] reveal(byte[] rawPublicKeySingleSender, byte[] rawPrivateKeyRecipient, byte[] sealedMessage) throws BadPaddingException {
        throw new UnsupportedOperationException();
    }

    public final byte[] reveal(PublicKey singleSenderPublicKey, PrivateKey recipientPrivateKey, byte[] sealedMessage) throws BadPaddingException {
        try {
            switch (this.version) {
                default: {
                    throw new UnsupportedOperationException("version not supported");
                }
                case 0: {
                    return this.reveal0(singleSenderPublicKey, recipientPrivateKey, sealedMessage);
                }
                case 1: {
                    return this.reveal1(singleSenderPublicKey, recipientPrivateKey, sealedMessage);
                }
                case 2: 
            }
            return this.reveal2(singleSenderPublicKey, recipientPrivateKey, sealedMessage);
        }
        catch (IOException | IllegalArgumentException | InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | InvalidKeySpecException | IllegalBlockSizeException | NoSuchPaddingException | ShortBufferException e) {
            throw new BadPaddingException();
        }
    }

    private byte[] reveal2(PublicKey singleSenderPublicKey, PrivateKey recipientPrivateKey, byte[] sealedMessage) throws NoSuchPaddingException, NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, ShortBufferException, BadPaddingException, InvalidKeySpecException, IOException {
        SAFESeal2 revealer = new SAFESeal2(this.cryptoFactory, 2, 0);
        return revealer.reveal(sealedMessage, recipientPrivateKey, singleSenderPublicKey);
    }

    private byte[] reveal1(PublicKey singleSenderPublicKey, PrivateKey recipientPrivateKey, byte[] sealedMessage) throws NoSuchPaddingException, NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, BadPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, InvalidKeySpecException, IOException, ShortBufferException {
        SAFESeal revealer = new SAFESeal(this.cryptoFactory);
        revealer.setKeyAgreementMode(false);
        return revealer.reveal(sealedMessage, recipientPrivateKey, singleSenderPublicKey);
    }

    private byte[] reveal0(PublicKey singleSenderPublicKey, PrivateKey recipientPrivateKey, byte[] sealedMessage) throws NoSuchPaddingException, NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, BadPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, InvalidKeySpecException, IOException, ShortBufferException {
        SAFESeal revealer = new SAFESeal(this.cryptoFactory);
        revealer.setKeyAgreementMode(true);
        return revealer.reveal(sealedMessage, recipientPrivateKey, singleSenderPublicKey);
    }
}

