/*
 * Decompiled with CFR 0.152.
 */
package com.metabit.custom.safe.safeseal;

import com.metabit.custom.safe.iip2.SAFESeal2;
import com.metabit.custom.safe.safeseal.impl.CryptoFactoryImpl;
import com.metabit.custom.safe.safeseal.impl.SAFESeal;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class SAFESealSealer {
    private CryptoFactoryImpl cryptoFactory;
    private Provider securityProvider;
    private boolean compressionMode;
    private int version;

    public SAFESealSealer() {
        this.version = 2;
        this.init();
    }

    public SAFESealSealer(int version) {
        this.version = version;
        this.init();
    }

    public void setCompressionMode(boolean flag) {
        this.compressionMode = flag;
    }

    private void init() {
        this.securityProvider = Security.getProvider("BC");
        if (this.securityProvider == null) {
            this.securityProvider = new BouncyCastleProvider();
            Security.addProvider(this.securityProvider);
        }
        this.cryptoFactory = new CryptoFactoryImpl(this.securityProvider);
    }

    public byte[] seal(byte[] rawPrivateKeySender, byte[] rawPublicKeySingleRecipient, Long uniqueID, byte[] payloadToSeal) throws BadPaddingException {
        throw new UnsupportedOperationException();
    }

    public final byte[] seal(PrivateKey senderPrivateKey, PublicKey singleRecipientPublicKey, byte[] payloadToSeal, Long uniqueID) throws BadPaddingException {
        try {
            switch (this.version) {
                case 0: {
                    return this.seal0(senderPrivateKey, singleRecipientPublicKey, payloadToSeal, uniqueID);
                }
                case 1: {
                    return this.seal1(senderPrivateKey, singleRecipientPublicKey, payloadToSeal, uniqueID);
                }
                case 2: {
                    return this.seal2(senderPrivateKey, singleRecipientPublicKey, payloadToSeal, uniqueID);
                }
            }
            throw new UnsupportedOperationException("version not supported");
        }
        catch (IOException | InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | InvalidKeySpecException | IllegalBlockSizeException | NoSuchPaddingException | ShortBufferException e) {
            throw new RuntimeException(e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new RuntimeException(e);
        }
    }

    private byte[] seal2(PrivateKey senderPrivateKey, PublicKey singleRecipientPublicKey, byte[] payloadToSeal, Long uniqueID) throws NoSuchPaddingException, NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, ShortBufferException, InvalidKeySpecException, BadPaddingException, IOException {
        SAFESeal2 sealer = new SAFESeal2(this.cryptoFactory, 2, 0);
        sealer.setCompressionMode(this.compressionMode);
        PublicKey[] publicKeys = new PublicKey[]{singleRecipientPublicKey};
        byte[] payload = sealer.seal(payloadToSeal, senderPrivateKey, publicKeys, uniqueID);
        return payload;
    }

    private byte[] seal1(PrivateKey senderPrivateKey, PublicKey singleRecipientPublicKey, byte[] payloadToSeal, Long uniqueID) throws NoSuchPaddingException, NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, IllegalBlockSizeException, InvalidKeySpecException, BadPaddingException, IOException, ShortBufferException {
        SAFESeal sealer = new SAFESeal(this.cryptoFactory);
        sealer.setKeyAgreementMode(false);
        sealer.setCompressionMode(this.compressionMode);
        PublicKey[] publicKeys = new PublicKey[]{singleRecipientPublicKey};
        byte[] payload = sealer.seal(payloadToSeal, senderPrivateKey, publicKeys, uniqueID);
        return payload;
    }

    private byte[] seal0(PrivateKey senderPrivateKey, PublicKey singleRecipientPublicKey, byte[] payloadToSeal, Long uniqueID) throws NoSuchPaddingException, NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, IllegalBlockSizeException, InvalidKeySpecException, BadPaddingException, IOException, ShortBufferException {
        SAFESeal sealer = new SAFESeal(this.cryptoFactory);
        sealer.setKeyAgreementMode(true);
        sealer.setCompressionMode(this.compressionMode);
        PublicKey[] publicKeys = new PublicKey[]{singleRecipientPublicKey};
        byte[] payload = sealer.seal(payloadToSeal, senderPrivateKey, publicKeys, uniqueID);
        return payload;
    }
}

