/*
 * Decompiled with CFR 0.152.
 */
package com.metabit.custom.safe.safeseal.impl;

import com.metabit.custom.safe.iip.shared.AlgorithmSpec;
import com.metabit.custom.safe.iip.shared.CryptoFactory;
import com.metabit.custom.safe.iip.shared.SharedConstants;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import org.bouncycastle.asn1.sec.SECNamedCurves;
import org.bouncycastle.asn1.teletrust.TeleTrusTNamedCurves;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class CryptoFactoryImpl
implements CryptoFactory {
    private Provider securityProvider;

    public CryptoFactoryImpl() {
        this.securityProvider = Security.getProvider("BC");
        if (this.securityProvider == null) {
            this.securityProvider = new BouncyCastleProvider();
            Security.addProvider(this.securityProvider);
        }
    }

    public CryptoFactoryImpl(Provider securityProvider) {
        this.securityProvider = securityProvider;
    }

    @Override
    public Cipher getCipherFromCipherSpec(AlgorithmSpec algorithmSpec) throws NoSuchPaddingException, NoSuchAlgorithmException, NoSuchProviderException {
        switch (algorithmSpec.getType()) {
            case CIPHER: {
                if (algorithmSpec.getOID().getId().startsWith("1.3.6.1.4.1.21876.1.1.1.2.1.")) {
                    return this.getAESCBCNoPadding(algorithmSpec);
                }
                if (algorithmSpec.getOID().getId().equals(SharedConstants.OID_RSA_ECB.getId())) {
                    return this.getRSAECB(algorithmSpec);
                }
            }
            case DIGEST: {
                Cipher cipher = Cipher.getInstance(algorithmSpec.getOID().getId(), this.securityProvider);
                return cipher;
            }
        }
        throw new IllegalArgumentException("wrong type");
    }

    @Override
    public ECDomainParameters getEllipticCurve(AlgorithmSpec algorithmSpec) {
        if (algorithmSpec.getType() != AlgorithmSpec.Type.ELLIPTIC_CURVE) {
            throw new IllegalArgumentException("wrong type");
        }
        String curveName = algorithmSpec.getName();
        X9ECParameters curve = curveName.contains("brain") ? TeleTrusTNamedCurves.getByName(curveName) : SECNamedCurves.getByName(curveName);
        ECDomainParameters domain = new ECDomainParameters(curve.getCurve(), curve.getG(), curve.getN(), curve.getH());
        return domain;
    }

    private Cipher getRSAECB(AlgorithmSpec algorithmSpec) throws NoSuchPaddingException, NoSuchAlgorithmException, NoSuchProviderException {
        if (this.securityProvider.getName().equals("BC")) {
            return Cipher.getInstance("RSA/ECB/NoPadding", "BC");
        }
        if (this.securityProvider.getName().equals("SunJCE")) {
            return Cipher.getInstance("RSA/ECB/NoPadding", "SunJCE");
        }
        return Cipher.getInstance("RSA/ECB/NoPadding", this.securityProvider);
    }

    private Cipher getAESCBCNoPadding(AlgorithmSpec algorithmSpec) throws NoSuchPaddingException, NoSuchAlgorithmException, NoSuchProviderException {
        String type = algorithmSpec.getOID().getId().replace("1.3.6.1.4.1.21876.1.1.1.2.1.", "");
        int aesKeyLengthID = Integer.valueOf(type);
        switch (aesKeyLengthID) {
            case 2: 
            case 22: 
            case 42: {
                break;
            }
            default: {
                throw new NoSuchAlgorithmException();
            }
        }
        if (this.securityProvider.getName().equals("BC")) {
            return Cipher.getInstance("AES/CBC/NoPadding", "BC");
        }
        if (this.securityProvider.getName().equals("SunJCE")) {
            return Cipher.getInstance("AES/CBC/NoPadding", "SunJCE");
        }
        return Cipher.getInstance("AES/CBC/NoPadding", this.securityProvider);
    }
}

