/*
 * Decompiled with CFR 0.152.
 */
package com.metabit.custom.safe.safeseal.impl;

import com.metabit.custom.safe.iip.shared.AlgorithmSpec;
import com.metabit.custom.safe.iip.shared.AlgorithmSpecCollection;
import java.security.NoSuchAlgorithmException;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;

public final class CryptoSettingsStruct {
    private AlgorithmSpec encryption;
    private AlgorithmSpec padding;
    private AlgorithmSpec compression;
    private AlgorithmSpec sig1Algorithm;
    private AlgorithmSpec keyAgreementProtocol;
    private AlgorithmSpec keyAgreementCipher;
    private AlgorithmSpec keyDiversificationAlgorithm;
    private int encryptionKeySize;
    private int protocolVersion;

    public CryptoSettingsStruct(int version, AlgorithmSpec keyAgreementProtocolToUse, AlgorithmSpec keyAgreementCipherToUse, AlgorithmSpec keyDiversificationToUse, AlgorithmSpec encryptionToUse, AlgorithmSpec sig1Algorithm, AlgorithmSpec compressionUsed) {
        this.protocolVersion = version;
        this.compression = compressionUsed;
        this.padding = AlgorithmSpecCollection.IIP;
        this.encryption = encryptionToUse;
        this.keyDiversificationAlgorithm = keyDiversificationToUse;
        this.keyAgreementCipher = keyAgreementCipherToUse;
        this.keyAgreementProtocol = keyAgreementProtocolToUse;
        this.sig1Algorithm = sig1Algorithm;
    }

    public CryptoSettingsStruct(int version, int revision) {
        switch (version) {
            default: {
                throw new UnsupportedOperationException("revision not supported");
            }
            case 0: {
                switch (revision) {
                    default: {
                        throw new UnsupportedOperationException("revision not supported");
                    }
                    case 9: 
                }
                this.compression = AlgorithmSpecCollection.COMPRESSION_NONE;
                this.padding = AlgorithmSpecCollection.IIP;
                this.encryption = AlgorithmSpecCollection.AES256CBC_PADDED;
                this.keyAgreementProtocol = AlgorithmSpecCollection.ECDH;
                this.keyAgreementCipher = AlgorithmSpecCollection.ECSECP256R1;
                this.keyDiversificationAlgorithm = AlgorithmSpecCollection.SHA256;
                this.encryptionKeySize = this.encryption.getKeySizeInBit();
                this.sig1Algorithm = null;
                break;
            }
            case 1: {
                switch (revision) {
                    default: {
                        throw new UnsupportedOperationException("revision not supported");
                    }
                    case 0: {
                        this.compression = AlgorithmSpecCollection.COMPRESSION_NONE;
                        this.padding = AlgorithmSpecCollection.IIP;
                        this.encryption = AlgorithmSpecCollection.RSA2048;
                        this.encryptionKeySize = this.encryption.getKeySizeInBit();
                        this.sig1Algorithm = null;
                        this.keyAgreementProtocol = null;
                        this.keyAgreementCipher = null;
                        this.keyDiversificationAlgorithm = null;
                        break;
                    }
                    case 1: {
                        this.compression = AlgorithmSpecCollection.COMPRESSION_GZIP;
                        this.padding = AlgorithmSpecCollection.IIP;
                        this.encryption = AlgorithmSpecCollection.RSA2048;
                        this.encryptionKeySize = this.encryption.getKeySizeInBit();
                        this.sig1Algorithm = null;
                        this.keyAgreementProtocol = null;
                        this.keyAgreementCipher = null;
                        this.keyDiversificationAlgorithm = null;
                    }
                }
            }
            case 2: {
                switch (revision) {
                    default: {
                        throw new UnsupportedOperationException("revision not supported");
                    }
                    case 0: 
                    case 1: 
                }
                this.compression = AlgorithmSpecCollection.COMPRESSION_NONE;
                this.padding = AlgorithmSpecCollection.IIP2;
                this.encryption = AlgorithmSpecCollection.RSA2048;
                this.encryptionKeySize = this.encryption.getKeySizeInBit();
                this.sig1Algorithm = AlgorithmSpecCollection.AES256CBC;
                this.keyAgreementProtocol = null;
                this.keyAgreementCipher = null;
                this.keyDiversificationAlgorithm = null;
            }
        }
        this.protocolVersion = version;
    }

    public AlgorithmSpec getKeyAgreementProtocol() {
        return this.keyAgreementProtocol;
    }

    public ASN1ObjectIdentifier getKeyAgreementProtocolOID() {
        return this.keyAgreementProtocol != null ? this.keyAgreementProtocol.getOID() : null;
    }

    public AlgorithmSpec getKeyAgreementCipher() {
        return this.keyAgreementCipher;
    }

    public ASN1ObjectIdentifier getKeyAgreementCipherOID() {
        return this.keyAgreementCipher != null ? this.keyAgreementCipher.getOID() : null;
    }

    void setKeyAgreementCipherOID(ASN1ObjectIdentifier oid) throws NoSuchAlgorithmException {
        this.keyAgreementCipher = this.lookupValidatedByOID(oid, AlgorithmSpec.Type.ELLIPTIC_CURVE);
    }

    public AlgorithmSpec getKeyDiversificationAlgorithm() {
        return this.keyDiversificationAlgorithm;
    }

    public ASN1ObjectIdentifier getKeyDiversificationOID() {
        return this.keyDiversificationAlgorithm != null ? this.keyDiversificationAlgorithm.getOID() : null;
    }

    void setKeyDiversificationOID(ASN1ObjectIdentifier oid) throws NoSuchAlgorithmException {
        this.keyDiversificationAlgorithm = this.lookupValidatedByOID(oid, AlgorithmSpec.Type.DIGEST);
    }

    public AlgorithmSpec getEncryption() {
        return this.encryption;
    }

    public ASN1ObjectIdentifier getEncryptionOID() {
        return this.encryption != null ? this.encryption.getOID() : null;
    }

    void setEncryptionOID(ASN1ObjectIdentifier oid) throws NoSuchAlgorithmException {
        this.encryption = this.lookupValidatedByOID(oid, AlgorithmSpec.Type.CIPHER);
    }

    public AlgorithmSpec getPadding() {
        return this.padding;
    }

    public ASN1ObjectIdentifier getPaddingOID() {
        return this.padding != null ? this.padding.getOID() : null;
    }

    void setPaddingOID(ASN1ObjectIdentifier oid) throws NoSuchAlgorithmException {
        this.padding = this.lookupValidatedByOID(oid, AlgorithmSpec.Type.PADDING);
    }

    public AlgorithmSpec getCompression() {
        return this.compression;
    }

    public ASN1ObjectIdentifier getCompressionOID() {
        return this.compression != null ? this.compression.getOID() : null;
    }

    public void setCompressionOID(ASN1ObjectIdentifier oid) throws NoSuchAlgorithmException {
        this.compression = this.lookupValidatedByOID(oid, AlgorithmSpec.Type.COMPRESSION);
    }

    void setKeyAgreementProtocolByOID(ASN1ObjectIdentifier oid) throws NoSuchAlgorithmException {
        this.keyAgreementProtocol = this.lookupValidatedByOID(oid, AlgorithmSpec.Type.KEY_AGREEMENT);
    }

    private AlgorithmSpec lookupValidatedByOID(ASN1ObjectIdentifier oid, AlgorithmSpec.Type expectedType) throws NoSuchAlgorithmException {
        if (oid == null) {
            return null;
        }
        AlgorithmSpec spec = AlgorithmSpecCollection.lookupByOID(oid);
        if (spec == null) {
            throw new NoSuchAlgorithmException("algorithm not supported in current implementation: " + oid.getId());
        }
        if (spec.getType() != expectedType) {
            throw new NoSuchAlgorithmException("algorithm used in wrong function: " + oid.getId());
        }
        return spec;
    }

    public boolean validate() {
        if (this.getPadding().equals(AlgorithmSpecCollection.IIP)) {
            if (this.encryption == null) {
                return false;
            }
            if (this.keyAgreementProtocol != null) {
                if (this.keyAgreementProtocol != AlgorithmSpecCollection.ECDH) {
                    return false;
                }
                if (this.keyDiversificationAlgorithm == null) {
                    return false;
                }
            }
        } else if (this.getPadding().equals(AlgorithmSpecCollection.IIP2)) {
            if (this.encryption == null) {
                return false;
            }
            if (this.sig1Algorithm == null) {
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    public void setEncryptionKeySize(int encryptionKeySize) {
        this.encryptionKeySize = encryptionKeySize;
    }

    public int getEncryptionKeySize() {
        return this.encryptionKeySize;
    }

    public ASN1ObjectIdentifier getSig1AlgorithmOID() {
        return this.sig1Algorithm != null ? this.sig1Algorithm.getOID() : null;
    }

    void setSig1AlgorithmByOID(ASN1ObjectIdentifier oid) throws NoSuchAlgorithmException {
        if (this.sig1Algorithm.isAsymmetricCipher()) {
            throw new IllegalArgumentException("symmetric algorithms only");
        }
        this.sig1Algorithm = this.lookupValidatedByOID(oid, AlgorithmSpec.Type.CIPHER);
    }

    public int getSig1KeySize() {
        return this.sig1Algorithm == null ? 0 : this.sig1Algorithm.getKeySizeInBit();
    }

    public AlgorithmSpec getSig1() {
        return this.sig1Algorithm;
    }

    public int getProtocolVersion() {
        return this.protocolVersion;
    }

    public void setProtocolVersion(int protocolVersion) {
        this.protocolVersion = protocolVersion;
    }
}

