/*
 * Decompiled with CFR 0.152.
 */
package com.metabit.custom.safe.safeseal.impl;

import com.metabit.custom.safe.iip.SharedCode;
import com.metabit.custom.safe.iip.shared.AlgorithmSpecCollection;
import com.metabit.custom.safe.safeseal.impl.CryptoSettingsStruct;
import java.security.Provider;
import java.security.Security;
import javax.crypto.SecretKey;

public class InternalTransportTuple {
    byte[] keyDiversificationData;
    byte[] cryptoIV;
    byte[] encryptedData;
    CryptoSettingsStruct cryptoSettings;
    SecretKey phase1Key;
    byte[] phase1IV;
    SecretKey phase2Key;
    byte[] phase2IV;
    SecretKey phase3Key;
    byte[] phase3IV;
    private byte[] ephemeralSymmetricKey1;
    private byte[] ephemeralSymmetricKey2;
    private byte[] ephemeralSymmetricKey3;

    public InternalTransportTuple(CryptoSettingsStruct css) {
        this.cryptoSettings = css;
    }

    @Deprecated
    InternalTransportTuple(byte[] encryptedData, Long uniqueID) {
        this.cryptoSettings = new CryptoSettingsStruct(0, 9);
        this.cryptoSettings.setProtocolVersion(1);
        this.encryptedData = encryptedData;
        this.setDiversification(uniqueID);
    }

    @Deprecated
    InternalTransportTuple(byte[] encryptedData, Long uniqueID, String asymmetricAlgorithm, String symmetricAlgorithm) {
        this.cryptoSettings = new CryptoSettingsStruct(0, 9);
        this.cryptoSettings.setProtocolVersion(1);
        this.encryptedData = encryptedData;
        this.setDiversification(uniqueID);
        Provider bc = Security.getProvider("BC");
    }

    @Deprecated
    InternalTransportTuple(boolean withKeyAgreement) {
        this.cryptoSettings = withKeyAgreement ? new CryptoSettingsStruct(1, AlgorithmSpecCollection.ECDH, AlgorithmSpecCollection.ECSECP256R1, AlgorithmSpecCollection.SHA256, AlgorithmSpecCollection.AES256CBC_PADDED, AlgorithmSpecCollection.AES256CBC_PADDED, AlgorithmSpecCollection.COMPRESSION_NONE) : new CryptoSettingsStruct(1, null, null, null, AlgorithmSpecCollection.RSA2048, AlgorithmSpecCollection.AES256CBC_PADDED, AlgorithmSpecCollection.COMPRESSION_NONE);
    }

    public int getProtocolVersion() {
        return this.cryptoSettings.getProtocolVersion();
    }

    public void setDiversification(Long numericalValue) {
        this.keyDiversificationData = new byte[8];
        SharedCode.write8ByteUnsignedLongToBuffer(numericalValue, this.keyDiversificationData);
    }

    public byte[] getEncryptedData() {
        return this.encryptedData;
    }

    public void setEncryptedData(byte[] encryptedData) {
        this.encryptedData = encryptedData;
    }

    public byte[] getKeyDiversificationData() {
        return this.keyDiversificationData;
    }

    public void setKeyDiversificationData(byte[] keyDiversificationData) {
        this.keyDiversificationData = keyDiversificationData;
    }

    public CryptoSettingsStruct getCryptoSettings() {
        return this.cryptoSettings;
    }

    public void setCryptoIV(byte[] cryptoIV) {
        this.cryptoIV = cryptoIV;
    }

    public byte[] getCryptoIV() {
        return this.cryptoIV;
    }

    public void setEphemeralSymmetricKeyBytes(byte[] key1data, byte[] key2data, byte[] key3data) {
        this.ephemeralSymmetricKey1 = key1data;
        this.ephemeralSymmetricKey2 = key2data;
        this.ephemeralSymmetricKey3 = key3data;
    }

    public byte[] getEphemeralSymmetricKeyBytes(int index) {
        switch (index) {
            default: {
                throw new IllegalArgumentException();
            }
            case 1: {
                return this.ephemeralSymmetricKey1;
            }
            case 2: {
                return this.ephemeralSymmetricKey2;
            }
            case 3: 
        }
        return this.ephemeralSymmetricKey3;
    }

    public SecretKey getEphemeralSymmetricKey1() {
        return this.phase1Key;
    }

    public SecretKey getEphemeralSymmetricKey2() {
        return this.phase2Key;
    }

    public SecretKey getEphemeralSymmetricKey3() {
        return this.phase3Key;
    }
}

