/*
 * Decompiled with CFR 0.152.
 */
package com.metabit.custom.safe.safeseal.impl;

import com.metabit.custom.safe.iip.AsymmetricEncryptionWithIIP;
import com.metabit.custom.safe.iip.ECDHEWithIntegrityPadding;
import com.metabit.custom.safe.iip.RSAWithIntegrityPadding;
import com.metabit.custom.safe.iip.shared.AlgorithmSpecCollection;
import com.metabit.custom.safe.iip.shared.CryptoFactory;
import com.metabit.custom.safe.safeseal.impl.InternalTransportTuple;
import com.metabit.custom.safe.safeseal.impl.TransportFormatConverter;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.crypto.DataLengthException;

public class SAFESeal {
    private final CryptoFactory cryptoFactory;
    private TransportFormatConverter formatConverter;
    private AsymmetricEncryptionWithIIP asymmetricLayer;
    private boolean keyAgreementMode;
    private boolean compressionMode;

    public SAFESeal(CryptoFactory cf) throws NoSuchPaddingException, NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        this.cryptoFactory = cf;
        this.keyAgreementMode = false;
        this.compressionMode = false;
        this.init();
    }

    private static byte[] tryToCompress(byte[] rawPayload, InternalTransportTuple itt) throws NoSuchAlgorithmException {
        byte[] payload;
        int inputSize = rawPayload.length;
        byte[] tmp = new byte[inputSize];
        Deflater deflater = new Deflater(9, true);
        deflater.setInput(rawPayload);
        deflater.finish();
        int outputSize = deflater.deflate(tmp);
        if (outputSize >= inputSize) {
            payload = rawPayload;
            itt.cryptoSettings.setCompressionOID(AlgorithmSpecCollection.COMPRESSION_NONE.getOID());
        } else {
            payload = new byte[outputSize];
            System.arraycopy(tmp, 0, payload, 0, outputSize);
            itt.cryptoSettings.setCompressionOID(AlgorithmSpecCollection.COMPRESSION_GZIP.getOID());
        }
        deflater.end();
        return payload;
    }

    public boolean getKeyAgreementMode() {
        return this.keyAgreementMode;
    }

    public void setKeyAgreementMode(boolean keyAgreementUsed) {
        this.keyAgreementMode = keyAgreementUsed;
        this.compressionMode = false;
        this.init();
    }

    private void init() {
        this.formatConverter = new TransportFormatConverter();
    }

    public byte[] seal(byte[] contentToSeal, PrivateKey senderKey, PublicKey[] recipientKeys, Long uniqueID) throws NoSuchPaddingException, NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, IllegalBlockSizeException, InvalidKeySpecException, BadPaddingException, IOException, ShortBufferException {
        InternalTransportTuple itt;
        if (this.keyAgreementMode) {
            this.asymmetricLayer = new ECDHEWithIntegrityPadding(this.cryptoFactory, AlgorithmSpecCollection.AES256ECB_PADDED);
            itt = new InternalTransportTuple(true);
            itt.setDiversification(uniqueID);
        } else {
            String description = senderKey.toString();
            Pattern keyLengthFromDescription = Pattern.compile(".+RSA private CRT key,\\s+(\\d{4})\\sbits(?m:$)");
            Matcher matcher = keyLengthFromDescription.matcher(description);
            if (!matcher.find()) {
                throw new UnsupportedOperationException("could not determine key size");
            }
            int privateKeyLength = Integer.valueOf(matcher.group(1));
            switch (privateKeyLength) {
                case 1024: {
                    this.asymmetricLayer = new RSAWithIntegrityPadding(this.cryptoFactory, AlgorithmSpecCollection.RSA1024);
                    break;
                }
                case 2048: {
                    this.asymmetricLayer = new RSAWithIntegrityPadding(this.cryptoFactory, AlgorithmSpecCollection.RSA2048);
                    break;
                }
                case 4096: {
                    this.asymmetricLayer = new RSAWithIntegrityPadding(this.cryptoFactory, AlgorithmSpecCollection.RSA4096);
                    break;
                }
                default: {
                    throw new InvalidKeySpecException("key of unsupported size " + privateKeyLength);
                }
            }
            itt = new InternalTransportTuple(false);
            itt.cryptoSettings.setEncryptionKeySize(privateKeyLength);
        }
        byte[] payload = !this.compressionMode ? contentToSeal : SAFESeal.tryToCompress(contentToSeal, itt);
        itt.encryptedData = this.asymmetricLayer.padEncryptAndPackage(payload, recipientKeys, senderKey, itt.getKeyDiversificationData());
        itt.cryptoIV = this.asymmetricLayer.getSymmetricIV();
        return this.formatConverter.wrapForTransport(itt);
    }

    public byte[] reveal(byte[] sealedInput, PrivateKey recipientKey, PublicKey senderPublicKey) throws BadPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, NoSuchAlgorithmException, InvalidKeySpecException, InvalidKeyException, NoSuchPaddingException, NoSuchProviderException, IOException, ShortBufferException {
        InternalTransportTuple tuple = this.formatConverter.unwrapTransportFormat(sealedInput);
        ASN1ObjectIdentifier compressionOID = tuple.cryptoSettings.getCompressionOID();
        if (compressionOID.equals(AlgorithmSpecCollection.COMPRESSION_GZIP.getOID())) {
            this.compressionMode = true;
        } else if (compressionOID.equals(AlgorithmSpecCollection.COMPRESSION_NONE.getOID())) {
            this.compressionMode = false;
        } else {
            throw new NoSuchAlgorithmException("invalid compression");
        }
        if (this.keyAgreementMode) {
            this.asymmetricLayer = new ECDHEWithIntegrityPadding(this.cryptoFactory, AlgorithmSpecCollection.AES256ECB_PADDED);
        } else {
            switch (tuple.cryptoSettings.getEncryptionKeySize()) {
                case 1024: {
                    this.asymmetricLayer = new RSAWithIntegrityPadding(this.cryptoFactory, AlgorithmSpecCollection.RSA1024);
                    break;
                }
                case 2048: {
                    this.asymmetricLayer = new RSAWithIntegrityPadding(this.cryptoFactory, AlgorithmSpecCollection.RSA2048);
                    break;
                }
                case 4096: {
                    this.asymmetricLayer = new RSAWithIntegrityPadding(this.cryptoFactory, AlgorithmSpecCollection.RSA4096);
                    break;
                }
                default: {
                    throw new InvalidKeyException("specified key size not supported");
                }
            }
        }
        try {
            byte[] payload = this.asymmetricLayer.decryptAndVerify(tuple.encryptedData, senderPublicKey, recipientKey, tuple.keyDiversificationData, tuple.cryptoIV);
            if (this.compressionMode) {
                payload = this.inflateZLIBcompressedData(payload);
            }
            return payload;
        }
        catch (ArrayIndexOutOfBoundsException | DataFormatException | DataLengthException ex) {
            throw new BadPaddingException();
        }
    }

    private byte[] inflateZLIBcompressedData(byte[] payload) throws DataFormatException {
        int outputSize;
        Inflater inflater = new Inflater(true);
        int inputSize = payload.length;
        int tmpSize = 0;
        do {
            inflater.setInput(payload);
            byte[] tmp = new byte[tmpSize += inputSize];
            outputSize = inflater.inflate(tmp);
            if (outputSize == 0) {
                throw new IllegalArgumentException("input compression level not handled");
            }
            inflater.reset();
        } while (tmpSize == outputSize);
        byte[] result = new byte[outputSize];
        inflater.setInput(payload);
        inflater.inflate(result);
        inflater.end();
        return result;
    }

    public boolean getCompressionMode() {
        return this.compressionMode;
    }

    public void setCompressionMode(boolean compressionMode) {
        this.compressionMode = compressionMode;
    }
}

