/*
 * Decompiled with CFR 0.152.
 */
package com.metabit.custom.safe.safeseal.impl;

import com.metabit.custom.safe.iip.shared.SharedConstants;
import com.metabit.custom.safe.safeseal.impl.InternalTransportTuple;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERSequenceGenerator;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.DLSequence;

public class TransportFormatConverter {
    private ASN1ObjectIdentifier keyAgreementProtocolOID;
    private ASN1ObjectIdentifier ecAlgorithmOID;
    private ASN1ObjectIdentifier keyDiversificationOID;
    private ASN1ObjectIdentifier encryptionOID;
    private ASN1ObjectIdentifier compressionOID;
    private ASN1Encodable keyReference;

    public byte[] wrapForTransport(InternalTransportTuple ids) throws IOException {
        this.keyAgreementProtocolOID = ids.cryptoSettings.getKeyAgreementProtocolOID();
        this.ecAlgorithmOID = ids.cryptoSettings.getKeyAgreementCipherOID();
        this.keyDiversificationOID = ids.cryptoSettings.getKeyDiversificationOID();
        this.encryptionOID = ids.cryptoSettings.getEncryptionOID();
        this.compressionOID = ids.cryptoSettings.getCompressionOID();
        ASN1EncodableVector ecDetails = null;
        this.keyReference = null;
        ASN1EncodableVector encryptionPart = new ASN1EncodableVector();
        switch (ids.getProtocolVersion()) {
            case 1: {
                encryptionPart.add(SharedConstants.OID_IIP_ALGORITHM);
                break;
            }
            case 2: {
                encryptionPart.add(SharedConstants.OID_IIP2_ALGORITHM);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid protocol version");
            }
        }
        encryptionPart.add(new DERTaggedObject(128, 0, (ASN1Encodable)this.encryptionOID));
        if (this.compressionOID != null) {
            encryptionPart.add(new DERTaggedObject(128, 1, (ASN1Encodable)this.compressionOID));
        }
        encryptionPart.add(new DERTaggedObject(128, 2, (ASN1Encodable)new ASN1Integer(ids.cryptoSettings.getEncryptionKeySize())));
        if (ids.getProtocolVersion() == 2) {
            ASN1EncodableVector ephemeralSymmetricKeys = new ASN1EncodableVector();
            ephemeralSymmetricKeys.add(new DEROctetString(ids.getEphemeralSymmetricKeyBytes(1)));
            ephemeralSymmetricKeys.add(new DEROctetString(ids.getEphemeralSymmetricKeyBytes(2)));
            ephemeralSymmetricKeys.add(new DEROctetString(ids.getEphemeralSymmetricKeyBytes(3)));
            encryptionPart.add(new DERTaggedObject(128, 4, (ASN1Encodable)new DERSequence(ephemeralSymmetricKeys)));
        }
        if (ids.cryptoIV != null) {
            encryptionPart.add(new DEROctetString(ids.cryptoIV));
        }
        DERTaggedObject firstSequence = new DERTaggedObject(64, 0, (ASN1Encodable)new DERSequence(encryptionPart));
        ASN1EncodableVector keyAgreementPart = new ASN1EncodableVector();
        if (this.keyAgreementProtocolOID != null) {
            keyAgreementPart.add(this.keyAgreementProtocolOID);
            keyAgreementPart.add(new DEROctetString(ids.keyDiversificationData));
            keyAgreementPart.add(new DERTaggedObject(128, 0, (ASN1Encodable)this.keyDiversificationOID));
            if (this.ecAlgorithmOID != null) {
                keyAgreementPart.add(new DERTaggedObject(128, 1, (ASN1Encodable)this.ecAlgorithmOID));
            }
            if (ecDetails != null) {
                keyAgreementPart.add(new DERTaggedObject(128, 2, (ASN1Encodable)new DERSequence(ecDetails)));
            }
            if (this.keyReference != null) {
                keyAgreementPart.add(new DERTaggedObject(128, 3, (ASN1Encodable)new DERSequence(this.keyReference)));
            }
        }
        DERTaggedObject secondSequence = new DERTaggedObject(64, 1, (ASN1Encodable)new DERSequence(keyAgreementPart));
        ASN1EncodableVector authenticityPart = new ASN1EncodableVector();
        DERTaggedObject thirdSequence = new DERTaggedObject(64, 2, (ASN1Encodable)new DERSequence(authenticityPart));
        ByteArrayOutputStream bufferStream = new ByteArrayOutputStream();
        DERSequenceGenerator out = new DERSequenceGenerator(bufferStream);
        out.addObject(SharedConstants.OID_SAFE_SEAL);
        out.addObject(new ASN1Integer(ids.getProtocolVersion()));
        out.addObject(firstSequence);
        out.addObject(secondSequence);
        out.addObject(thirdSequence);
        out.addObject(new DEROctetString(ids.encryptedData));
        out.close();
        return bufferStream.toByteArray();
    }

    public InternalTransportTuple unwrapTransportFormat(byte[] transportWrapped) throws IllegalArgumentException, UnsupportedOperationException {
        InternalTransportTuple result = new InternalTransportTuple(false);
        try {
            DLSequence apseq;
            ASN1Sequence seq = ASN1Sequence.getInstance(transportWrapped);
            ASN1ObjectIdentifier procedureOID = ASN1ObjectIdentifier.getInstance(seq.getObjectAt(0));
            ASN1Integer procedureVersion = ASN1Integer.getInstance(seq.getObjectAt(1));
            if (!SharedConstants.OID_SAFE_SEAL.equals(procedureOID)) {
                throw new IllegalArgumentException("different format (protocol OID mismatch)");
            }
            switch (procedureVersion.intPositiveValueExact()) {
                default: {
                    throw new IllegalArgumentException("format version not supported");
                }
                case 1: 
                case 2: 
            }
            ASN1TaggedObject encryptionPart = ASN1TaggedObject.getInstance(seq.getObjectAt(2), 64, 0);
            ASN1TaggedObject keyAgreementPart = ASN1TaggedObject.getInstance(seq.getObjectAt(3), 64, 1);
            ASN1TaggedObject authPart = ASN1TaggedObject.getInstance(seq.getObjectAt(4), 64, 2);
            ASN1OctetString encryptedPayload = DEROctetString.getInstance(seq.getObjectAt(5));
            result.encryptedData = encryptedPayload.getOctets();
            DLSequence symseq = (DLSequence)encryptionPart.getBaseUniversal(true, 16);
            Enumeration symParmObjs = symseq.getObjects();
            block40: while (symParmObjs.hasMoreElements()) {
                Object entry = symParmObjs.nextElement();
                switch (entry.getClass().getSimpleName()) {
                    case "DEROctetString": {
                        result.cryptoIV = DEROctetString.getInstance(entry).getOctets();
                        continue block40;
                    }
                    case "ASN1ObjectIdentifier": {
                        result.cryptoSettings.setPaddingOID(ASN1ObjectIdentifier.getInstance(entry));
                        continue block40;
                    }
                    case "DLTaggedObject": 
                    case "DLApplicationSpecific": {
                        ASN1TaggedObject taggedObject = ASN1TaggedObject.getInstance(entry);
                        if (taggedObject.getTagClass() != 128) {
                            throw new IllegalArgumentException("tag class mismatch " + taggedObject.getTagClass());
                        }
                        switch (taggedObject.getTagNo()) {
                            case 0: {
                                result.cryptoSettings.setEncryptionOID(ASN1ObjectIdentifier.getInstance(taggedObject.getBaseUniversal(true, 6)));
                                continue block40;
                            }
                            case 1: {
                                result.cryptoSettings.setCompressionOID(ASN1ObjectIdentifier.getInstance(taggedObject.getBaseUniversal(true, 6)));
                                continue block40;
                            }
                            case 2: {
                                result.cryptoSettings.setEncryptionKeySize(ASN1Integer.getInstance(taggedObject.getBaseUniversal(true, 2)).intPositiveValueExact());
                                continue block40;
                            }
                            case 3: {
                                int nonceSizeInBit = ASN1Integer.getInstance(taggedObject.getBaseUniversal(true, 2)).intPositiveValueExact();
                                if (nonceSizeInBit == 32) continue block40;
                                throw new IllegalArgumentException("this version uses fixed nonce size.");
                            }
                            case 4: {
                                if (procedureVersion.intPositiveValueExact() != 2) {
                                    throw new IllegalArgumentException("version to structure mismatch");
                                }
                                DLSequence ephemeralKeySequence = (DLSequence)taggedObject.getBaseUniversal(true, 16);
                                ASN1OctetString key1Data = ASN1OctetString.getInstance(ephemeralKeySequence.getObjectAt(0));
                                ASN1OctetString key2Data = ASN1OctetString.getInstance(ephemeralKeySequence.getObjectAt(1));
                                ASN1OctetString key3Data = ASN1OctetString.getInstance(ephemeralKeySequence.getObjectAt(2));
                                result.setEphemeralSymmetricKeyBytes(key1Data.getOctets(), key2Data.getOctets(), key3Data.getOctets());
                                continue block40;
                            }
                        }
                        throw new IllegalArgumentException("tag " + taggedObject.getTagNo() + " not handled");
                    }
                }
                throw new IllegalArgumentException("ASN.1 class " + entry.getClass().getSimpleName() + " not handled");
            }
            DLSequence kaseq = (DLSequence)keyAgreementPart.getBaseUniversal(true, 16);
            if (kaseq.size() > 0) {
                Enumeration kaseqObjects = kaseq.getObjects();
                block41: while (kaseqObjects.hasMoreElements()) {
                    Object entry = kaseqObjects.nextElement();
                    switch (entry.getClass().getSimpleName()) {
                        case "ASN1ObjectIdentifier": {
                            result.cryptoSettings.setKeyAgreementProtocolByOID(ASN1ObjectIdentifier.getInstance(entry));
                            continue block41;
                        }
                        case "DEROctetString": {
                            result.setKeyDiversificationData(DEROctetString.getInstance(entry).getOctets());
                            continue block41;
                        }
                        case "DLTaggedObject": 
                        case "DLApplicationSpecific": {
                            ASN1TaggedObject taggedObject = ASN1TaggedObject.getInstance(entry);
                            if (taggedObject.getTagClass() != 128) {
                                throw new IllegalArgumentException("tag class mismatch " + taggedObject.getTagClass());
                            }
                            switch (taggedObject.getTagNo()) {
                                case 0: {
                                    this.keyDiversificationOID = ASN1ObjectIdentifier.getInstance(taggedObject.getBaseUniversal(true, 6));
                                    result.cryptoSettings.setKeyDiversificationOID(this.keyDiversificationOID);
                                    continue block41;
                                }
                                case 1: {
                                    this.ecAlgorithmOID = ASN1ObjectIdentifier.getInstance(taggedObject.getBaseUniversal(true, 6));
                                    result.cryptoSettings.setKeyAgreementCipherOID(this.ecAlgorithmOID);
                                    continue block41;
                                }
                                case 2: {
                                    throw new IllegalArgumentException("version mismatch; EC parameters not supported in this version.");
                                }
                                case 3: {
                                    throw new IllegalArgumentException("version mismatch; public key reference not supported in this version");
                                }
                            }
                            throw new IllegalArgumentException("format error");
                        }
                    }
                    throw new IllegalArgumentException("ASN.1 class " + entry.getClass().getSimpleName() + " not handled");
                }
            }
            if (authPart == null || (apseq = (DLSequence)authPart.getBaseUniversal(true, 16)).size() > 0) {
                // empty if block
            }
            if (!result.cryptoSettings.validate()) {
                throw new IllegalArgumentException("format consistency error");
            }
        }
        catch (ArithmeticException | IllegalArgumentException | IllegalStateException | NoSuchAlgorithmException ex) {
            throw new IllegalArgumentException("Exception during parsing", ex);
        }
        return result;
    }
}

