/*
 * Decompiled with CFR 0.152.
 */
package de.safe_ev.transparenzsoftware;

import de.safe_ev.transparenzsoftware.gui.TransparenzSoftwareMain;
import de.safe_ev.transparenzsoftware.i18n.Translator;
import de.safe_ev.transparenzsoftware.output.ConsoleFileProcessor;
import de.safe_ev.transparenzsoftware.verification.VerificationParserFactory;
import javax.swing.UIManager;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;

public class Transparenzsoftware {
    private static final Logger LOGGER = LogManager.getLogger(Transparenzsoftware.class);
    private static boolean testEnvironment;

    static void main(String[] args, boolean testEnvironment) throws Exception {
        Transparenzsoftware.testEnvironment = testEnvironment;
        Transparenzsoftware.main(args);
    }

    public static void main(String[] args) throws Exception {
        block15: {
            try {
                String cn = UIManager.getSystemLookAndFeelClassName();
                UIManager.setLookAndFeel(cn);
            }
            catch (Exception cn) {
                // empty catch block
            }
            VerificationParserFactory factory = new VerificationParserFactory();
            DefaultParser commandLineParser = new DefaultParser();
            Options options = Transparenzsoftware.setUpCliOptions();
            try {
                CommandLine commandLine = commandLineParser.parse(options, args);
                if (commandLine.hasOption("v")) {
                    Transparenzsoftware.setUpVerboseLogging();
                }
                if (commandLine.hasOption("l")) {
                    String optionValue = commandLine.getOptionValue("l");
                    Translator.init(optionValue);
                }
                String filePath = null;
                if (commandLine.hasOption("f")) {
                    filePath = commandLine.getOptionValue("f");
                }
                if (commandLine.hasOption("w")) {
                    filePath = commandLine.getOptionValue("f");
                }
                if (commandLine.hasOption("h")) {
                    LOGGER.debug("print help");
                    Transparenzsoftware.printHelp(options);
                    break block15;
                }
                if (!commandLine.hasOption("cli")) {
                    try {
                        TransparenzSoftwareMain.initWithParser(factory, filePath);
                        break block15;
                    }
                    catch (Exception e) {
                        LOGGER.error("Error on main window", (Throwable)e);
                        Transparenzsoftware.exit(0);
                        return;
                    }
                }
                if (filePath == null) {
                    Transparenzsoftware.printHelp(options);
                    System.err.println(Translator.get("error.no.input.file"));
                    Transparenzsoftware.exit(0);
                    return;
                }
                String outputPath = null;
                boolean overwrite = false;
                if (commandLine.hasOption("o")) {
                    outputPath = commandLine.getOptionValue("o");
                }
                if (commandLine.hasOption("w")) {
                    overwrite = true;
                }
                LOGGER.info("Read in file " + filePath);
                ConsoleFileProcessor fileProcessor = new ConsoleFileProcessor(factory);
                boolean result = fileProcessor.processFile(filePath, outputPath, overwrite);
                Transparenzsoftware.exit(result ? 2 : 0);
            }
            catch (ParseException e) {
                LOGGER.error(Translator.get("error.invalid.input.parameters"));
                System.err.println(Translator.get("error.invalid.input.parameters"));
                Transparenzsoftware.printHelp(options);
            }
        }
    }

    private static void exit(int code) {
        if (!testEnvironment) {
            System.exit(code);
        } else {
            LOGGER.info(String.format("App started and resulted and exited with code %s", code));
        }
    }

    private static void printHelp(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("ant", options);
    }

    private static void setUpVerboseLogging() {
        LoggerContext ctx = (LoggerContext)LogManager.getContext(false);
        Configuration config = ctx.getConfiguration();
        LoggerConfig loggerConfig = config.getLoggerConfig("");
        loggerConfig.setLevel(Level.DEBUG);
        ctx.updateLoggers();
    }

    private static Options setUpCliOptions() {
        Options options = new Options();
        options.addOption("v", "verbose", false, "Enables verbose logging in the stdout");
        options.addOption("f", "file", true, "Path to a file which should be read. If in cli mode it will be directly, processed. If it is opened with the gui, the file will opened automatically.");
        options.addOption("l", "locale", true, "Choose the the language which will be used in the gui and for messages. Currently there is english (en_EN) and german (de_DE) present. If an invalid locale or no locale is given, the app will try to use the default settings of the system. If it is neither german or english, english will be used.");
        options.addOption("o", "output", true, "File where the output should be written to. If the file does not exist, the app will try to create it. Content that has been there will not be overwritten");
        options.addOption("w", "write", false, "Overwrite the output file if it already exists.");
        options.addOption("h", "help", false, "Print that help page");
        options.addOption("cli", false, "Command line mode. This means no gui will be opened. Must always be with called with a -f parameter");
        return options;
    }
}

