/*
 * Decompiled with CFR 0.152.
 */
package de.safe_ev.transparenzsoftware;

import de.safe_ev.transparenzsoftware.verification.DecodingException;
import de.safe_ev.transparenzsoftware.verification.EncodingType;
import java.math.BigInteger;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Utils {
    private static final char[] HEX_ARRAY = "0123456789ABCDEF".toCharArray();
    private static final Logger LOGGER = LogManager.getLogger(Utils.class);

    public static String toFormattedHex(byte[] bytes) {
        return Utils.toFormattedHex(bytes, 2);
    }

    public static String toFormattedHex(byte[] bytes, int groupSize) {
        String hex = Utils.bytesToHex(bytes);
        return Utils.splitStringToGroups(hex, groupSize);
    }

    public static String splitStringToGroups(String toSplit, int groupSize) {
        return Utils.splitStringToGroups(toSplit, groupSize, " ");
    }

    public static String splitStringToGroups(String toSplit, int groupSize, String delimiter) {
        StringBuilder builder = new StringBuilder();
        int count = 0;
        for (char a : toSplit.toCharArray()) {
            builder.append(a);
            if (++count % groupSize != 0) continue;
            builder.append(delimiter);
        }
        return builder.toString().trim();
    }

    public static String toFormattedHex(byte bytes) {
        return Utils.bytesToHex(new byte[]{bytes});
    }

    public static String debugHexString(byte[] bytes) {
        String hex = Utils.bytesToHex(bytes);
        StringBuilder builder = new StringBuilder();
        int count = 0;
        for (char a : hex.toCharArray()) {
            if (++count % 2 == 1) {
                builder.append(String.format("Pos %d ", count / 2));
            }
            builder.append(a);
            if (count % 2 != 0) continue;
            builder.append("\n");
        }
        return builder.toString().trim();
    }

    public static byte[] reverseByteOrder(byte[] toReverse) {
        byte[] switched = new byte[toReverse.length];
        int origPos = 0;
        int newPos = toReverse.length - 1;
        while (origPos < toReverse.length) {
            switched[newPos] = toReverse[origPos];
            ++origPos;
            --newPos;
        }
        return switched;
    }

    public static byte[] hashSHA256(byte[] data) {
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.error("Error on creating sha-256 instance", (Throwable)e);
            throw new RuntimeException("Could not load SHA-256 algorithm");
        }
        md.update(data);
        return md.digest();
    }

    public static long bytesToLong(byte[] bytes) {
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.put(bytes);
        ((Buffer)buffer).flip();
        return buffer.getLong();
    }

    public static byte[] copyFromWithLength(byte[] array, int from, int length) {
        return Arrays.copyOfRange(array, from, from + length);
    }

    public static byte toUnsignedByte(byte byteToUnsign) {
        return (byte)(byteToUnsign & 0xFF);
    }

    public static byte[] trimPaddingAtEnd(byte[] toTrim) {
        ArrayList<Byte> significantBytes = new ArrayList<Byte>();
        int countZeros = 0;
        for (byte b : toTrim) {
            if (b != 0) {
                if (countZeros > 0) {
                    for (int i = 0; i < countZeros; ++i) {
                        significantBytes.add((byte)0);
                    }
                    countZeros = 0;
                }
                significantBytes.add(b);
                continue;
            }
            ++countZeros;
        }
        byte[] finalArray = new byte[significantBytes.size()];
        for (int i = 0; i < significantBytes.size(); ++i) {
            finalArray[i] = (Byte)significantBytes.get(i);
        }
        return finalArray;
    }

    public static OffsetDateTime timeBytesToTimestamp(byte[] timestamp) {
        int timeInSeconds = new BigInteger(1, Utils.reverseByteOrder(timestamp)).intValue();
        return OffsetDateTime.of(LocalDateTime.ofEpochSecond(timeInSeconds, 0, ZoneOffset.UTC), ZoneOffset.UTC);
    }

    public static long parseUint32(byte[] bytes, boolean reverse) {
        assert (bytes.length == 4);
        ByteOrder order = reverse ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
        ByteBuffer bf = ByteBuffer.allocate(8).order(order).put(bytes);
        bf.position(0);
        return bf.getLong();
    }

    public static int parseUint8(byte b) {
        return b & 0xFF;
    }

    public static long parseUint8Chain(byte[] bytes) {
        StringBuilder concat = new StringBuilder();
        for (byte b : bytes) {
            concat.append(Utils.parseUint8(b));
        }
        return Long.getLong(concat.toString());
    }

    public static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = HEX_ARRAY[v >>> 4];
            hexChars[j * 2 + 1] = HEX_ARRAY[v & 0xF];
        }
        return new String(hexChars);
    }

    public static String unescapeXML(String text) {
        StringBuilder result = new StringBuilder(text.length());
        int i = 0;
        int n = text.length();
        while (i < n) {
            char charAt = text.charAt(i);
            if (charAt != '&') {
                result.append(charAt);
                ++i;
                continue;
            }
            if (text.startsWith("&amp;", i)) {
                result.append('&');
                i += 5;
                continue;
            }
            if (text.startsWith("&apos;", i)) {
                result.append('\'');
                i += 6;
                continue;
            }
            if (text.startsWith("&quot;", i)) {
                result.append('\"');
                i += 6;
                continue;
            }
            if (text.startsWith("&lt;", i)) {
                result.append('<');
                i += 4;
                continue;
            }
            if (text.startsWith("&gt;", i)) {
                result.append('>');
                i += 4;
                continue;
            }
            ++i;
        }
        return result.toString();
    }

    public static String hexToAscii(String hex) {
        StringBuilder output = new StringBuilder();
        hex = hex.replaceAll(" ", "").toLowerCase();
        for (int i = 0; i < hex.length(); i += 2) {
            String str = hex.substring(i, i + 2);
            output.append((char)Integer.parseInt(str, 16));
        }
        return output.toString();
    }

    public static boolean compareEncodedStrings(String a, String b) {
        List<EncodingType> encodingTypesA = EncodingType.guessType(a, false);
        List<EncodingType> encodingTypesB = EncodingType.guessType(b, false);
        ArrayList<byte[]> decodedA = new ArrayList<byte[]>();
        for (EncodingType encodingType : encodingTypesA) {
            try {
                decodedA.add(EncodingType.decode(encodingType, a));
            }
            catch (DecodingException e) {
                LOGGER.warn("Could not decode on key comparison", (Throwable)e);
            }
        }
        for (EncodingType encodingType : encodingTypesB) {
            try {
                for (byte[] bytesA : decodedA) {
                    boolean result = Arrays.equals(bytesA, encodingType.decode(b));
                    if (!result) continue;
                    return true;
                }
            }
            catch (DecodingException e) {
                LOGGER.warn("Could not decode on key comparison", (Throwable)e);
            }
        }
        return false;
    }

    public static String clearString(String value) {
        return value.replaceAll(" ", "").replaceAll("\n", "").replaceAll("\t", "");
    }

    public static String formatDuration(Duration duration) {
        long seconds = duration.getSeconds();
        long absSeconds = Math.abs(seconds);
        String positive = String.format("%dh %02dm %02ds", absSeconds / 3600L, absSeconds % 3600L / 60L, absSeconds % 60L);
        return seconds < 0L ? "-" + positive : positive;
    }

    public static String toBitString(byte[] b) {
        char[] bits = new char[8 * b.length];
        for (int i = 0; i < b.length; ++i) {
            byte byteval = b[i];
            int bytei = i << 3;
            int mask = 1;
            for (int j = 7; j >= 0; --j) {
                int bitval = byteval & mask;
                bits[bytei + j] = bitval == 0 ? 48 : 49;
                mask <<= 1;
            }
        }
        return String.valueOf(bits);
    }

    public static boolean isBitSet(byte[] arr, int bit) {
        try {
            int index = bit / 8;
            int bitPosition = bit % 8;
            return (arr[index] >> bitPosition & 1) == 1;
        }
        catch (Exception e) {
            LOGGER.debug("Error on reading bit from byte array");
            return false;
        }
    }

    public static boolean areBitSet(byte[] arr, int[] index) {
        if (index == null || arr == null) {
            return false;
        }
        boolean result = false;
        for (int i : index) {
            result = result || Utils.isBitSet(arr, i);
        }
        return result;
    }

    public static byte[] longToByteArray(long value) {
        ByteBuffer bb = ByteBuffer.allocate(8);
        bb.putLong(value);
        byte[] array = bb.array();
        return array;
    }

    public static byte[] hexStringToByteArray(String s2) {
        int len = s2.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(s2.charAt(i), 16) << 4) + Character.digit(s2.charAt(i + 1), 16));
        }
        return data;
    }

    private String hexRepresentation(String format) {
        if (format != null && Utils.hexToAscii(format).matches("[A-Za-z0-9]*")) {
            return String.format("%s (%s)", format, Utils.hexToAscii(format));
        }
        return format;
    }

    public static String toASCIIOrFormattedHex(byte[] bytes) {
        for (byte b : bytes) {
            if (b >= 32) continue;
            return Utils.toFormattedHex(bytes);
        }
        return new String(bytes);
    }
}

