/*
 * Decompiled with CFR 0.152.
 */
package de.safe_ev.transparenzsoftware.gui.listeners;

import de.safe_ev.transparenzsoftware.gui.views.MainView;
import de.safe_ev.transparenzsoftware.i18n.Translator;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFileChooser;
import javax.swing.UIManager;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OpenFileBtnListener
implements ActionListener {
    private static final Logger LOGGER = LogManager.getLogger(OpenFileBtnListener.class);
    private final MainView mainView;
    static String currentDir = "./";
    public static boolean ignoreXML = false;

    public OpenFileBtnListener(MainView mainView) {
        this.mainView = mainView;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        JFileChooser jfc = new JFileChooser(currentDir);
        jfc.setName("chooser");
        jfc.setDialogTitle(Translator.get("app.view.select.file"));
        UIManager.put("FileChooser.readOnly", Boolean.TRUE);
        jfc.setAcceptAllFileFilterUsed(false);
        if (!ignoreXML) {
            jfc.addChoosableFileFilter(new FileNameExtensionFilter(Translator.get("app.view.extensions.xml"), "xml"));
        }
        jfc.addChoosableFileFilter(new FileNameExtensionFilter(Translator.get("app.view.extensions.pcdf"), "pcdf"));
        jfc.addChoosableFileFilter(jfc.getAcceptAllFileFilter());
        jfc.grabFocus();
        int returnValue = jfc.showOpenDialog(null);
        if (returnValue == 0) {
            currentDir = jfc.getCurrentDirectory().getAbsolutePath();
            String path = jfc.getSelectedFile().getPath();
            LOGGER.debug("Read in file " + path);
            this.mainView.onFileOpen(path);
        }
    }
}

