/*
 * Decompiled with CFR 0.152.
 */
package de.safe_ev.transparenzsoftware.gui.views;

import de.safe_ev.transparenzsoftware.gui.views.MainView;
import de.safe_ev.transparenzsoftware.i18n.Translator;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DataInputDialog
extends JDialog {
    private static final Logger LOGGER = LogManager.getLogger(DataInputDialog.class);

    public DataInputDialog(final MainView mainView) {
        this.setSize(mainView.getWidth(), mainView.getHeight());
        this.setName("dialog.input");
        JPanel inner = (JPanel)this.getContentPane();
        this.setTitle(Translator.get("app.view.datainput"));
        this.setLayout(new BoxLayout(inner, 1));
        int innerMargin = 5;
        inner.setSize(mainView.getWidth(), mainView.getHeight());
        Border b = BorderFactory.createEmptyBorder(innerMargin, innerMargin, innerMargin, innerMargin);
        inner.setBorder(b);
        inner.add(Box.createRigidArea(new Dimension(0, 10)));
        JLabel lblTxt = new JLabel(Translator.get("app.view.datain.txt"));
        inner.add(lblTxt);
        inner.add(Box.createRigidArea(new Dimension(0, 2)));
        final JTextArea taData = new JTextArea(5, 80);
        taData.setName("paste.data");
        taData.setLineWrap(true);
        inner.add(taData);
        inner.add(Box.createRigidArea(new Dimension(0, 10)));
        JLabel lblKey = new JLabel(Translator.get("app.view.datain.key"));
        inner.add(lblKey);
        inner.add(Box.createRigidArea(new Dimension(0, 2)));
        final JTextArea taKey = new JTextArea(5, 80);
        taKey.setLineWrap(true);
        taKey.setName("paste.key");
        inner.add(taKey);
        inner.add(Box.createRigidArea(new Dimension(0, 10)));
        JPanel buttonBox = new JPanel();
        JButton close = new JButton(Translator.get("app.view.verify"));
        close.setName("paste.close");
        close.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                mainView.onPaste(taData.getText(), taKey.getText());
                DataInputDialog.this.dialogClose();
            }
        });
        close.setDefaultCapable(true);
        close.setAlignmentX(0.5f);
        JButton abort = new JButton(Translator.get("app.view.verify.abort"));
        abort.setName("paste.abort");
        abort.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                DataInputDialog.this.dialogClose();
            }
        });
        abort.setAlignmentX(0.5f);
        buttonBox.add(abort);
        buttonBox.add(Box.createRigidArea(new Dimension(0, 40)));
        buttonBox.add(close);
        buttonBox.setAlignmentX(0.5f);
        inner.add(buttonBox);
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
            }
        });
        taData.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    DataInputDialog.this.dialogClose();
                }
            }
        });
        this.setModal(true);
        this.setVisible(true);
    }

    void dialogClose() {
        this.setVisible(false);
    }
}

