/*
 * Decompiled with CFR 0.152.
 */
package de.safe_ev.transparenzsoftware.gui.views;

import de.safe_ev.transparenzsoftware.Utils;
import de.safe_ev.transparenzsoftware.gui.views.MainView;
import de.safe_ev.transparenzsoftware.gui.views.helper.DetailsList;
import de.safe_ev.transparenzsoftware.i18n.Translator;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;

public class DetailDataView
extends JScrollPane {
    private static final long serialVersionUID = 1L;
    private static final String TEXT_NO_DATA_PRESENT = "app.view.nodata";
    private static final String TEXT_NO_DATA_DETAILS = "app.view.nodata.details";
    private final JTextPane dataLabel;

    public DetailDataView(MainView mainView) {
        this.setName("wnd.details");
        JPanel pane = new JPanel();
        this.dataLabel = new JTextPane();
        this.dataLabel.setContentType("text/html");
        this.dataLabel.setBackground(null);
        this.dataLabel.setEditable(false);
        this.dataLabel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.dataLabel.setName("lbl.data");
        this.setViewportView(this.dataLabel);
        this.setVerticalScrollBarPolicy(22);
        this.setHorizontalScrollBarPolicy(30);
        this.setAlignmentX(0.5f);
        this.validate();
        this.repaint();
        this.setAutoscrolls(true);
        this.setHorizontalScrollBarPolicy(30);
        this.setVerticalScrollBarPolicy(20);
    }

    public void setAdditionalData(DetailsList detailsList) {
        if (detailsList.isEmpty()) {
            this.dataLabel.setText(Translator.get(TEXT_NO_DATA_DETAILS));
            return;
        }
        StringBuilder bd = new StringBuilder();
        String fontfamily = this.getFont().getFamily();
        bd.append("<html><body width=100% style=\"font-family: ").append(fontfamily).append("\"><table>");
        int count = 0;
        for (String s2 : detailsList.keySet()) {
            Object value = detailsList.get(s2);
            if (value instanceof Map) continue;
            Object styleBg = "border-bottom: 1px dotted black;";
            if (count % 2 != 0) {
                styleBg = (String)styleBg + "background-color: dark-grey;";
            }
            String pre = "<span style=\"white-space: nowrap;\">";
            String post = "</span>";
            String addText = Utils.splitStringToGroups(value != null ? value.toString() : "", 70, "<br/>");
            addText = addText.replaceAll("kw/h", pre + "kw/h" + post);
            addText = addText.replaceAll("kW/h", pre + "kW/h" + post);
            bd.append(String.format("<tr style=\"%s\"><td style=\"width: 180px;\">%s</td><td><p>%s</p></td></tr>", styleBg, s2, addText));
            ++count;
        }
        bd.append("</table></body></html>");
        this.dataLabel.setText(bd.toString());
        this.doLayout();
        this.repaint();
        this.revalidate();
    }

    public void clearErrorMessage() {
        this.dataLabel.setText(Translator.get(TEXT_NO_DATA_DETAILS));
    }
}

