/*
 * Decompiled with CFR 0.152.
 */
package de.safe_ev.transparenzsoftware.gui.views;

import de.safe_ev.transparenzsoftware.Utils;
import de.safe_ev.transparenzsoftware.gui.listeners.GotoBtnListener;
import de.safe_ev.transparenzsoftware.gui.views.AboutView;
import de.safe_ev.transparenzsoftware.gui.views.HelpView;
import de.safe_ev.transparenzsoftware.gui.views.customelements.MainViewBottomPanel;
import de.safe_ev.transparenzsoftware.gui.views.customelements.MainViewCenterPanel;
import de.safe_ev.transparenzsoftware.gui.views.customelements.MainViewMenu;
import de.safe_ev.transparenzsoftware.gui.views.customelements.MainViewNorthPanel;
import de.safe_ev.transparenzsoftware.gui.views.customelements.MainViewWestPanel;
import de.safe_ev.transparenzsoftware.i18n.Translator;
import de.safe_ev.transparenzsoftware.verification.ContainedPublicKeyParser;
import de.safe_ev.transparenzsoftware.verification.DecodingException;
import de.safe_ev.transparenzsoftware.verification.EncodingType;
import de.safe_ev.transparenzsoftware.verification.TransactionValidationException;
import de.safe_ev.transparenzsoftware.verification.ValidationException;
import de.safe_ev.transparenzsoftware.verification.VerificationParser;
import de.safe_ev.transparenzsoftware.verification.VerificationParserFactory;
import de.safe_ev.transparenzsoftware.verification.VerificationType;
import de.safe_ev.transparenzsoftware.verification.VerificationTypeNotImplementedException;
import de.safe_ev.transparenzsoftware.verification.Verifier;
import de.safe_ev.transparenzsoftware.verification.format.pcdf.PcdfReader;
import de.safe_ev.transparenzsoftware.verification.format.pcdf.PcdfVerificationParser;
import de.safe_ev.transparenzsoftware.verification.input.InputReader;
import de.safe_ev.transparenzsoftware.verification.input.InvalidInputException;
import de.safe_ev.transparenzsoftware.verification.result.Error;
import de.safe_ev.transparenzsoftware.verification.result.VerificationResult;
import de.safe_ev.transparenzsoftware.verification.xml.EncodedData;
import de.safe_ev.transparenzsoftware.verification.xml.PublicKey;
import de.safe_ev.transparenzsoftware.verification.xml.SignedData;
import de.safe_ev.transparenzsoftware.verification.xml.Value;
import de.safe_ev.transparenzsoftware.verification.xml.Values;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.Timer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MainView
extends JFrame {
    private static final long serialVersionUID = 1L;
    private static final String TEXT_WINDOW_TITEL = "app.title";
    private static final Logger LOGGER = LogManager.getLogger(MainView.class);
    private static final int VERIFY_DELAY = 500;
    private static MainView instance;
    private final VerificationParserFactory factory;
    private final Verifier verifier;
    private JPanel northPanel = null;
    private MainViewCenterPanel centerPanel = null;
    private MainViewBottomPanel southPanel = null;
    private MainViewWestPanel westPanel = null;
    private HelpView helpView;
    private AboutView aboutView;
    private MainViewMenu menuBar;
    private Values values;
    private int currentValuePos;
    private final Timer delayVerifyTimer;
    private boolean verifyMode;
    private boolean publicKeyIsIndeterminate;

    public MainView(VerificationParserFactory factory) {
        this.factory = factory;
        this.verifier = new Verifier(factory);
        this.currentValuePos = 0;
        this.initPage();
        this.delayVerifyTimer = new Timer(500, e -> this.verify());
        this.delayVerifyTimer.setRepeats(false);
    }

    private void verify() {
        try {
            this.verify_();
        }
        finally {
            this.centerPanel.setEnabledFields(true);
        }
    }

    public static MainView init(VerificationParserFactory factory) {
        instance = new MainView(factory);
        return instance;
    }

    private void initPage() {
        this.setLayout(new BorderLayout(10, 10));
        this.setTitle(String.format("%s - Version: %s", Translator.get(TEXT_WINDOW_TITEL), "1.4.1"));
        this.northPanel = new MainViewNorthPanel(this);
        this.centerPanel = new MainViewCenterPanel(this);
        this.southPanel = new MainViewBottomPanel(this);
        this.westPanel = new MainViewWestPanel(this);
        this.menuBar = new MainViewMenu(this);
        this.setJMenuBar(this.menuBar);
        this.add((Component)this.northPanel, "North");
        this.add((Component)this.centerPanel, "Center");
        this.add((Component)this.southPanel, "South");
        this.add((Component)this.westPanel, "West");
        this.pack();
        this.setSize(800, 600);
        this.setVisible(true);
        this.setDefaultCloseOperation(3);
        this.getContentPane().requestFocusInWindow();
        this.westPanel.initView();
    }

    public void showFirstPane() {
        this.centerPanel.showFirstPane();
    }

    public void clearErrorMessages() {
        this.centerPanel.clearErrorMessage();
    }

    public void setEnableVerifyButton(boolean enable) {
        this.centerPanel.setEnabledFields(enable);
    }

    public void setEnableVerifyMode(boolean single) {
        this.verifyMode = single;
        this.centerPanel.setEnabledFields(single);
    }

    private void verify_() {
        VerificationParser parser;
        this.setEnableVerifyButton(false);
        this.clearErrorMessages();
        String publicKeyContent = this.centerPanel.getPublicKeyContent().trim();
        if (publicKeyContent.isEmpty() && !this.centerPanel.getVerificationType().isPublicKeyAware()) {
            if (this.publicKeyIsIndeterminate) {
                LOGGER.error("Public key is inderminate");
                this.setErrorMessage(Translator.get("error.values.ind.publickey"));
            } else {
                LOGGER.error("Empty public key field");
                this.setErrorMessage(Translator.get("error.values.no.publickey"));
            }
            return;
        }
        String rawDataContent = this.centerPanel.getRawDataContent().trim();
        if (rawDataContent.isEmpty()) {
            LOGGER.error("Empty data field");
            this.setErrorMessage(Translator.get("error.values.no.signeddata"));
            return;
        }
        try {
            parser = this.factory.getParser(this.centerPanel.getVerificationType());
        }
        catch (VerificationTypeNotImplementedException e) {
            this.setErrorMessage(Translator.get("error.format.unknown"));
            return;
        }
        if (!this.verifyMode) {
            return;
        }
        VerificationResult verificationResult = null;
        try {
            if (this.westPanel.getCurrentTransactionid() == null) {
                if (publicKeyContent.trim().isEmpty()) {
                    verificationResult = this.verifier.verifyUnknown(parser, rawDataContent, null);
                } else {
                    publicKeyContent = publicKeyContent.replaceAll(" ", "");
                    verificationResult = this.verifier.verifyUnknown(parser, rawDataContent, publicKeyContent);
                }
            } else {
                List<Value> values = this.westPanel.getValues(this.westPanel.getCurrentTransactionid());
                verificationResult = this.verifier.verifyTransaction(parser, values, publicKeyContent);
            }
        }
        catch (TransactionValidationException e) {
            LOGGER.error(String.format("TransactionValidation exception happened: %s", e.getMessage()));
            this.setErrorMessage(e.getLocalizedMessage());
            this.setEnableVerifyButton(true);
            return;
        }
        catch (Exception e) {
            this.setEnableVerifyButton(true);
            this.setErrorMessage(Translator.get("app.view.error.generic"));
            LOGGER.error("Unhandled error", (Throwable)e);
            return;
        }
        this.setEnableVerifyButton(true);
        if (verificationResult == null) {
            this.setErrorMessage(Translator.get("app.view.error.generic"));
            return;
        }
        if (verificationResult.containsErrorOfType(Error.Type.VALIDATION) || verificationResult.containsErrorOfType(Error.Type.INPUT)) {
            String errmsg = verificationResult.getErrorMessages().size() > 0 ? verificationResult.getErrorMessages().get(0).getLocalizedMessageCode() : "";
            LOGGER.error(String.format("Validation error %s", errmsg));
            ArrayList<String> errorMessages = new ArrayList<String>();
            for (Error errorMessage : verificationResult.getErrorMessages()) {
                if (errorMessage.getType().equals((Object)Error.Type.VERIFICATION)) continue;
                errorMessages.add(errorMessage.getLocalizedMessage());
                break;
            }
            if (!errorMessages.isEmpty()) {
                StringBuilder messageBuilder = new StringBuilder();
                if (errorMessages.size() == 1) {
                    messageBuilder.append("<html><body><p>").append((String)errorMessages.get(0)).append("</p></body></html>");
                } else {
                    messageBuilder.append("<html><body><ul>");
                    for (String errorMessage : errorMessages) {
                        messageBuilder.append("<li>").append(errorMessage).append("</li>");
                    }
                    messageBuilder.append("</ul></body></html>");
                }
                this.setErrorMessage(messageBuilder.toString());
            }
        } else {
            this.centerPanel.setVerificationContent(verificationResult);
        }
    }

    public void onFileOpen(String filename) {
        LOGGER.info(String.format("Try to open file %s", filename));
        this.clearState();
        this.showFirstPane();
        if (filename.indexOf(".pcdf") != -1) {
            PcdfReader pcdfReader = new PcdfReader();
            try {
                this.values = pcdfReader.readPcdfFile(filename);
            }
            catch (ValidationException e) {
                LOGGER.error("Validation error in file", (Throwable)e);
                String localizedMessage = e.getLocalizedMessage();
                this.setErrorMessage(localizedMessage);
                return;
            }
            catch (InvalidInputException e) {
                LOGGER.error("Error on reading file", (Throwable)e);
                String localizedMessage = e.getLocalizedMessage();
                this.setErrorMessage(localizedMessage);
                return;
            }
        }
        File xmlFile = new File(filename);
        try {
            InputReader inputReader = new InputReader();
            this.values = inputReader.readFile(xmlFile);
        }
        catch (InvalidInputException exception) {
            LOGGER.error("Error on reading file", (Throwable)exception);
            String localizedMessage = exception.getLocalizedMessage();
            this.setErrorMessage(localizedMessage);
            return;
        }
        this.onValuesRead(this.values);
        this.centerPanel.setEnabledFields(true);
    }

    public void stepToValueWithKeyCheck(int index) {
        this.publicKeyIsIndeterminate = false;
        if (this.values.getValues().size() > 1) {
            HashSet<String> keys = new HashSet<String>();
            for (Value v : this.values.getValues()) {
                keys.add(v.getPublicKey().getValue());
            }
            this.publicKeyIsIndeterminate = keys.size() > 1;
        }
        this.stepToValue_(index);
    }

    public void stepToValue(int index) {
        this.publicKeyIsIndeterminate = false;
        this.stepToValue_(index);
    }

    private void stepToValue_(int index) {
        this.currentValuePos = index;
        this.setEnableVerifyButton(false);
        Value firstValue = this.values.getValues().get(this.currentValuePos);
        SignedData signedData = firstValue.getSignedData();
        PublicKey publicKey = firstValue.getPublicKey();
        try {
            String publicKeyContent = publicKey != null ? publicKey.getValue() : this.tryFetchingEmbeddedKey(signedData, signedData.getFormatAsVerificationType());
            List<EncodingType> encodingTypes = EncodingType.guessType(publicKeyContent);
            if (encodingTypes.size() == 1) {
                EncodingType type = encodingTypes.get(0);
                switch (type) {
                    case BASE64: {
                        publicKeyContent = Utils.toFormattedHex(EncodingType.base64Decode(publicKeyContent));
                        break;
                    }
                    case HEX: {
                        publicKeyContent = Utils.splitStringToGroups(publicKeyContent, 2);
                    }
                }
            }
            if (this.publicKeyIsIndeterminate) {
                publicKeyContent = "";
            }
            if (signedData == null) {
                EncodedData encodedData = firstValue.getEncodedData();
                this.centerPanel.fillUpContent(encodedData.getValue(), publicKeyContent, this.publicKeyIsIndeterminate, encodedData.getEncodingType(), encodedData.getFormatAsVerificationType());
            } else {
                this.centerPanel.fillUpContent(signedData.getValue(), publicKeyContent, this.publicKeyIsIndeterminate, signedData.getEncodingType(), signedData.getFormatAsVerificationType());
            }
            this.delayedAutoVerify();
        }
        catch (DecodingException exception) {
            LOGGER.error("Error on reading file", (Throwable)exception);
            String localizedMessage = exception.getLocalizedMessage();
            this.setErrorMessage(localizedMessage);
        }
        this.setEnableVerifyButton(true);
        if (firstValue.getSignedData() != null) {
            List<EncodingType> types;
            if (firstValue.getSignedData().getEncoding() == null && !(types = EncodingType.guessType(firstValue.getSignedData().getValue(), true)).isEmpty()) {
                this.centerPanel.setEncoding(types.get(0));
            }
            if (firstValue.getSignedData().getFormat() == null) {
                try {
                    List<VerificationParser> verificationParserList = this.factory.getParserWithData(firstValue.getSignedData().getValue());
                    VerificationParser verificationParser = verificationParserList.get(0);
                    this.centerPanel.setVerificationType(verificationParser.getVerificationType());
                }
                catch (VerificationTypeNotImplementedException e) {
                    LOGGER.info("No verification type found for data");
                }
            }
        }
        this.checkPublicKeyPayloadData(firstValue);
        if (index + 1 >= this.values.getValues().size()) {
            this.menuBar.setGotoNextItemEnabled(false);
        } else if (this.values.getValues().size() > 1) {
            this.menuBar.setGotoNextItemEnabled(true);
        }
        if (index <= 0) {
            this.menuBar.setGotoPreviousItemEnabled(false);
        } else if (this.values.getValues().size() > 1) {
            this.menuBar.setGotoPreviousItemEnabled(true);
        }
        this.southPanel.setPagingCount(index + 1, this.values.getValues().size());
    }

    private void checkPublicKeyPayloadData(Value value) {
        VerificationParser verificationParser = null;
        try {
            verificationParser = this.factory.getParser(this.centerPanel.getVerificationType());
            String publicKeyContent = this.centerPanel.getPublicKeyContent().trim().isEmpty() ? null : this.centerPanel.getPublicKeyContent();
            String loaded = this.verifier.checkForEmbeddedPublicKey(verificationParser, publicKeyContent, value);
            if (loaded != null && !loaded.trim().isEmpty()) {
                this.centerPanel.setPublicKey(loaded);
            }
        }
        catch (VerificationTypeNotImplementedException publicKeyContent) {
        }
        catch (InvalidInputException e) {
            this.setWarningMessage(Translator.get("app.view.error.publickeynotmatchdata"));
        }
    }

    public String tryFetchingEmbeddedKey(SignedData signedData, VerificationType verificationType) {
        VerificationParser verificationParser = null;
        String publicKey = null;
        try {
            verificationParser = this.factory.getParser(verificationType);
            if (verificationParser instanceof ContainedPublicKeyParser) {
                publicKey = ((ContainedPublicKeyParser)((Object)verificationParser)).parsePublicKey(signedData.getValue());
            }
        }
        catch (VerificationTypeNotImplementedException verificationTypeNotImplementedException) {
            // empty catch block
        }
        return publicKey;
    }

    public void onClose() {
        this.dispose();
    }

    private void clearState() {
        this.centerPanel.clearInputs();
        this.setEnableVerifyButton(false);
        this.clearErrorMessages();
        this.menuBar.setGotoNextItemEnabled(false);
        this.menuBar.setGotoPreviousItemEnabled(false);
        this.centerPanel.setPublicKeyWarning(false);
        this.setEnableVerifyMode(true);
        this.centerPanel.setEnabledFields(true);
        this.currentValuePos = 0;
        this.westPanel.initView();
        this.delayVerifyTimer.stop();
    }

    private void setErrorMessage(String message) {
        this.centerPanel.setErrorMessage(message);
    }

    private boolean isErrorMessageSet() {
        return this.centerPanel.isErrorMessageSet();
    }

    private void setWarningMessage(String message) {
        this.centerPanel.setWarningMessage(message);
        this.centerPanel.setPublicKeyWarning(true);
    }

    public void onHelpOpen() {
        if (this.helpView == null) {
            HelpView helpView = new HelpView(this);
            this.configureSupportWindows(helpView);
            this.helpView = helpView;
        } else {
            this.helpView.toFront();
        }
    }

    public void onHelpClose() {
        if (this.helpView != null) {
            this.helpView.dispose();
        }
        this.helpView = null;
    }

    public void onAboutOpen() {
        if (this.aboutView == null) {
            AboutView aboutView = new AboutView(this);
            this.configureSupportWindows(aboutView);
            this.aboutView = aboutView;
        } else {
            this.aboutView.toFront();
        }
    }

    public void onAboutClose() {
        if (this.aboutView != null) {
            this.aboutView.dispose();
        }
        this.aboutView = null;
    }

    private void onValuesRead(Values values) {
        this.values = values;
        try {
            values.validate(false);
            this.stepToValue(this.currentValuePos);
            if (values.getValues() != null && values.getValues().size() > 1) {
                this.westPanel.updateTree(values);
                this.menuBar.setGotoNextItemEnabled(true);
            }
            this.southPanel.showPaginationCount();
        }
        catch (InvalidInputException e) {
            String localizedMessage = e.getLocalizedMessage();
            this.setErrorMessage(localizedMessage);
        }
    }

    public void onGoto(GotoBtnListener.Direction direction) {
        int nrValues = this.values.getValues() != null ? this.values.getValues().size() : 0;
        int newPos = this.currentValuePos;
        switch (direction) {
            case NEXT: {
                if (this.currentValuePos + 1 >= nrValues) break;
                ++newPos;
                break;
            }
            case PREVIOUS: {
                if (this.currentValuePos - 1 < 0) break;
                --newPos;
            }
        }
        if (newPos != this.currentValuePos) {
            this.stepToValue(newPos);
            this.westPanel.setSelection(newPos);
        }
    }

    private void configureSupportWindows(JFrame frame) {
        frame.pack();
        Dimension size = this.getSize();
        size.setSize(size.getWidth() - 40.0, size.getHeight() - 40.0);
        frame.setSize(size);
        frame.setVisible(true);
    }

    private String trimString(String other) {
        other = other.replace('\n', ' ');
        other = other.replace('\r', ' ');
        other = other.trim();
        return other;
    }

    public void onPaste(String rawData, String pubKey) {
        this.clearState();
        this.showFirstPane();
        String rawDataContent = rawData;
        InputReader reader = new InputReader();
        try {
            Values values = reader.readString(rawDataContent);
            this.onValuesRead(values);
            return;
        }
        catch (InvalidInputException e) {
            LOGGER.debug("No values pasted");
            if (rawDataContent.isEmpty()) {
                this.setErrorMessage(Translator.get("paste.err.empty"));
                return;
            }
            pubKey = this.trimString(pubKey);
            this.centerPanel.fillUpContent(rawDataContent, pubKey, false, EncodingType.PLAIN, VerificationType.UNKNOWN);
            boolean singleValueFound = false;
            try {
                List<VerificationParser> parserWithData = this.factory.getParserWithData(rawDataContent);
                if (!parserWithData.isEmpty()) {
                    VerificationParser parser = parserWithData.get(0);
                    singleValueFound = true;
                    this.centerPanel.setVerificationType(parser.getVerificationType());
                    if (parser instanceof PcdfVerificationParser) {
                        PcdfReader pr = new PcdfReader();
                        try {
                            pr.readPCDFString(rawDataContent);
                        }
                        catch (ValidationException e2) {
                            LOGGER.error("Validation error in parsed text", (Throwable)e2);
                            String localizedMessage = e2.getLocalizedMessage();
                            this.setErrorMessage(localizedMessage);
                            return;
                        }
                        catch (InvalidInputException e3) {
                            LOGGER.error("Error on parsing text", (Throwable)e3);
                            String localizedMessage = e3.getLocalizedMessage();
                            this.setErrorMessage(localizedMessage);
                            return;
                        }
                    }
                    if (this.centerPanel.getPublicKeyContent().trim().isEmpty() && parser instanceof ContainedPublicKeyParser) {
                        String parsePublicKey = ((ContainedPublicKeyParser)((Object)parser)).createFormattedKey(rawDataContent);
                        this.centerPanel.setPublicKey(parsePublicKey);
                    }
                }
                List<EncodingType> encodingTypes = EncodingType.guessType(rawDataContent, true);
                if (!parserWithData.isEmpty()) {
                    this.centerPanel.setEncoding(encodingTypes.get(0));
                }
            }
            catch (VerificationTypeNotImplementedException e4) {
                LOGGER.debug("Guessing parser failed", (Throwable)e4);
            }
            if (singleValueFound) {
                try {
                    this.westPanel.updateTree(null);
                    this.values = null;
                }
                catch (InvalidInputException e5) {
                    LOGGER.error("Error on cleaning tree");
                }
            }
            this.delayedAutoVerify();
            return;
        }
    }

    public void delayedAutoVerify() {
        this.centerPanel.setEnabledFields(false);
        this.delayVerifyTimer.restart();
    }
}

