/*
 * Decompiled with CFR 0.152.
 */
package de.safe_ev.transparenzsoftware.gui.views.customelements;

import de.safe_ev.transparenzsoftware.gui.views.MainView;
import de.safe_ev.transparenzsoftware.gui.views.customelements.ValueTree;
import de.safe_ev.transparenzsoftware.gui.views.helper.NodeHeadingHolder;
import de.safe_ev.transparenzsoftware.gui.views.helper.NodeValueHolder;
import de.safe_ev.transparenzsoftware.gui.views.helper.ValueIndexHolder;
import de.safe_ev.transparenzsoftware.i18n.Translator;
import de.safe_ev.transparenzsoftware.verification.input.InvalidInputException;
import de.safe_ev.transparenzsoftware.verification.xml.Value;
import de.safe_ev.transparenzsoftware.verification.xml.Values;
import java.awt.Dimension;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MainViewWestPanel
extends JPanel {
    private static final Logger LOGGER = LogManager.getLogger(MainViewWestPanel.class);
    private ValueTree tree;
    private MainView mainView;
    private BigInteger transactionid;

    public MainViewWestPanel(MainView mainView) {
        this.mainView = mainView;
        this.setLayout(new BoxLayout(this, 1));
        this.setAlignmentY(0.0f);
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.initEmpty();
        this.transactionid = null;
    }

    private void initEmpty() {
        this.removeAll();
        this.validate();
        this.tree = null;
        this.transactionid = null;
    }

    public void updateTree(Values values) throws InvalidInputException {
        if (values == null || values.getValues().size() == 0) {
            this.initEmpty();
            return;
        }
        this.removeAll();
        this.add(Box.createHorizontalStrut(this.mainView.getPreferredSize().width / 3));
        this.tree = ValueTree.createFromValues(values);
        this.tree.getSelectionModel().addTreeSelectionListener(e -> {
            DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
            if (selectedNode.getUserObject() instanceof NodeValueHolder) {
                NodeValueHolder valueHolder = (NodeValueHolder)selectedNode.getUserObject();
                this.transactionid = null;
                this.mainView.setEnableVerifyMode(true);
                this.mainView.stepToValue(valueHolder.getValue().getInitIndex());
            } else if (selectedNode.getUserObject() instanceof NodeHeadingHolder) {
                NodeHeadingHolder valueHolder = (NodeHeadingHolder)selectedNode.getUserObject();
                this.mainView.setEnableVerifyMode(true);
                this.transactionid = valueHolder.getTransactionId();
                if (this.tree.getTransactionMap().get(this.transactionid) != null && this.tree.getTransactionMap().get(this.transactionid).size() > 0) {
                    this.mainView.stepToValueWithKeyCheck(this.tree.getTransactionMap().get(this.transactionid).get(0).getInitIndex());
                } else {
                    LOGGER.error(String.format("Could not load value for transaction id %s", this.transactionid));
                }
            } else {
                this.transactionid = null;
            }
        });
        SwingUtilities.invokeLater(() -> {
            if (this.tree.getPathMinimumTransactionId() != null) {
                this.tree.setSelectionPath(new TreePath(this.tree.getPathMinimumTransactionId()));
            } else {
                this.tree.selectValue(0);
            }
        });
        this.removeAll();
        this.add(Box.createVerticalStrut(40));
        this.add(new JLabel(Translator.get("app.view.loaded.values")));
        this.add(Box.createVerticalStrut(10));
        this.add(new JScrollPane(this.tree));
        this.validate();
    }

    public void setSelection(int index) {
        if (this.tree == null) {
            return;
        }
        this.tree.selectValue(index);
    }

    public BigInteger getCurrentTransactionid() {
        return this.transactionid;
    }

    public List<Value> getValues(BigInteger transactionid) {
        List<ValueIndexHolder> valueIndexHolders = this.tree.getTransactionMap().get(transactionid);
        ArrayList<Value> values = new ArrayList<Value>();
        for (ValueIndexHolder valueIndexHolder : valueIndexHolders) {
            values.add(valueIndexHolder.getValue());
        }
        return values;
    }

    public void initView() {
        this.initEmpty();
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }
}

