/*
 * Decompiled with CFR 0.152.
 */
package de.safe_ev.transparenzsoftware.gui.views.helper;

import de.safe_ev.transparenzsoftware.gui.views.helper.ValueIndexHolder;
import de.safe_ev.transparenzsoftware.verification.input.InvalidInputException;
import de.safe_ev.transparenzsoftware.verification.xml.Value;
import de.safe_ev.transparenzsoftware.verification.xml.Values;
import java.beans.Transient;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ValueMapBuilder {
    public static final BigInteger NO_TRANSACTION_KEY = BigInteger.valueOf(-1L);

    @Transient
    public static Map<BigInteger, List<ValueIndexHolder>> buildTransactionMap(Values values) throws InvalidInputException {
        HashMap<BigInteger, List<ValueIndexHolder>> result = new HashMap<BigInteger, List<ValueIndexHolder>>();
        int index = 0;
        for (Value value : values.getValues()) {
            if (value.getTransactionId() == null) {
                if (!result.containsKey(BigInteger.valueOf(-1L))) {
                    result.put(BigInteger.valueOf(-1L), new ArrayList());
                }
                result.get(BigInteger.valueOf(-1L)).add(new ValueIndexHolder(value, index));
            } else {
                if (!result.containsKey(value.getTransactionId())) {
                    result.put(value.getTransactionId(), new ArrayList());
                }
                for (ValueIndexHolder otherValue : result.get(value.getTransactionId())) {
                    if (otherValue.getValue().getSignedData().getFormatAsVerificationType() == value.getSignedData().getFormatAsVerificationType()) continue;
                    String errMsg = String.format("Same transaction id %d for different formats on", value.getTransactionId());
                    throw new InvalidInputException(errMsg, "app.view.error.same.transaction.id.diff.format");
                }
                result.get(value.getTransactionId()).add(new ValueIndexHolder(value, index));
            }
            ++index;
        }
        return result;
    }
}

