/*
 * Decompiled with CFR 0.152.
 */
package de.safe_ev.transparenzsoftware.i18n;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Translator {
    private static final Logger LOGGER = LogManager.getLogger(Translator.class);
    private static ResourceBundle rb = null;
    private static Locale locale;

    public static void init(Locale locale) {
        Translator.locale = locale;
        ResourceBundle.Control control = ResourceBundle.Control.getControl(ResourceBundle.Control.FORMAT_PROPERTIES);
        String bname = control.toBundleName("i18n/lang", locale);
        String resname = control.toResourceName(bname, "properties");
        resname = resname.replaceAll("_DE", "");
        InputStream ins = Translator.class.getClassLoader().getResourceAsStream(resname);
        try {
            InputStreamReader rdr = new InputStreamReader(ins, Charset.forName("UTF-8"));
            rb = new PropertyResourceBundle(rdr);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (rb == null) {
            rb = ResourceBundle.getBundle("i18n/lang", locale);
        }
        LOGGER.debug(String.format("Locale used will be '%s'", locale.getLanguage()));
    }

    public static void init(String locale) {
        if (locale.contains("de") || locale.contains("DE")) {
            Translator.init(new Locale("de", "DE"));
        } else {
            Translator.init(new Locale("en", "EN"));
        }
    }

    public static String get(String key) throws MissingResourceException {
        return Translator.get(key, key);
    }

    public static String get(String key, String defaultValue) throws MissingResourceException {
        if (rb == null) {
            String language = Locale.getDefault() != null ? Locale.getDefault().getLanguage() : "de";
            Translator.init(language);
        }
        try {
            String result = rb.getString(key);
            return result;
        }
        catch (Exception e) {
            LOGGER.error("Error on loading localisation text", (Throwable)e);
            return defaultValue;
        }
    }

    public static String getHelpFileContent() {
        InputStream content = ClassLoader.getSystemResourceAsStream("help/" + locale.getLanguage() + ".html");
        if (content == null) {
            content = ClassLoader.getSystemResourceAsStream("help/en.html");
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[1024];
        try {
            int nRead;
            while ((nRead = content.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, nRead);
            }
            buffer.flush();
        }
        catch (IOException | NullPointerException e) {
            LOGGER.error("Error on loading help text", (Throwable)e);
            return Translator.get("app.view.error.loadinghelp");
        }
        byte[] byteArray = buffer.toByteArray();
        return new String(byteArray, StandardCharsets.UTF_8);
    }
}

