/*
 * Decompiled with CFR 0.152.
 */
package de.safe_ev.transparenzsoftware.output;

import de.safe_ev.transparenzsoftware.Utils;
import de.safe_ev.transparenzsoftware.verification.result.VerificationResult;
import de.safe_ev.transparenzsoftware.verification.xml.Meter;
import de.safe_ev.transparenzsoftware.verification.xml.Result;
import de.safe_ev.transparenzsoftware.verification.xml.Results;
import de.safe_ev.transparenzsoftware.verification.xml.Value;
import de.safe_ev.transparenzsoftware.verification.xml.Values;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import java.io.StringWriter;
import java.time.Duration;
import java.util.List;

public class Output {
    private final Marshaller marshaller;
    private final Values values;
    private List<VerificationResult> verificationResults;

    public Output(Class[] verifiedDataClasses, List<VerificationResult> verificationResults, Values values) throws JAXBException {
        this.values = values;
        Class[] classes = new Class[verifiedDataClasses.length + 1];
        classes[0] = Results.class;
        System.arraycopy(verifiedDataClasses, 0, classes, 1, verifiedDataClasses.length);
        JAXBContext jc = JAXBContext.newInstance(classes);
        this.marshaller = jc.createMarshaller();
        this.marshaller.setProperty("jaxb.formatted.output", Boolean.TRUE);
        this.verificationResults = verificationResults;
    }

    public String createXML() throws JAXBException {
        StringWriter sw = new StringWriter();
        this.marshaller.marshal((Object)this.createResults(), sw);
        return sw.toString();
    }

    protected Results createResults() {
        Results results = new Results();
        for (int i = 0; i < this.verificationResults.size(); ++i) {
            VerificationResult verificationResult = this.verificationResults.get(i);
            Result result = new Result();
            if (this.values.getValues().size() < i) {
                Value value = this.values.getValues().get(i);
                result.setPublicKey(value.getPublicKey());
                result.setSignedData(value.getSignedData());
            }
            List<Meter> meters = verificationResult.getMeters();
            String preci = meters.get(0).getScalingFormat();
            if (verificationResult.isTransactionResult() && verificationResult.getTransactionId() != null) {
                result.setTransactionId(verificationResult.getTransactionId());
                result.setMeterDiff(String.format(preci + " kWh", Meter.getDifference(meters)));
                Duration timeDiff = Meter.getTimeDiff(meters);
                result.setTimeDiff(Utils.formatDuration(timeDiff));
            }
            result.setMeters(meters);
            result.setStatus(verificationResult.isVerified() ? "Verified" : "Failed");
            result.setVerifiedData(verificationResult.getVerifiedData());
            if (!verificationResult.getErrorMessages().isEmpty()) {
                result.setErrorMessage(verificationResult.getErrorMessages().get(0).getLocalizedMessage());
            }
            results.getResults().add(result);
        }
        return results;
    }
}

