/*
 * Decompiled with CFR 0.152.
 */
package de.safe_ev.transparenzsoftware.verification;

import de.safe_ev.transparenzsoftware.Utils;
import de.safe_ev.transparenzsoftware.verification.DecodingException;
import de.safe_ev.transparenzsoftware.verification.EncodingType;
import de.safe_ev.transparenzsoftware.verification.xml.PublicKey;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EncodingDecoder {
    private static final Logger LOGGER = LogManager.getLogger(EncodingDecoder.class);

    public static String decodePublicKey(PublicKey publicKey) throws DecodingException {
        return EncodingDecoder.decodeAsHex(publicKey.getValue(), publicKey.getEncodingType());
    }

    public static String decodeAsHex(String data, EncodingType type) throws DecodingException {
        String dataToReturn;
        switch (type) {
            case PLAIN: {
                dataToReturn = data;
                break;
            }
            case BASE64: {
                try {
                    byte[] decode = EncodingType.BASE64.decode(data);
                    dataToReturn = Utils.toFormattedHex(decode);
                    break;
                }
                catch (IllegalArgumentException e) {
                    LOGGER.error("Invalid base 64 data provided: " + data);
                    throw new DecodingException("Invalid base 64 data provided", "error.encoding.base64.invalid");
                }
            }
            default: {
                LOGGER.error("Unknown encoding type provided" + String.valueOf((Object)type));
                throw new DecodingException("Unknown encoding type provided" + String.valueOf((Object)type), "error.encoding.unknowntype");
            }
        }
        return dataToReturn;
    }
}

