/*
 * Decompiled with CFR 0.152.
 */
package de.safe_ev.transparenzsoftware.verification;

import com.metabit.custom.safe.safeseal.SAFESealRevealer;
import de.safe_ev.transparenzsoftware.Utils;
import de.safe_ev.transparenzsoftware.verification.result.IntrinsicVerified;
import de.safe_ev.transparenzsoftware.verification.xml.Value;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.util.PublicKeyFactory;
import org.bouncycastle.crypto.util.SubjectPublicKeyInfoFactory;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class EncryptedDataDecoder {
    private static final Logger LOGGER = LogManager.getLogger(EncryptedDataDecoder.class);
    public static final String ALGORITHM_SPEC_3 = "RSA/None/NoPadding";
    public static final String ALGORITHM_SPEC_2 = "RSA/ECB/NoPadding";
    public static final String ALGORITHM_SPEC_1 = "RSA/ECB/PKCS1Padding";
    private final byte[] publicKeyBytes;
    private static Provider securityProvider = new BouncyCastleProvider();

    public EncryptedDataDecoder(byte[] publicKey) {
        this.publicKeyBytes = publicKey;
    }

    public EncryptedDataDecoder(String publicKeyContent) {
        this.publicKeyBytes = Utils.hexStringToByteArray(publicKeyContent);
    }

    public String decode(Value data, AtomicReference<IntrinsicVerified> intrinsicVerified) {
        try {
            AsymmetricKeyParameter asymKey = PublicKeyFactory.createKey(this.publicKeyBytes);
            SubjectPublicKeyInfo keyInfo = SubjectPublicKeyInfoFactory.createSubjectPublicKeyInfo(asymKey);
            PublicKey pubKey = BouncyCastleProvider.getPublicKey(keyInfo);
            byte[] encodedData = Utils.hexStringToByteArray(data.getEncodedData().getValue());
            SAFESealRevealer revealer = new SAFESealRevealer(2);
            byte[] decodedData = revealer.reveal(pubKey, null, encodedData);
            String flatData = new String(decodedData);
            intrinsicVerified.set(IntrinsicVerified.VERIFIED);
            return flatData;
        }
        catch (Exception e) {
            LOGGER.debug("Could not decode {}", (Object)data, (Object)e);
            return null;
        }
    }

    static {
        Security.addProvider(securityProvider);
    }
}

