/*
 * Decompiled with CFR 0.152.
 */
package de.safe_ev.transparenzsoftware.verification;

import java.util.logging.Logger;
import org.bouncycastle.util.encoders.Hex;

public class VerificationLogger {
    private static Logger LOG = Logger.getLogger("VERIFICATIONLOG");

    public static void log() {
    }

    public static void log(String format, String algo, byte[] publicKey, byte[] hashData, byte[] derSignature, boolean verify) {
        String lastMethod = "";
        String lastClass = "";
        for (StackTraceElement t2 : Thread.currentThread().getStackTrace()) {
            if (t2.getMethodName().equals("invoke0")) break;
            lastMethod = t2.getMethodName();
            lastClass = t2.getClassName();
        }
        String msg = lastClass + "." + lastMethod + "(): " + format + "/" + algo + " pubkey:" + publicKey.length * 8 + " hash:" + hashData.length * 8 + " sign:" + derSignature.length * 8 + " => " + verify;
        LOG.info(msg);
        LOG.info("format:       " + format);
        LOG.info("algo:         " + algo);
        LOG.info("publicKey:    " + Hex.toHexString(publicKey));
        LOG.info("hashData:     " + Hex.toHexString(hashData));
        LOG.info("derSignature: " + Hex.toHexString(derSignature));
        System.out.println("OUT: " + msg);
    }
}

