/*
 * Decompiled with CFR 0.152.
 */
package de.safe_ev.transparenzsoftware.verification;

import de.safe_ev.transparenzsoftware.Utils;
import de.safe_ev.transparenzsoftware.verification.ContainedPublicKeyParser;
import de.safe_ev.transparenzsoftware.verification.DecodingException;
import de.safe_ev.transparenzsoftware.verification.EncodingType;
import de.safe_ev.transparenzsoftware.verification.EncryptedDataDecoder;
import de.safe_ev.transparenzsoftware.verification.TransactionValidationException;
import de.safe_ev.transparenzsoftware.verification.ValidationException;
import de.safe_ev.transparenzsoftware.verification.VerificationException;
import de.safe_ev.transparenzsoftware.verification.VerificationParser;
import de.safe_ev.transparenzsoftware.verification.VerificationParserFactory;
import de.safe_ev.transparenzsoftware.verification.VerificationTypeNotImplementedException;
import de.safe_ev.transparenzsoftware.verification.input.InvalidInputException;
import de.safe_ev.transparenzsoftware.verification.result.Error;
import de.safe_ev.transparenzsoftware.verification.result.IntrinsicVerified;
import de.safe_ev.transparenzsoftware.verification.result.VerificationResult;
import de.safe_ev.transparenzsoftware.verification.xml.EncodedData;
import de.safe_ev.transparenzsoftware.verification.xml.Meter;
import de.safe_ev.transparenzsoftware.verification.xml.SignedData;
import de.safe_ev.transparenzsoftware.verification.xml.Value;
import de.safe_ev.transparenzsoftware.verification.xml.Values;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Verifier {
    private static final Logger LOGGER = LogManager.getLogger(Verifier.class);
    private final VerificationParserFactory factory;

    public Verifier(VerificationParserFactory factory) {
        this.factory = factory;
    }

    public List<VerificationResult> verifyValues(Values values) {
        ArrayList<VerificationResult> resultList = new ArrayList<VerificationResult>();
        for (Value value : values.getValues()) {
            resultList.add(this.verify(value));
        }
        return resultList;
    }

    public VerificationResult verify(Value value) {
        VerificationResult result = null;
        try {
            value.validate(false);
            String publicKey = value.getPublicKey() != null ? value.getPublicKey().getValue() : null;
            result = this.verify(value, publicKey);
        }
        catch (InvalidInputException e) {
            Error error = new Error(Error.Type.INPUT, e.getMessage(), e.getLocalizedMessageKey());
            result = new VerificationResult(error);
        }
        catch (VerificationTypeNotImplementedException e) {
            Error error = new Error(null, "Format not found", "error.format.unknown");
            result = new VerificationResult(error);
        }
        return result;
    }

    VerificationResult verify(Value data, String publicKey) throws VerificationTypeNotImplementedException {
        AtomicReference<IntrinsicVerified> maybeIntrinsicVerified = new AtomicReference<IntrinsicVerified>();
        String decodedData = this.decodeData(data, publicKey, maybeIntrinsicVerified);
        List<VerificationParser> possibleParser = this.factory.getParserWithData(decodedData);
        ArrayList<String> parserNames = new ArrayList<String>();
        for (VerificationParser parser : possibleParser) {
            parserNames.add(parser.getVerificationType().name());
        }
        LOGGER.info(String.format("%s parser found to try formats: %s", possibleParser.size(), String.join((CharSequence)",", parserNames)));
        return this.verify(possibleParser, data, publicKey);
    }

    private String decodeData(Value data, String publicKey, AtomicReference<IntrinsicVerified> intrinsicVerified) {
        if (data.getSignedData() != null) {
            return data.getSignedData().getValue();
        }
        return this.decodeData(data, Utils.hexStringToByteArray(publicKey), intrinsicVerified);
    }

    private String decodeData(Value data, byte[] publicKey, AtomicReference<IntrinsicVerified> intrinsicVerified) {
        if (data.getSignedData() != null && !data.getSignedData().getValue().isEmpty()) {
            return data.getSignedData().getValue();
        }
        EncryptedDataDecoder decoder = new EncryptedDataDecoder(publicKey);
        return decoder.decode(data, intrinsicVerified);
    }

    public VerificationResult verify(VerificationParser parser, Value data, String publicKey) {
        return this.verify(Collections.singletonList(parser), data, publicKey);
    }

    public VerificationResult verifyTransaction(VerificationParser parser, List<Value> transactionValues, String publicKey) throws TransactionValidationException {
        int startCount = 0;
        int stopCount = 0;
        Value startValue = null;
        Value stopValue = null;
        BigInteger transactionId = null;
        for (Value value : transactionValues) {
            if (value.getContext() != null && value.getContext().trim().equals("Transaction.Begin")) {
                ++startCount;
                startValue = value;
            }
            if (value.getContext() != null && value.getContext().trim().equals("Transaction.End")) {
                ++stopCount;
                stopValue = value;
            }
            transactionId = value.getTransactionId();
        }
        if (startCount == 0) {
            throw new TransactionValidationException("No start value for transaction found", "error.values.no.start");
        }
        if (stopCount == 0) {
            throw new TransactionValidationException("No stop value for transaction found", "error.values.no.stop");
        }
        if (startCount > 1) {
            throw new TransactionValidationException("Too many start values for transaction found", "error.values.toomany.start");
        }
        if (stopCount > 1) {
            throw new TransactionValidationException("Too many stop values for transaction found", "error.values.toomany.stop");
        }
        VerificationResult verificationResultStart = this.verify(parser, startValue, publicKey);
        VerificationResult verificationResultStop = this.verify(parser, stopValue, publicKey);
        if (verificationResultStart == null || verificationResultStop == null) {
            throw new TransactionValidationException("Unknown error on verification results", "app.view.error.generic");
        }
        LOGGER.debug("Verify transaction " + String.valueOf(startValue.getTransactionId()) + " now with");
        LOGGER.debug("Result 1: " + verificationResultStart.isVerified());
        LOGGER.debug("Result 2: " + verificationResultStop.isVerified());
        VerificationResult result = null;
        try {
            result = VerificationResult.mergeVerificationData(verificationResultStart, verificationResultStop, transactionId);
        }
        catch (ValidationException e) {
            throw new TransactionValidationException(e.getMessage(), e.getLocalizedMessageKey(), e);
        }
        if (result.isVerified()) {
            try {
                List<Meter> startMeters = Meter.filterLawRelevant(verificationResultStart.getMeters());
                List<Meter> stopMeters = Meter.filterLawRelevant(verificationResultStop.getMeters());
                Meter.validateListStartStop(startMeters, stopMeters);
            }
            catch (ValidationException e) {
                throw new TransactionValidationException(e.getMessage(), e.getLocalizedMessageKey(), e);
            }
        }
        return result;
    }

    public VerificationResult verify(List<VerificationParser> parsers, Value data, String publicKey) {
        VerificationResult result = null;
        Error lastError = null;
        if (parsers.isEmpty()) {
            lastError = new Error(Error.Type.INPUT, "Could not find a parser for this format.", "error.parse.payload");
            return new VerificationResult(lastError);
        }
        Error error = null;
        for (VerificationParser parser : parsers) {
            ArrayList<String> publicKeysToUse = new ArrayList<String>();
            if (publicKey != null) {
                publicKeysToUse.add(publicKey);
            }
            try {
                String embeddedPublicKey = this.checkForEmbeddedPublicKey(parser, publicKey, data);
                if (publicKey == null && embeddedPublicKey != null) {
                    publicKeysToUse.add(embeddedPublicKey);
                }
            }
            catch (InvalidInputException e) {
                if (publicKey != null) {
                    error = new Error(Error.Type.VERIFICATION, "Public key does not match with public key in data", "app.view.error.publickeynotmatchdata");
                }
                try {
                    String embeddedPublicKey = this.checkForEmbeddedPublicKey(parser, null, data);
                    if (embeddedPublicKey != null) {
                        publicKeysToUse.add(embeddedPublicKey);
                    }
                }
                catch (InvalidInputException embeddedPublicKey) {
                    // empty catch block
                }
            }
            if (publicKeysToUse.isEmpty()) {
                return new VerificationResult(new Error(Error.Type.INPUT, "Could not find a public key to use", "error.no.publickeysfoundduringverify"));
            }
            for (String keyToTry : publicKeysToUse) {
                try {
                    result = this.tryParser(parser, keyToTry, data);
                    if (result == null || !result.isVerified()) continue;
                    break;
                }
                catch (VerificationException e) {
                    lastError = e.getError();
                }
            }
            if (result == null || !result.isVerified()) continue;
            break;
        }
        if (result == null) {
            result = new VerificationResult(lastError);
        }
        if (error != null) {
            result.addError(error);
        }
        return result;
    }

    public VerificationResult tryParser(VerificationParser parser, String publicKeyToUse, Value data) throws VerificationException {
        if (publicKeyToUse == null || publicKeyToUse.trim().isEmpty()) {
            Error error = new Error(Error.Type.VALIDATION, "Could not find a parser for this public key.", "error.values.publickey.cannot.encode");
            throw new VerificationException(error);
        }
        List<EncodingType> keyTypes = EncodingType.guessType(publicKeyToUse);
        if (keyTypes.isEmpty()) {
            Error error = new Error(Error.Type.INPUT, "no encoding found for key", "error.values.publickey.cannot.encode");
            throw new VerificationException(error);
        }
        VerificationResult result = null;
        Error lastError = null;
        for (EncodingType encodingType : keyTypes) {
            try {
                AtomicReference<IntrinsicVerified> intrinsicVerified;
                byte[] decodedPublicKey = EncodingType.decode(encodingType, publicKeyToUse);
                String decodedData = this.decodeData(data, decodedPublicKey, intrinsicVerified = new AtomicReference<IntrinsicVerified>(IntrinsicVerified.NOT_VERIFIED));
                if (decodedData == null) continue;
                VerificationResult newResult = parser.parseAndVerify(decodedData, decodedPublicKey, intrinsicVerified.get());
                if (newResult != null && newResult.isVerified()) {
                    result = newResult;
                    break;
                }
                if (result != null && result.containsErrorOfType(Error.Type.VERIFICATION)) continue;
                result = newResult;
            }
            catch (DecodingException e) {
                if (lastError != null) continue;
                lastError = new Error(Error.Type.INPUT, "Could not decode public key", "error.values.publickey.cannot.encode");
            }
        }
        return result;
    }

    public String checkForEmbeddedPublicKey(VerificationParser parser, String decodedPublicKey, Value payloadData) throws InvalidInputException {
        if (parser instanceof ContainedPublicKeyParser && payloadData.hasSignedData()) {
            String containedPublicKey = ((ContainedPublicKeyParser)((Object)parser)).parsePublicKey(payloadData.getSignedData().getValue());
            if (decodedPublicKey == null) {
                return containedPublicKey;
            }
            if (!Utils.compareEncodedStrings(decodedPublicKey, containedPublicKey)) {
                throw new InvalidInputException("Public key of does not match with public key in data", "app.view.error.publickeynotmatchdata");
            }
        }
        return decodedPublicKey;
    }

    public VerificationResult verifyUnknown(VerificationParser parser, String rawDataContent, String publicKeyContent) {
        Value value = new Value();
        EncodedData encodedData = new EncodedData();
        encodedData.setValue(rawDataContent);
        value.setEncodedData(encodedData);
        AtomicReference<IntrinsicVerified> maybeIntrinsicVerified = new AtomicReference<IntrinsicVerified>(IntrinsicVerified.NOT_VERIFIED);
        try {
            EncryptedDataDecoder decoder = new EncryptedDataDecoder(publicKeyContent);
            decoder.decode(value, maybeIntrinsicVerified);
        }
        catch (Exception decoder) {
            // empty catch block
        }
        if (!maybeIntrinsicVerified.get().ok()) {
            value.setEncodedData(null);
            SignedData signedData = new SignedData();
            signedData.setValue(rawDataContent);
            value.setSignedData(signedData);
        }
        return this.verify(parser, value, publicKeyContent);
    }
}

