/*
 * Decompiled with CFR 0.152.
 */
package de.safe_ev.transparenzsoftware.verification.format.alfen;

import de.safe_ev.transparenzsoftware.Utils;
import de.safe_ev.transparenzsoftware.verification.ValidationException;
import de.safe_ev.transparenzsoftware.verification.format.alfen.AlfenValidationException;
import java.time.OffsetDateTime;
import java.util.Arrays;

public class AlfenSignature {
    private static final String IDENTIFIER_STRING = "AP";
    private static final int ADAPTER_ID_OFFSET = 0;
    private static final int ADAPTER_ID_LENGTH = 10;
    private static final int ADAPTER_FIRMWARE_VERSION_OFFSET = 10;
    private static final int ADAPTER_FIRMWARE_VERSION_LENGTH = 4;
    private static final int ADAPTER_FIRMWARE_CHECKSUM_OFFSET = 14;
    private static final int ADAPTER_FIRMWARE_CHECKSUM_LENGTH = 2;
    private static final int METER_ID_OFFSET = 16;
    private static final int METER_ID_LENGTH = 10;
    private static final int STATUS_OFFSET = 26;
    private static final int STATUS_LENGTH = 4;
    private static final int SECOND_INDEX_OFFSET = 30;
    private static final int SECOND_INDEX_LENGTH = 4;
    private static final int TIMESTAMP_OFFSET = 34;
    private static final int TIMESTAMP_LENGTH = 4;
    private static final int OBIS_ID_OFFSET = 38;
    private static final int OBIS_ID_LENGTH = 6;
    private static final int UNIT_OFFSET = 44;
    private static final int SCALAR_OFFSET = 45;
    private static final int VALUE_OFFSET = 46;
    private static final int VALUE_LENGTH = 8;
    private static final int UID_OFFSET = 54;
    private static final int UID_LENGTH = 20;
    private static final int SESSIONID_OFFSET = 74;
    private static final int SESSIONID_LENGTH = 4;
    private static final int PAGING_OFFSET = 78;
    private static final int PAGING_LENGTH = 4;
    private static final int DATASET_LENGTH = 82;
    private static final String[] POSSIBLE_TYPE_VALUES = new String[]{"0", "1", "2"};
    private String identifier;
    private String type;
    private String blobVersion;
    private String publicKey;
    private byte[] adapterId;
    private byte[] adapterFirmwareVersion;
    private byte[] adapterFirmwareChecksum;
    private byte[] meterId;
    private byte[] status;
    private byte[] secondIndex;
    private byte[] timestamp;
    private byte[] obisId;
    private byte unit;
    private byte scalar;
    private byte[] value;
    private byte[] uid;
    private byte[] sessionId;
    private byte[] paging;
    private byte[] dataset;
    private byte[] signature;

    public AlfenSignature() {
    }

    public AlfenSignature(String identifier, String type, String blobVersion, String publicKey, byte[] dataset, byte[] signature) throws ValidationException {
        this.setIdentifier(identifier);
        this.setType(type);
        this.setBlobVersion(blobVersion);
        if (dataset.length != 82) {
            throw new AlfenValidationException("Invalid length of dataset data applied", "error.alfen.invaliddatablocklength");
        }
        this.setAdapterId(Utils.copyFromWithLength(dataset, 0, 10));
        this.setAdapterFirmwareVersion(Utils.copyFromWithLength(dataset, 10, 4));
        this.setAdapterFirmwareChecksum(Utils.copyFromWithLength(dataset, 14, 2));
        this.setMeterId(Utils.copyFromWithLength(dataset, 16, 10));
        this.setStatus(Utils.copyFromWithLength(dataset, 26, 4));
        this.setSecondIndex(Utils.copyFromWithLength(dataset, 30, 4));
        this.setTimestamp(Utils.copyFromWithLength(dataset, 34, 4));
        this.setObisId(Utils.copyFromWithLength(dataset, 38, 6));
        this.setUnit(dataset[44]);
        this.setScalar(dataset[45]);
        this.setValue(Utils.copyFromWithLength(dataset, 46, 8));
        this.setUid(Utils.copyFromWithLength(dataset, 54, 20));
        this.setSessionId(Utils.copyFromWithLength(dataset, 74, 4));
        this.setPaging(Utils.copyFromWithLength(dataset, 78, 4));
        this.setPublicKey(publicKey);
        this.setSignature(signature);
        this.dataset = dataset;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) throws ValidationException {
        if (!IDENTIFIER_STRING.equals(identifier)) {
            throw new ValidationException("Identifier not AP");
        }
        this.identifier = identifier;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) throws ValidationException {
        if (type.length() != 1) {
            throw new ValidationException("Type not 1 characters long");
        }
        if (!Arrays.asList(POSSIBLE_TYPE_VALUES).contains(type)) {
            throw new ValidationException(String.format("Invalid type %s given", type));
        }
        this.type = type;
    }

    public String getBlobVersion() {
        return this.blobVersion;
    }

    public void setBlobVersion(String blobVersion) throws ValidationException {
        if (blobVersion.length() != 1) {
            throw new ValidationException("Blob version not 1 characters long");
        }
        this.blobVersion = blobVersion;
    }

    public String getPublicKey() {
        return this.publicKey;
    }

    public void setPublicKey(String publicKey) {
        this.publicKey = publicKey;
    }

    public byte[] getAdapterId() {
        return this.adapterId;
    }

    public void setAdapterId(byte[] adapterId) throws ValidationException {
        if (adapterId.length != 10) {
            throw new ValidationException(String.format("Adapter id length not %s", 10));
        }
        this.adapterId = adapterId;
    }

    public byte[] getMeterId() {
        return this.meterId;
    }

    public long getMeterIdAsLong() {
        return Utils.parseUint8Chain(this.adapterId);
    }

    public void setMeterId(byte[] meterId) throws ValidationException {
        if (meterId.length != 10) {
            throw new ValidationException("Invalid length of meter id");
        }
        this.meterId = meterId;
    }

    public byte[] getStatus() {
        return this.status;
    }

    public void setStatus(byte[] status) throws ValidationException {
        if (status.length != 4) {
            throw new ValidationException("Invalid length of status");
        }
        this.status = status;
    }

    public byte[] getSecondIndex() {
        return this.secondIndex;
    }

    public long getSecondIndexAsLong() {
        return Utils.parseUint32(this.secondIndex, true);
    }

    public void setSecondIndex(byte[] secondIndex) throws ValidationException {
        if (secondIndex.length != 4) {
            throw new ValidationException("Invalid second index length");
        }
        this.secondIndex = secondIndex;
    }

    public byte[] getTimestamp() {
        return this.timestamp;
    }

    public OffsetDateTime getTimestampAsLocalDate() {
        return Utils.timeBytesToTimestamp(this.timestamp);
    }

    public long getTimestampAsLong() {
        return Utils.parseUint32(this.timestamp, true);
    }

    public void setTimestamp(byte[] timestamp) throws ValidationException {
        if (timestamp.length != 4) {
            throw new ValidationException("Invalid timestamp length");
        }
        this.timestamp = timestamp;
    }

    public byte[] getObisId() {
        return this.obisId;
    }

    public void setObisId(byte[] obisId) throws ValidationException {
        if (obisId.length != 6) {
            throw new ValidationException("Invalid length of obis id");
        }
        this.obisId = obisId;
    }

    public byte getUnit() {
        return this.unit;
    }

    public void setUnit(byte unit) {
        this.unit = unit;
    }

    public byte getScalar() {
        return this.scalar;
    }

    public void setScalar(byte scalar) {
        this.scalar = scalar;
    }

    public byte[] getValue() {
        return this.value;
    }

    public long getValueAsLong() {
        return Utils.bytesToLong(Utils.reverseByteOrder(this.value));
    }

    public void setValue(byte[] value) throws ValidationException {
        if (value.length != 8) {
            throw new ValidationException("Invalid length for value given");
        }
        this.value = value;
    }

    public byte[] getUid() {
        return this.uid;
    }

    public void setUid(byte[] uid) {
        this.uid = uid;
    }

    public byte[] getSessionId() {
        return this.sessionId;
    }

    public long getSessionIdAsLong() {
        return Utils.parseUint32(this.sessionId, true);
    }

    public byte[] getPaging() {
        return this.paging;
    }

    public long getPagingAsLong() {
        return Utils.parseUint32(this.paging, true);
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public void setSessionId(byte[] sessionId) throws ValidationException {
        if (sessionId.length != 4) {
            throw new ValidationException("Invalid length for session id");
        }
        this.sessionId = sessionId;
    }

    public void setPaging(byte[] paging) throws ValidationException {
        if (paging.length != 4) {
            throw new ValidationException("Invalid length for paging");
        }
        this.paging = paging;
    }

    public byte[] getAdapterFirmwareVersion() {
        return this.adapterFirmwareVersion;
    }

    public void setAdapterFirmwareVersion(byte[] adapterFirmwareVersion) throws ValidationException {
        if (adapterFirmwareVersion.length != 4) {
            throw new ValidationException("Invalid length for adapter firmware version");
        }
        this.adapterFirmwareVersion = adapterFirmwareVersion;
    }

    public byte[] getAdapterFirmwareChecksum() {
        return this.adapterFirmwareChecksum;
    }

    public void setAdapterFirmwareChecksum(byte[] adapterFirmwareChecksum) throws ValidationException {
        if (adapterFirmwareChecksum.length != 2) {
            throw new ValidationException("Invalid length for adapter firmware checksum");
        }
        this.adapterFirmwareChecksum = adapterFirmwareChecksum;
    }

    public void setSignature(byte[] signature) {
        this.signature = signature;
    }

    public byte[] getDataset() {
        return this.dataset;
    }
}

