/*
 * Decompiled with CFR 0.152.
 */
package de.safe_ev.transparenzsoftware.verification.format.alfen;

import de.safe_ev.transparenzsoftware.Utils;
import de.safe_ev.transparenzsoftware.verification.ContainedPublicKeyParser;
import de.safe_ev.transparenzsoftware.verification.EncodingType;
import de.safe_ev.transparenzsoftware.verification.RegulationLawException;
import de.safe_ev.transparenzsoftware.verification.ValidationException;
import de.safe_ev.transparenzsoftware.verification.VerificationParser;
import de.safe_ev.transparenzsoftware.verification.VerificationType;
import de.safe_ev.transparenzsoftware.verification.format.alfen.AlfenReader;
import de.safe_ev.transparenzsoftware.verification.format.alfen.AlfenSignature;
import de.safe_ev.transparenzsoftware.verification.format.alfen.AlfenSignatureVerifier;
import de.safe_ev.transparenzsoftware.verification.format.alfen.AlfenVerifiedData;
import de.safe_ev.transparenzsoftware.verification.result.Error;
import de.safe_ev.transparenzsoftware.verification.result.IntrinsicVerified;
import de.safe_ev.transparenzsoftware.verification.result.VerificationResult;
import de.safe_ev.transparenzsoftware.verification.xml.VerifiedData;

public class AlfenVerificationParser
implements VerificationParser,
ContainedPublicKeyParser {
    private final AlfenReader reader = new AlfenReader();
    private final AlfenSignatureVerifier verifier = new AlfenSignatureVerifier();

    @Override
    public VerificationType getVerificationType() {
        return VerificationType.ALFEN;
    }

    @Override
    public boolean canParseData(String data) {
        try {
            AlfenSignature signatureData = this.reader.parseString(data);
            return true;
        }
        catch (ValidationException e) {
            return false;
        }
    }

    @Override
    public VerificationResult parseAndVerify(String data, byte[] publicKey, IntrinsicVerified intrinsicVerified) {
        VerificationResult result;
        AlfenSignature signatureData;
        try {
            signatureData = this.reader.parseString(data);
        }
        catch (ValidationException e) {
            return new VerificationResult(Error.withValidationException(e));
        }
        boolean verified = false;
        AlfenVerifiedData verifiedData = null;
        Error error = null;
        try {
            verified = intrinsicVerified.ok() || this.verifier.verify(publicKey, signatureData.getSignature(), signatureData.getDataset());
            verifiedData = new AlfenVerifiedData(signatureData, EncodingType.PLAIN);
            if (!verified) {
                error = Error.withVerificationFailed();
            }
        }
        catch (ValidationException e) {
            error = Error.withValidationException(e);
        }
        VerificationResult verificationResult = result = verified ? new VerificationResult((VerifiedData)verifiedData, intrinsicVerified) : new VerificationResult((VerifiedData)verifiedData, error);
        if (verifiedData != null && verified) {
            try {
                verifiedData.calculateAdapterError();
                verifiedData.calculateMeterError();
            }
            catch (RegulationLawException e) {
                result.addError(new Error(Error.Type.VERIFICATION, "Meter error happened", e.getLocalizedMessageKey()));
            }
        }
        return result;
    }

    @Override
    public Class getVerfiedDataClass() {
        return AlfenVerifiedData.class;
    }

    @Override
    public String parsePublicKey(String data) {
        try {
            AlfenSignature signatureData = this.reader.parseString(data);
            return signatureData.getPublicKey();
        }
        catch (ValidationException validationException) {
            return null;
        }
    }

    @Override
    public String createFormattedKey(String data) {
        String parsedKey = this.parsePublicKey(data);
        return Utils.splitStringToGroups(parsedKey, 4);
    }
}

