/*
 * Decompiled with CFR 0.152.
 */
package de.safe_ev.transparenzsoftware.verification.format.ocmf;

import de.safe_ev.transparenzsoftware.verification.EncodingType;
import de.safe_ev.transparenzsoftware.verification.ValidationException;
import de.safe_ev.transparenzsoftware.verification.format.ocmf.OCMFValidationException;

public class OCMFSignature {
    private String SE;
    private String SM;
    private String SA;
    private String SD;

    public String getSE() {
        return this.SE;
    }

    public EncodingType getEncoding() {
        return this.SE != null ? EncodingType.fromCode(this.SE) : EncodingType.HEX;
    }

    public void setSE(String SE2) {
        this.SE = SE2;
    }

    public String getSM() {
        return this.SM;
    }

    public String getSignatureMimeType() {
        return this.getSM() == null ? "application/x-der" : this.getSM();
    }

    public void setSM(String SM5) {
        this.SM = SM5;
    }

    public String getSA() {
        return this.SA;
    }

    public String getCurve() throws ValidationException {
        return this.getSplittedSA()[1];
    }

    public String getHashing() throws ValidationException {
        return this.getSplittedSA()[2];
    }

    private String[] getSplittedSA() throws OCMFValidationException {
        String type = this.SA == null ? "ECDSA-secp256r1-SHA256" : this.SA;
        String[] splitted = type.split("-");
        if (splitted.length != 3) {
            throw new OCMFValidationException("Invalid signature algorithm for OCMF", "error.ocmf.invalid.signaturealgorithm");
        }
        splitted[1] = splitted[1].toLowerCase();
        if (splitted[1].indexOf("brainpoolp") < 0) {
            splitted[1] = splitted[1].replaceAll("brainpool", "brainpoolp");
        }
        return splitted;
    }

    public void setSA(String SA) {
        this.SA = SA;
    }

    public String getSD() {
        return this.SD;
    }

    public void setSD(String SD) {
        this.SD = SD;
    }

    public String getSignatureMethod() throws OCMFValidationException {
        return this.getSplittedSA()[0];
    }
}

