/*
 * Decompiled with CFR 0.152.
 */
package de.safe_ev.transparenzsoftware.verification.format.ocmf;

import de.safe_ev.transparenzsoftware.Utils;
import de.safe_ev.transparenzsoftware.verification.ASN1Exception;
import de.safe_ev.transparenzsoftware.verification.ASN1Utils;
import de.safe_ev.transparenzsoftware.verification.ValidationException;
import de.safe_ev.transparenzsoftware.verification.VerificationLogger;
import de.safe_ev.transparenzsoftware.verification.format.ocmf.OCMFValidationException;
import de.safe_ev.transparenzsoftware.verification.format.sml.Verifier;
import java.security.Security;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.asn1.sec.SECNamedCurves;
import org.bouncycastle.asn1.teletrust.TeleTrusTNamedCurves;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.signers.ECDSASigner;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECPoint;

public class OCMFVerifier
implements Verifier {
    private static final Logger LOGGER = LogManager.getLogger(OCMFVerifier.class);
    private String curve;

    public OCMFVerifier(String curve) {
        this.curve = curve;
        Security.addProvider(new BouncyCastleProvider());
    }

    @Override
    public boolean verify(byte[] publicKey, byte[] signature, byte[] payloadData) throws ValidationException {
        ASN1Utils.SignatureRS signatureRS;
        ECDSASigner signer = new ECDSASigner();
        ECPublicKeyParameters publicKeyParsed = this.preparePublicKeyData(publicKey);
        signer.init(false, publicKeyParsed);
        try {
            signatureRS = ASN1Utils.readSignatureRS(signature);
        }
        catch (ASN1Exception e) {
            throw new OCMFValidationException("Invalid length of asn1Signature given", "error.invalid.asn1Signature.length", e);
        }
        byte[] hashedMessage = Utils.hashSHA256(payloadData);
        boolean verify = signer.verifySignature(hashedMessage, signatureRS.getR(), signatureRS.getS());
        VerificationLogger.log("OCMF", "ECDSA", publicKey, hashedMessage, signature, verify);
        return verify;
    }

    private ECPublicKeyParameters preparePublicKeyData(byte[] rawPublicKey) throws ValidationException {
        ECPublicKeyParameters publicKeyParsed;
        X9ECParameters ecParameters;
        byte[] publicKeyASN1Parsed;
        if (rawPublicKey == null) {
            throw new OCMFValidationException("Cannot read public key (null)", "error.values.publickey.cannot.encode");
        }
        try {
            publicKeyASN1Parsed = ASN1Utils.readPublicKey(rawPublicKey);
        }
        catch (ASN1Exception e) {
            throw new OCMFValidationException("Cannot read public key", "error.values.publickey.cannot.encode");
        }
        X9ECParameters x9ECParameters = ecParameters = this.curve.contains("brain") ? TeleTrusTNamedCurves.getByName(this.curve) : SECNamedCurves.getByName(this.curve);
        if (ecParameters == null) {
            throw new OCMFValidationException("Invalid curve provided", "error.invalid.curve.name");
        }
        ECCurve ecCurve = ecParameters.getCurve();
        ECDomainParameters ecDomainParameters = new ECDomainParameters(ecCurve, ecParameters.getG(), ecParameters.getN(), ecParameters.getH(), ecParameters.getSeed());
        try {
            ECPoint publicKeyPoint = ecCurve.decodePoint(publicKeyASN1Parsed);
            publicKeyParsed = new ECPublicKeyParameters(publicKeyPoint, ecDomainParameters);
        }
        catch (IllegalArgumentException e) {
            LOGGER.error("Invalid point given for public key", (Throwable)e);
            throw new OCMFValidationException("Invalid public key point given", "error.invalid.public.key", e);
        }
        return publicKeyParsed;
    }
}

