/*
 * Decompiled with CFR 0.152.
 */
package de.safe_ev.transparenzsoftware.verification.format.pcdf;

import de.safe_ev.transparenzsoftware.verification.ContainedPublicKeyParser;
import de.safe_ev.transparenzsoftware.verification.VerificationLogger;
import de.safe_ev.transparenzsoftware.verification.VerificationParser;
import de.safe_ev.transparenzsoftware.verification.VerificationType;
import de.safe_ev.transparenzsoftware.verification.format.pcdf.PcdfVerifiedData;
import de.safe_ev.transparenzsoftware.verification.result.Error;
import de.safe_ev.transparenzsoftware.verification.result.IntrinsicVerified;
import de.safe_ev.transparenzsoftware.verification.result.VerificationResult;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.AlgorithmParameters;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.DLSequence;
import org.bouncycastle.asn1.sec.SECNamedCurves;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.signers.ECDSASigner;

public class PcdfVerificationParser
implements VerificationParser,
ContainedPublicKeyParser {
    @Override
    public String parsePublicKey(String data) {
        int pos = data.indexOf("(PK:");
        if (pos != -1) {
            String pk = data.substring(pos + 4);
            int pos2 = pk.indexOf(")(SG:");
            pk = pos2 != -1 ? pk.substring(0, pos2) : pk.substring(0, pk.length() - 1);
            return pk;
        }
        return null;
    }

    @Override
    public String createFormattedKey(String data) {
        int pos = data.indexOf("(PK:");
        if (pos != -1) {
            int ps = data.indexOf(")", pos);
            String pubKey = data.substring(pos + 4, ps);
            return pubKey;
        }
        return null;
    }

    @Override
    public VerificationType getVerificationType() {
        return VerificationType.PCDF;
    }

    @Override
    public boolean canParseData(String data) {
        int pos = data.indexOf("128.8.0");
        if (pos == 0 || pos == 1 || pos == 6) {
            return true;
        }
        return data.indexOf("(RV:") > 0;
    }

    private boolean checkSignAndPublicKeyByte(String data, String sign, byte[] pke) {
        try {
            int lns = sign.length();
            byte[] se = new byte[lns / 2];
            for (int i = 0; i < lns / 2; ++i) {
                String val = sign.substring(i * 2, i * 2 + 2);
                se[i] = (byte)Integer.parseInt(val, 16);
            }
            byte[] x = new byte[32];
            byte[] y = new byte[32];
            System.arraycopy(pke, 1, x, 0, 32);
            System.arraycopy(pke, 33, y, 0, 32);
            try {
                X9ECParameters params = SECNamedCurves.getByName("secp256r1");
                ECDomainParameters ecParams = new ECDomainParameters(params.getCurve(), params.getG(), params.getN(), params.getH());
                ECPublicKeyParameters pubKeyParams = new ECPublicKeyParameters(ecParams.getCurve().decodePoint(pke), ecParams);
                ASN1InputStream asn1 = new ASN1InputStream(se);
                ECDSASigner signer2 = new ECDSASigner();
                signer2.init(false, pubKeyParams);
                DLSequence seq = (DLSequence)asn1.readObject();
                BigInteger r = ((ASN1Integer)seq.getObjectAt(0)).getPositiveValue();
                BigInteger s2 = ((ASN1Integer)seq.getObjectAt(1)).getPositiveValue();
                MessageDigest digest = MessageDigest.getInstance("SHA-256");
                byte[] hash = digest.digest(data.getBytes(StandardCharsets.UTF_8));
                boolean result = signer2.verifySignature(hash, r.abs(), s2.abs());
                VerificationLogger.log("PCDF", "secp256r1", pke, hash, se, result);
                return result;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    private byte[] makePublicKeyByte(String pk) {
        int ln = pk.length();
        byte[] pke = new byte[ln / 2];
        int i = 0;
        for (i = 0; i < ln / 2; ++i) {
            String val = pk.substring(i * 2, i * 2 + 2);
            pke[i] = (byte)Integer.parseInt(val, 16);
        }
        return pke;
    }

    private boolean checkTwoBytePublicKeys(byte[] pk1, byte[] pk2) {
        if (pk1.length != pk2.length) {
            return false;
        }
        for (int i = 0; i < pk1.length; ++i) {
            if (pk1[i] == pk2[i]) continue;
            return false;
        }
        return true;
    }

    private boolean checkSignAndPublicKey(String data, String sign, String pk) {
        try {
            int ln = pk.length();
            byte[] pke = new byte[ln / 2];
            int i = 0;
            for (i = 0; i < ln / 2; ++i) {
                String val = pk.substring(i * 2, i * 2 + 2);
                pke[i] = (byte)Integer.parseInt(val, 16);
            }
            int lns = sign.length();
            byte[] se = new byte[lns / 2];
            for (i = 0; i < lns / 2; ++i) {
                String val = sign.substring(i * 2, i * 2 + 2);
                se[i] = (byte)Integer.parseInt(val, 16);
            }
            byte[] x = new byte[32];
            byte[] y = new byte[32];
            System.arraycopy(pke, 1, x, 0, 32);
            System.arraycopy(pke, 33, y, 0, 32);
            try {
                KeyFactory kf = KeyFactory.getInstance("EC");
                AlgorithmParameters parameters = AlgorithmParameters.getInstance("EC");
                parameters.init(new ECGenParameterSpec("secp256r1"));
                ECParameterSpec ecParameterSpec = parameters.getParameterSpec(ECParameterSpec.class);
                ECPublicKeySpec ecPublicKeySpec = new ECPublicKeySpec(new ECPoint(new BigInteger(x), new BigInteger(y)), ecParameterSpec);
                ECPublicKey ecPublicKey = (ECPublicKey)kf.generatePublic(ecPublicKeySpec);
                PublicKey publicKey = kf.generatePublic(ecPublicKeySpec);
                Signature signature = Signature.getInstance("SHA256withECDSA");
                signature.initVerify(publicKey);
                byte[] bytes = data.getBytes();
                signature.update(bytes);
                boolean verified = signature.verify(se);
                return verified;
            }
            catch (NoSuchAlgorithmException | InvalidKeySpecException | InvalidParameterSpecException generalSecurityException) {
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    @Override
    public VerificationResult parseAndVerify(String data, byte[] publicKey, IntrinsicVerified intrinsicVerified) {
        String pbKeyStr = this.parsePublicKey(data);
        PcdfVerifiedData verData = new PcdfVerifiedData(pbKeyStr, data);
        VerificationResult vr = null;
        byte[] dtPK = this.makePublicKeyByte(pbKeyStr);
        if (this.checkTwoBytePublicKeys(dtPK, publicKey)) {
            int pos = data.indexOf("(SG:");
            if (pos != -1) {
                String sign;
                String justData = data.substring(0, pos);
                if (!this.checkSignAndPublicKeyByte(justData, sign = data.substring(pos + 4, data.length() - 1), publicKey)) {
                    Error er = new Error(Error.Type.VALIDATION, "Signature verification failed", "error.pcdf.verification.signature.failed");
                    vr = new VerificationResult(verData, false, intrinsicVerified);
                    vr.addError(er);
                } else {
                    vr = new VerificationResult(verData, true, intrinsicVerified);
                }
            } else {
                Error er = new Error(Error.Type.VALIDATION, "No signature present in data tupple", "error.pcdf.missing.signature");
                vr = new VerificationResult(verData, false, intrinsicVerified);
                vr.addError(er);
            }
        } else {
            Error er = new Error(Error.Type.VALIDATION, "Wrong Public Key", "error.invalid.public.key.embedded");
            vr = new VerificationResult(verData, false, intrinsicVerified);
            vr.addError(er);
        }
        return vr;
    }

    @Override
    public Class getVerfiedDataClass() {
        return PcdfVerifiedData.class;
    }
}

