/*
 * Decompiled with CFR 0.152.
 */
package de.safe_ev.transparenzsoftware.verification.format.pcdf;

import de.safe_ev.transparenzsoftware.gui.views.helper.DetailsList;
import de.safe_ev.transparenzsoftware.i18n.Translator;
import de.safe_ev.transparenzsoftware.verification.RegulationLawException;
import de.safe_ev.transparenzsoftware.verification.ValidationException;
import de.safe_ev.transparenzsoftware.verification.VerificationType;
import de.safe_ev.transparenzsoftware.verification.xml.Meter;
import de.safe_ev.transparenzsoftware.verification.xml.VerifiedData;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;

public class PcdfVerifiedData
extends VerifiedData {
    private final String publicKey;
    private final List<Meter> meters;
    private final DetailsList addData;

    public PcdfVerifiedData(String pk, String chData) {
        this.publicKey = pk;
        this.meters = new ArrayList<Meter>();
        String cons = this.extractAttribute("RV", chData);
        cons = cons.replace("*kWh", "");
        this.addData = new DetailsList();
        String startTime = this.extractAttribute("ST", chData);
        this.addData.put(Translator.get("app.verify.pcdf.charge.start"), this.timeNormalizer(startTime));
        String stopTime = this.extractAttribute("CT", chData);
        this.addData.put(Translator.get("app.verify.pcdf.charge.current.time"), this.timeNormalizer(stopTime));
        double consDou = Double.parseDouble(cons);
        String tsStr = this.extractAttribute("CT", chData);
        OffsetDateTime odt = OffsetDateTime.parse(this.timeNormalizer(startTime) + "+00:00");
        Meter first = new Meter(0.0, odt, Meter.Type.START, Meter.TimeSyncType.REALTIME, 0, false);
        this.meters.add(first);
        OffsetDateTime odt2 = OffsetDateTime.parse(this.timeNormalizer(stopTime) + "+00:00");
        Meter met = new Meter(consDou, odt2, Meter.Type.STOP, Meter.TimeSyncType.REALTIME, 0, false);
        this.meters.add(met);
        String chDur = this.extractAttribute("CD", chData);
        this.addData.put(Translator.get("app.verify.pcdf.charge.duration"), this.durationNormalizer(chDur));
        String billValid = this.extractAttribute("BV", chData);
        if (billValid.equals("1")) {
            this.addData.put(Translator.get("app.verify.pcdf.charge.billing.validity"), Translator.get("app.verify.pcdf.charge.yes"));
        } else {
            this.addData.put(Translator.get("app.verify.pcdf.charge.billing.validity"), Translator.get("app.verify.pcdf.charge.no"));
        }
        String stopValid = this.extractAttribute("SP", chData);
        if (stopValid.equals("1")) {
            this.addData.put(Translator.get("app.verify.pcdf.charge.stop.time"), Translator.get("app.verify.pcdf.charge.yes"));
        } else {
            this.addData.put(Translator.get("app.verify.pcdf.charge.stop.time"), Translator.get("app.verify.pcdf.charge.no"));
        }
        String chCount = this.extractAttribute("CSC", chData);
        this.addData.put(Translator.get("app.verify.pcdf.charge.counter"), chCount);
        String cs = this.extractAttribute("CS", chData);
        this.addData.put(Translator.get("app.verify.pcdf.charge.software"), cs);
        String hw = this.extractAttribute("HW", chData);
        this.addData.put(Translator.get("app.verify.pcdf.charge.hardware"), hw);
        String dt = this.extractAttribute("DT", chData);
        if (dt.equals("0")) {
            this.addData.put(Translator.get("app.verify.pcdf.charge.dcmeter.type"), "PES DCMeter EU");
        } else {
            this.addData.put(Translator.get("app.verify.pcdf.charge.dcmeter.type"), Translator.get("app.verify.pcdf.unknown.dcmeter.type"));
        }
        String si = this.extractAttribute("SI", chData);
        String[] vll = si.split("\\*");
        this.addData.put(Translator.get("app.verify.pcdf.charge.userid"), vll[0]);
        this.addData.put(Translator.get("app.verify.pcdf.charge.userid.type"), this.getTagType(vll[1]));
        this.addData.put(Translator.get("app.verify.pcdf.charge.txid"), vll[2]);
    }

    private String getTagType(String intType) {
        int intInt = Integer.parseInt(intType);
        if (intInt == 1) {
            return Translator.get("app.verify.pcdf.userid.type.rfid");
        }
        if (intInt == 2) {
            return Translator.get("app.verify.pcdf.userid.type.emaid");
        }
        if (intInt == 3) {
            return Translator.get("app.verify.pcdf.userid.type.creditcard");
        }
        if (intInt == 4) {
            return Translator.get("app.verify.pcdf.userid.type.remote");
        }
        if (intInt == 5) {
            return Translator.get("app.verify.pcdf.userid.type.nfc");
        }
        return Translator.get("app.verify.pcdf.userid.type.unknown");
    }

    private String timeNormalizer(String timeInfo) {
        timeInfo = "20" + (String)timeInfo;
        timeInfo = ((String)timeInfo).substring(0, 4) + "-" + ((String)timeInfo).substring(4, 6) + "-" + ((String)timeInfo).substring(6, 8) + "T" + ((String)timeInfo).substring(8, 10) + ":" + ((String)timeInfo).substring(10, 12) + ":" + ((String)timeInfo).substring(12);
        return timeInfo;
    }

    private String durationNormalizer(String durInfo) {
        durInfo = ((String)(durInfo = (String)durInfo + "sec")).charAt(0) == '0' && ((String)durInfo).charAt(1) == '0' ? (((String)(durInfo = ((String)durInfo).substring(2))).charAt(0) == '0' && ((String)durInfo).charAt(1) == '0' ? ((String)durInfo).substring(2) : ((String)durInfo).substring(0, 2) + "min " + ((String)durInfo).substring(2)) : ((String)durInfo).substring(0, 2) + "h " + ((String)durInfo).substring(2, 4) + "min " + ((String)durInfo).substring(4);
        return durInfo;
    }

    private String extractAttribute(String attr, String chData) {
        int pos = chData.indexOf("(" + attr + ":");
        if (pos != -1) {
            int pos1 = chData.indexOf(")", pos);
            String attrVal = chData.substring(pos + attr.length() + 2, pos1);
            return attrVal;
        }
        return null;
    }

    @Override
    public List<Meter> getMeters() {
        return this.meters;
    }

    @Override
    public String getFormat() {
        return VerificationType.PCDF.name();
    }

    @Override
    public String getPublicKey() {
        return this.publicKey;
    }

    @Override
    public String getEncoding() {
        return null;
    }

    @Override
    public DetailsList getAdditionalData() {
        return this.addData;
    }

    @Override
    public boolean lawConform(VerifiedData stopValue) throws RegulationLawException, ValidationException {
        return false;
    }
}

