/*
 * Decompiled with CFR 0.152.
 */
package de.safe_ev.transparenzsoftware.verification.format.sml.EDL40;

import de.safe_ev.transparenzsoftware.verification.DecodingException;
import de.safe_ev.transparenzsoftware.verification.EncodingType;
import de.safe_ev.transparenzsoftware.verification.ValidationException;
import de.safe_ev.transparenzsoftware.verification.VerificationType;
import de.safe_ev.transparenzsoftware.verification.format.sml.EDL40.SMLReader;
import de.safe_ev.transparenzsoftware.verification.format.sml.SMLSignature;
import de.safe_ev.transparenzsoftware.verification.format.sml.SMLSignatureVerifier256;
import de.safe_ev.transparenzsoftware.verification.format.sml.SMLVerificationParserBase;
import de.safe_ev.transparenzsoftware.verification.result.Error;
import de.safe_ev.transparenzsoftware.verification.result.IntrinsicVerified;
import de.safe_ev.transparenzsoftware.verification.result.VerificationResult;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EDL40VerificationParser
extends SMLVerificationParserBase {
    private static final Logger LOGGER = LogManager.getLogger(EDL40VerificationParser.class);
    private final SMLReader smlReader;

    public EDL40VerificationParser() {
        this.verifier2 = new SMLSignatureVerifier256();
        this.smlReader = new SMLReader();
    }

    @Override
    public VerificationResult parseAndVerify(String data, byte[] publicKey, IntrinsicVerified intrinsicVerified) {
        LOGGER.info("Starting... data=" + data);
        List<EncodingType> typeList = EncodingType.guessType(data);
        VerificationResult verificationResult = null;
        for (EncodingType encodingType : typeList) {
            try {
                SMLSignature smlSignature = this.smlReader.parsePayloadData(encodingType.decode(data));
                verificationResult = this.parseAndVerifyWithSmlData(smlSignature, VerificationType.EDL_40_P, EncodingType.BASE64, publicKey, intrinsicVerified);
                return verificationResult;
            }
            catch (ValidationException e) {
                verificationResult = new VerificationResult(Error.withValidationException(e));
            }
            catch (DecodingException e) {
                verificationResult = new VerificationResult(Error.withDecodingSignatureFailed());
            }
        }
        return verificationResult;
    }

    @Override
    public VerificationType getVerificationType() {
        return VerificationType.EDL_40_P;
    }

    @Override
    public boolean canParseData(String data) {
        List<EncodingType> encodingTypes = EncodingType.guessType(data);
        if (encodingTypes.size() == 0) {
            LOGGER.info("Data not matching for " + String.valueOf((Object)VerificationType.EDL_40_P) + ". Not base64.");
            return false;
        }
        boolean match = false;
        for (EncodingType dataTypes : encodingTypes) {
            try {
                SMLSignature smlSignature = this.smlReader.parsePayloadData(dataTypes.decode(data));
                if (smlSignature.getProvidedSignature() == null) {
                    LOGGER.info("Data not matching for " + String.valueOf((Object)VerificationType.EDL_40_P) + " and encoding " + String.valueOf((Object)dataTypes) + ". Not a full sml data set.");
                    continue;
                }
                match = true;
                break;
            }
            catch (DecodingException | ValidationException e) {
                LOGGER.info("Data not matching for " + String.valueOf((Object)VerificationType.EDL_40_P) + " and encoding " + String.valueOf((Object)dataTypes) + ". Invalid sml data.");
            }
        }
        if (match) {
            LOGGER.info("Match for " + String.valueOf((Object)VerificationType.EDL_40_P) + " detected");
        }
        return match;
    }
}

