/*
 * Decompiled with CFR 0.152.
 */
package de.safe_ev.transparenzsoftware.verification.format.sml.EDL40;

import de.safe_ev.transparenzsoftware.verification.ValidationException;
import de.safe_ev.transparenzsoftware.verification.format.sml.EDL40.EDL40Signature;
import de.safe_ev.transparenzsoftware.verification.format.sml.SMLConfig;
import de.safe_ev.transparenzsoftware.verification.format.sml.SMLSignature;
import de.safe_ev.transparenzsoftware.verification.format.sml.SMLUtils;
import de.safe_ev.transparenzsoftware.verification.format.sml.SMLValidationException;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openmuc.jsml.structures.ASNObject;
import org.openmuc.jsml.structures.Integer64;
import org.openmuc.jsml.structures.OctetString;
import org.openmuc.jsml.structures.SmlListEntry;
import org.openmuc.jsml.structures.SmlListType;
import org.openmuc.jsml.structures.SmlMessage;
import org.openmuc.jsml.structures.SmlTime;
import org.openmuc.jsml.structures.SmlTimestamp;
import org.openmuc.jsml.structures.SmlTimestampLocal;
import org.openmuc.jsml.structures.Unsigned16;
import org.openmuc.jsml.structures.Unsigned32;
import org.openmuc.jsml.structures.Unsigned8;
import org.openmuc.jsml.structures.responses.SmlGetListRes;
import org.openmuc.jsml.structures.responses.SmlPublicCloseRes;
import org.openmuc.jsml.structures.responses.SmlPublicOpenRes;
import org.openmuc.jsml.transport.MessageExtractor;

public class SMLReader {
    private static final Logger LOGGER = LogManager.getLogger(SMLReader.class);
    private static final String TYPE_CONTRACT_ID = "81 82 81 54 01 FF";
    private static final String TYPE_SIGNED_VALUE = "01 00 01 11 00 FF";
    private static final String TYPE_SIGNED_VALUE_2 = "01 00 01 08 00 FF";
    private static final String TYPE_PAGINATION = "81 80 81 71 01 FF";
    private static final String TYPE_MANUFACTURER_SPECIFIC = "81 80 81 61 01 FF";
    private static final String TYPE_SECONDS_INDEX = "81 00 60 08 00 01";
    private static final String TYPE_HIST_VALUE = "01 00 01 11 00 64";
    private static final String TYPE_HIST_VALUE_COMP = "01 00 01 11 00 C8";
    private static final String TYPE_POWERLINE_REST = "00 AF 6C 6C 72 FF";
    private static final String TYPE_STOPWATCH = "00 AF 64 75 72 FF";
    private static final String TYPE_PRICE = "00 AF 70 72 63 FF";
    private static final String TYPE_SIGNATURE_VERSION = "00 AF 73 76 72 FF";

    private SMLSignature parseASNObject(ASNObject asnObject) throws ValidationException {
        EDL40Signature parsedSml = null;
        if (asnObject instanceof SmlPublicOpenRes) {
            SmlPublicOpenRes openRes = (SmlPublicOpenRes)asnObject;
            if (SMLConfig.DEBUG_SML_MESSAGES) {
                LOGGER.debug("Found SmlPublicOpenRes message");
            }
        } else if (asnObject instanceof SmlGetListRes) {
            if (SMLConfig.DEBUG_SML_MESSAGES) {
                LOGGER.debug("Found SmlGetListRes message");
            }
            parsedSml = new EDL40Signature();
            SmlGetListRes getListRes = (SmlGetListRes)asnObject;
            if (SMLConfig.DEBUG_SML_MESSAGES) {
                this.showDebugInformation(getListRes);
            }
            byte[] originalSignature = getListRes.getListSignature().getValue();
            parsedSml.setBytesLog(originalSignature[originalSignature.length - 2], originalSignature[originalSignature.length - 1]);
            parsedSml.setProvidedSignature(originalSignature);
            parsedSml.setServerId(getListRes.getServerId().getValue());
            block28: for (SmlListEntry smlEntry : getListRes.getValList().getValListEntry()) {
                LOGGER.debug("verify smlEntry " + String.valueOf(smlEntry.getObjName()));
                if (smlEntry.getObjName() == null) {
                    LOGGER.warn("Entry without an asnObject name found");
                    continue;
                }
                switch (smlEntry.getObjName().toHexString()) {
                    case "81 82 81 54 01 FF": {
                        if (smlEntry.getValue().getChoice() instanceof OctetString) {
                            OctetString contractId = (OctetString)smlEntry.getValue().getChoice();
                            parsedSml.setContractId(contractId.getValue(), true);
                        }
                        if (!(smlEntry.getValTime().getChoice() instanceof SmlTimestampLocal)) continue block28;
                        parsedSml.setTimestampContractId(SMLUtils.parseSmlTimestamp((SmlTimestampLocal)smlEntry.getValTime().getChoice()));
                        continue block28;
                    }
                    case "01 00 01 11 00 FF": {
                        ASNObject statusChoice;
                        OctetString obisIDElement = smlEntry.getObjName();
                        parsedSml.setObisNr(obisIDElement.getValue());
                        Long wh = this.getUIntOrLong(smlEntry.getValue().getChoice());
                        if (wh != null) {
                            this.setScalerAndMeter(parsedSml, smlEntry, wh);
                        }
                        if (smlEntry.getValTime().getChoice() instanceof SmlTimestampLocal) {
                            parsedSml.setTimestamp(SMLUtils.parseSmlTimestamp((SmlTimestampLocal)smlEntry.getValTime().getChoice()));
                        }
                        if (!((statusChoice = smlEntry.getStatus().getChoice()) instanceof Unsigned32)) continue block28;
                        int status = ((Unsigned32)statusChoice).getVal();
                        if (parsedSml.isEmoc()) {
                            status = this.transformStatus(status);
                        }
                        parsedSml.setStatus(status);
                        continue block28;
                    }
                    case "01 00 01 08 00 FF": {
                        OctetString obisIDElement2 = smlEntry.getObjName();
                        parsedSml.setObisNr(obisIDElement2.getValue());
                        Integer64 wh2 = (Integer64)smlEntry.getValue().getChoice();
                        this.setScalerAndMeter(parsedSml, smlEntry, wh2.getVal());
                        if (smlEntry.getValTime().getChoice() instanceof SmlTimestampLocal) {
                            parsedSml.setTimestamp(SMLUtils.parseSmlTimestamp((SmlTimestampLocal)smlEntry.getValTime().getChoice()));
                        } else if (smlEntry.getValTime().getChoice() instanceof SmlTimestamp) {
                            parsedSml.setTimestamp(SMLUtils.parseSmlTimestamp((SmlTimestamp)smlEntry.getValTime().getChoice()));
                        }
                        Unsigned32 secondsIndex2 = new Unsigned32(708606L);
                        parsedSml.setSecondsIndex(secondsIndex2.getVal());
                        Unsigned32 paginationData2 = new Unsigned32(10L);
                        parsedSml.setPagination(paginationData2.getVal());
                        ASNObject statusChoice2 = smlEntry.getStatus().getChoice();
                        if (!(statusChoice2 instanceof Unsigned32)) continue block28;
                        int status = ((Unsigned32)statusChoice2).getVal();
                        if (parsedSml.isEmoc()) {
                            status = this.transformStatus(status);
                        }
                        parsedSml.setStatus(status);
                        continue block28;
                    }
                    case "81 80 81 71 01 FF": {
                        Long pagination = this.getUIntOrLong(smlEntry.getValue().getChoice());
                        if (pagination != null) {
                            parsedSml.setPagination(pagination.intValue());
                            continue block28;
                        }
                        throw new SMLValidationException("pagination data does not contain a unsigned integer");
                    }
                    case "81 00 60 08 00 01": {
                        if (!(smlEntry.getValue().getChoice() instanceof SmlListType)) {
                            throw new SMLValidationException("Time data entry does not contain a smlListType");
                        }
                        SmlListType smlListType = (SmlListType)smlEntry.getValue().getChoice();
                        if (!(smlListType.getChoice() instanceof SmlTime)) {
                            throw new SMLValidationException("SmlListtype data does not contain a time entry");
                        }
                        SmlTime smlTime = (SmlTime)smlListType.getChoice();
                        if (!(smlTime.getChoice() instanceof Unsigned32)) {
                            throw new SMLValidationException("SmlTime dose not contain secondsIndex");
                        }
                        Unsigned32 secondsIndex = (Unsigned32)smlTime.getChoice();
                        parsedSml.setSecondsIndex(secondsIndex.getVal());
                        continue block28;
                    }
                    case "81 80 81 61 01 FF": {
                        continue block28;
                    }
                    case "01 00 01 11 00 64": {
                        Long histValue = this.getUIntOrLong(smlEntry.getValue().getChoice());
                        parsedSml.setHistoricalValue(histValue);
                        continue block28;
                    }
                    case "01 00 01 11 00 C8": {
                        Long histValueComp = this.getUIntOrLong(smlEntry.getValue().getChoice());
                        parsedSml.setHistoricalValueComp(histValueComp);
                        continue block28;
                    }
                    case "00 AF 6C 6C 72 FF": {
                        Long powerlineResistance = this.getUIntOrLong(smlEntry.getValue().getChoice());
                        parsedSml.setPowerlineResistance(powerlineResistance.intValue());
                        continue block28;
                    }
                    case "00 AF 64 75 72 FF": {
                        Long stopwatch = this.getUIntOrLong(smlEntry.getValue().getChoice());
                        parsedSml.setStopwatch(stopwatch.intValue());
                        continue block28;
                    }
                    case "00 AF 70 72 63 FF": {
                        Long price = this.getUIntOrLong(smlEntry.getValue().getChoice());
                        parsedSml.setPrice(price.intValue());
                        continue block28;
                    }
                    case "00 AF 73 76 72 FF": {
                        Long signatureVersion = this.getUIntOrLong(smlEntry.getValue().getChoice());
                        LOGGER.info("Signature Version: " + signatureVersion);
                        parsedSml.setVersion(signatureVersion.intValue());
                        continue block28;
                    }
                    default: {
                        LOGGER.warn("Unknown element " + smlEntry.getObjName().toHexString() + " = " + String.valueOf(smlEntry.getValue()));
                    }
                }
            }
        } else if (asnObject instanceof SmlPublicCloseRes) {
            SmlPublicCloseRes closeRes = (SmlPublicCloseRes)asnObject;
            if (SMLConfig.DEBUG_SML_MESSAGES) {
                LOGGER.debug("Found SmlPublicCloseRes message");
            }
        } else {
            LOGGER.warn("Unknown sml object found: " + asnObject.getClass().getSimpleName());
        }
        return parsedSml;
    }

    private byte transformStatus(int val) {
        BitTranslator b = new BitTranslator(val);
        b.from(0, 17).from(3, 31).from(4, 16).from(5, 11).from(6, 9).from(7, 8);
        return (byte)b.get();
    }

    private Long getUIntOrLong(ASNObject choice) {
        if (choice instanceof Integer64) {
            return ((Integer64)choice).getVal();
        }
        if (choice instanceof Unsigned8) {
            return ((Unsigned8)choice).getVal();
        }
        if (choice instanceof Unsigned32) {
            return ((Unsigned32)choice).getLongValue();
        }
        if (choice instanceof Unsigned16) {
            return ((Unsigned16)choice).getVal();
        }
        return null;
    }

    private void setScalerAndMeter(EDL40Signature parsedSml, SmlListEntry smlEntry, long wh) throws SMLValidationException {
        parsedSml.setUnit(smlEntry.getUnit().getVal());
        parsedSml.setScaler(smlEntry.getScaler().getVal());
        parsedSml.setMeterPosition(wh);
    }

    private void showDebugInformation(SmlGetListRes getListRes) {
        LOGGER.debug("ServerID:\t" + String.valueOf(getListRes.getServerId()));
        LOGGER.debug("ListName:\t" + String.valueOf(getListRes.getListName()));
        LOGGER.debug("Signature:\t" + String.valueOf(getListRes.getListSignature()));
        SmlTime time = getListRes.getActSensorTime();
        LOGGER.debug("ActSensorTime:\t" + String.valueOf(time.getChoice()));
        for (SmlListEntry smlEntry : getListRes.getValList().getValListEntry()) {
            LOGGER.debug("------");
            LOGGER.debug("ObjName:\t" + String.valueOf(smlEntry.getObjName()));
            LOGGER.debug("Value:\t" + String.valueOf(smlEntry.getValue()));
            LOGGER.debug("Unit:\t" + String.valueOf(smlEntry.getUnit()));
            LOGGER.debug("Signature:\t" + String.valueOf(smlEntry.getValueSignature()));
            LOGGER.debug("Scaler:\t" + String.valueOf(smlEntry.getScaler()));
            LOGGER.debug("Status:\t" + String.valueOf(smlEntry.getStatus().getChoice()));
            if (smlEntry.getValTime() == null || !(smlEntry.getValTime().getChoice() instanceof SmlTimestampLocal)) continue;
            LOGGER.debug("Timestamp:\t" + String.valueOf(((SmlTimestampLocal)smlEntry.getValTime().getChoice()).getTimestamp()));
        }
    }

    private SMLSignature parseRawSMLBytes(byte[] payloadBytes) throws IOException, ValidationException {
        MessageExtractor messageExtractor = this.createMessageExtractor(payloadBytes);
        DataInputStream smlFileDis = this.convertMessageExtractorToSmlMessages(messageExtractor);
        ArrayList<SmlMessage> messages = new ArrayList<SmlMessage>();
        while (smlFileDis.available() > 0) {
            SmlMessage message = new SmlMessage();
            message.decode(smlFileDis);
            messages.add(message);
            Object obj = message.getMessageBody().getChoice();
            SMLSignature SMLSignature2 = this.parseASNObject((ASNObject)obj);
            if (SMLSignature2 == null) continue;
            return SMLSignature2;
        }
        return null;
    }

    private DataInputStream convertMessageExtractorToSmlMessages(MessageExtractor messageExtractor) throws IOException {
        byte[] smlFile = messageExtractor.getSmlMessage();
        ByteArrayInputStream bais = new ByteArrayInputStream(smlFile);
        return new DataInputStream(bais);
    }

    private MessageExtractor createMessageExtractor(byte[] payloadBytes) throws IOException {
        BufferedInputStream bis = new BufferedInputStream(new ByteArrayInputStream(payloadBytes));
        DataInputStream dis = new DataInputStream(bis);
        return new MessageExtractor(dis, 300L);
    }

    public SMLSignature parsePayloadData(byte[] smlData) throws ValidationException {
        try {
            SMLSignature smlSignature = this.parseRawSMLBytes(smlData);
            if (smlSignature == null) {
                throw new SMLValidationException("Could not read sml data incomplete data", "error.sml.incomplete");
            }
            smlSignature.isDataComplete();
            if (smlSignature.getUnit() != 30) {
                throw new SMLValidationException("Invalid unit present in sml data", "error.sml.invalid.unit");
            }
            return smlSignature;
        }
        catch (IOException e) {
            throw new SMLValidationException("Could not read sml data, invalid format", e);
        }
    }

    private static class BitTranslator {
        int b;
        private final int from;

        BitTranslator(int from) {
            this.from = from;
        }

        BitTranslator from(int bit, int otherBit) {
            this.set(bit, this.from & 1 << otherBit);
            return this;
        }

        BitTranslator set(int bit, int value) {
            if (value != 0) {
                this.b |= 1 << bit;
            }
            return this;
        }

        int get() {
            return this.b;
        }
    }
}

