/*
 * Decompiled with CFR 0.152.
 */
package de.safe_ev.transparenzsoftware.verification.format.sml.EDLMennekes;

import de.safe_ev.transparenzsoftware.Utils;
import de.safe_ev.transparenzsoftware.verification.ContainedPublicKeyParser;
import de.safe_ev.transparenzsoftware.verification.RegulationLawException;
import de.safe_ev.transparenzsoftware.verification.ValidationException;
import de.safe_ev.transparenzsoftware.verification.VerificationType;
import de.safe_ev.transparenzsoftware.verification.format.sml.EDLMennekes.EDLMennekesSignature;
import de.safe_ev.transparenzsoftware.verification.format.sml.EDLMennekes.EDLMennekesVerifiedData;
import de.safe_ev.transparenzsoftware.verification.format.sml.EDLMennekes.XMLReader;
import de.safe_ev.transparenzsoftware.verification.format.sml.EDLMennekes.embedded.ChargingProcess;
import de.safe_ev.transparenzsoftware.verification.format.sml.SMLVerificationParserBase;
import de.safe_ev.transparenzsoftware.verification.result.Error;
import de.safe_ev.transparenzsoftware.verification.result.IntrinsicVerified;
import de.safe_ev.transparenzsoftware.verification.result.VerificationResult;
import de.safe_ev.transparenzsoftware.verification.xml.VerifiedData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EDLMennekesVerificationParser
extends SMLVerificationParserBase
implements ContainedPublicKeyParser {
    private static final Logger LOGGER = LogManager.getLogger(EDLMennekesVerificationParser.class);
    private final XMLReader xmlReader = new XMLReader();

    @Override
    public VerificationResult parseAndVerify(String data, byte[] publicKey, IntrinsicVerified intrinsicVerified) {
        VerificationResult verificationResult;
        LOGGER.info("Starting...");
        try {
            ChargingProcess chargingProcess = this.xmlReader.readChargingProcessFromString(data, true);
            EDLMennekesSignature mennekesSignatureStart = new EDLMennekesSignature(chargingProcess, EDLMennekesSignature.ReadingType.MEASUREMENT_START);
            EDLMennekesSignature mennekesSignatureEnd = new EDLMennekesSignature(chargingProcess, EDLMennekesSignature.ReadingType.MEASUREMENT_END);
            EDLMennekesVerifiedData verifiedData = new EDLMennekesVerifiedData(chargingProcess, mennekesSignatureStart, mennekesSignatureEnd);
            if (!intrinsicVerified.ok()) {
                if (!this.verifier.verify(publicKey, mennekesSignatureStart)) {
                    return new VerificationResult((VerifiedData)verifiedData, Error.withVerificationFailed());
                }
                if (!this.verifier.verify(publicKey, mennekesSignatureEnd)) {
                    return new VerificationResult((VerifiedData)verifiedData, Error.withVerificationFailed());
                }
            }
            verificationResult = new VerificationResult(verifiedData, true, intrinsicVerified);
            try {
                verifiedData.checkLawIntegrityForTransaction();
            }
            catch (RegulationLawException e) {
                verificationResult.addError(Error.withRegulationLawException(e));
            }
        }
        catch (ValidationException e) {
            verificationResult = new VerificationResult(Error.withValidationException(e));
        }
        return verificationResult;
    }

    @Override
    public VerificationType getVerificationType() {
        return VerificationType.EDL_40_MENNEKES;
    }

    @Override
    public boolean canParseData(String data) {
        try {
            ChargingProcess chargingProcess = this.xmlReader.readChargingProcessFromString(data, false);
            if (chargingProcess == null || chargingProcess.getPublicKey() == null) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        LOGGER.info("Match for " + String.valueOf((Object)VerificationType.EDL_40_MENNEKES) + " detected");
        return true;
    }

    @Override
    public String parsePublicKey(String data) {
        try {
            ChargingProcess chargingProcess = this.xmlReader.readChargingProcessFromString(data, true);
            return Utils.clearString(chargingProcess.getPublicKey());
        }
        catch (ValidationException e) {
            return null;
        }
    }

    @Override
    public String createFormattedKey(String data) {
        String publicKey = this.parsePublicKey(data);
        if (publicKey == null) {
            return null;
        }
        return Utils.splitStringToGroups(publicKey, 4);
    }

    @Override
    public Class getVerfiedDataClass() {
        return EDLMennekesVerifiedData.class;
    }
}

