/*
 * Decompiled with CFR 0.152.
 */
package de.safe_ev.transparenzsoftware.verification.format.sml.EDLMennekes;

import de.safe_ev.transparenzsoftware.verification.ValidationException;
import de.safe_ev.transparenzsoftware.verification.format.sml.EDLMennekes.embedded.Billing;
import de.safe_ev.transparenzsoftware.verification.format.sml.EDLMennekes.embedded.ChargingProcess;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Unmarshaller;
import java.io.StringReader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class XMLReader {
    private static final Logger LOGGER = LogManager.getLogger(XMLReader.class);
    private Unmarshaller unmarshaller;

    public XMLReader() {
        JAXBContext jc = null;
        try {
            jc = JAXBContext.newInstance(Billing.class, ChargingProcess.class);
            this.unmarshaller = jc.createUnmarshaller();
        }
        catch (JAXBException e) {
            this.unmarshaller = null;
            LOGGER.error("Error on creating unmarshaller", (Throwable)e);
        }
    }

    public Billing readFromString(String xml) throws ValidationException {
        StringReader reader = new StringReader(this.enforceXMLStartingString(xml));
        try {
            return (Billing)this.unmarshaller.unmarshal(reader);
        }
        catch (JAXBException e) {
            LOGGER.error("JAXB error on loading mennekes file", (Throwable)e);
            throw new ValidationException("Could not read mennekes xml data");
        }
    }

    public ChargingProcess readChargingProcessFromString(String xml, boolean verbose) throws ValidationException {
        String enforcedNamespace = this.enforceXMLStartingString(xml);
        if (!enforcedNamespace.contains("http://www.mennekes.de/Mennekes.EdlVerification.xsd")) {
            String replacement = String.format("<ChargingProcess xmlns=\"%s\"", "http://www.mennekes.de/Mennekes.EdlVerification.xsd");
            enforcedNamespace = enforcedNamespace.replace("<ChargingProcess", replacement);
        }
        StringReader reader = new StringReader(enforcedNamespace);
        try {
            return (ChargingProcess)this.unmarshaller.unmarshal(reader);
        }
        catch (JAXBException e) {
            if (verbose) {
                LOGGER.debug("JAXB error on loading mennekes file", (Throwable)e);
            }
            throw new ValidationException("Could not read mennekes xml data");
        }
        catch (ClassCastException e) {
            if (verbose) {
                LOGGER.debug("Class cast error in loading mennekes file", (Throwable)e);
            }
            throw new ValidationException("Could not read mennekes xml data");
        }
    }

    private String enforceXMLStartingString(String xml) {
        if (!((String)xml).trim().startsWith("<?xml")) {
            xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + (String)xml;
        }
        return xml;
    }
}

