/*
 * Decompiled with CFR 0.152.
 */
package de.safe_ev.transparenzsoftware.verification.format.sml.IsaEDL40;

import de.safe_ev.transparenzsoftware.Utils;
import de.safe_ev.transparenzsoftware.verification.format.sml.SMLSignature;
import de.safe_ev.transparenzsoftware.verification.format.sml.SMLValidationException;
import java.nio.ByteBuffer;
import java.time.OffsetDateTime;

public class IsaEDL40Signature
extends SMLSignature {
    public static final int SERVER_ID_OFFSET = 0;
    public static final int SERVER_ID_LENGTH = 10;
    public static final int TIMESTAMP_OFFSET = 10;
    public static final int TIMESTAMP_LENGTH = 4;
    public static final int ACTUAL_EC_LSB_SW_OFFSET = 14;
    public static final int ACTUAL_EC_OBISID_OFFSET = 15;
    public static final int ACTUAL_EC_OBISID_LENGTH = 6;
    public static final int ACTUAL_EC_UNIT_OFFSET = 21;
    public static final int ACTUAL_EC_SCALER_OFFSET = 22;
    public static final int METER_VALUE_OFFSET = 23;
    public static final int METER_VALUE_OFFSET_LENGTH = 8;
    public static final int LOG_ENTRY_INDEX_OFFSET = 31;
    public static final int LOG_ENTRY_INDEX_LENGTH = 2;
    public static final int ACTUAL_EC_SIGNATURE_OFFSET = 33;
    public static final int ACTUAL_EC_SIGNATURE_LENGTH = 66;
    public static final int CONTRACT_ID_OFFSET = 99;
    public static final int CONTRACT_ID_LENGTH = 128;
    public static final int START_EC_TIMESTAMP_OFFSET = 227;
    public static final int START_EC_TIMESTAMP_LENGTH = 4;
    public static final int ESTH_OFFSET = 231;
    public static final int ESTH_LENGTH = 20;
    public static final int START_EC_LSB_SW_OFFSET = 251;
    public static final int START_EC_OBISID_OFFSET = 252;
    public static final int START_EC_OBISID_LENGTH = 6;
    public static final int START_EC_UNIT_OFFSET = 258;
    public static final int START_EC_SCALER_OFFSET = 259;
    public static final int START_EC_VALUE_OFFSET = 260;
    public static final int START_EC_VALUE_LENGTH = 8;
    public static final int LIST_NAME_OFFSET = 268;
    public static final int LIST_NAME_LENGTH = 6;
    public static final int PAGINATION_OFFSET = 274;
    public static final int PAGINATION_LENGTH = 4;
    public static final int RESERVED_OFFSET = 278;
    public static final int RESERVED_LENGTH = 42;
    private byte[] embeddedSignature;
    private byte[] dataSinature;
    private byte[] serverId;
    private OffsetDateTime actualEcTimestamp;
    private byte[] actualEcStatus;
    private byte[] actualEcObisId;
    private byte actualEcUnit;
    private byte actualEcScaler;
    private byte[] actualEcValue;
    private byte[] logEntryIndex;
    private byte[] actualEcSignature;
    private byte[] contractId;
    private OffsetDateTime startEcTimeStamp;
    private byte[] esth;
    private byte[] startEcStatus;
    private byte[] startEcObisId;
    private byte startEcUnit;
    private byte startEcScaler;
    private byte[] startEcValue;
    private byte[] listNameOfRes;
    private byte[] pagination;
    private byte[] reserved = new byte[42];

    public IsaEDL40Signature() {
        for (int i = 0; i < 42; ++i) {
            this.reserved[i] = 0;
        }
    }

    @Override
    public void setServerId(byte[] serverId) throws SMLValidationException {
        if (serverId.length != 10) {
            throw new SMLValidationException("Server Id was not 10 bytes long");
        }
        this.serverId = serverId;
    }

    @Override
    public byte[] getServerId() {
        return this.serverId;
    }

    public void setDataSignature(byte[] signature) {
        this.dataSinature = signature;
    }

    public byte[] getDataSignature() {
        return this.dataSinature;
    }

    public void setActualEcTimestamp(OffsetDateTime timestamp) throws SMLValidationException {
        this.actualEcTimestamp = timestamp;
    }

    public byte[] getActualEcTimestamp() {
        return IsaEDL40Signature.timeToBytes(this.actualEcTimestamp);
    }

    public void setActualEcStatus(byte[] status) {
        this.actualEcStatus = status;
    }

    public byte[] getActualEcStatus() {
        return this.actualEcStatus;
    }

    @Override
    public byte getUnit() {
        return this.actualEcUnit;
    }

    public byte getActualEcUnit() {
        return this.actualEcUnit;
    }

    public void setActualEcUnit(byte unit) {
        this.actualEcUnit = unit;
    }

    public void setActualEcUnit(int unit) {
        this.actualEcUnit = (byte)(unit & 0xFF);
    }

    public void setActualEcScaler(byte scaler) {
        this.actualEcScaler = scaler;
    }

    public byte getActualEcScaler() {
        return this.actualEcScaler;
    }

    public void setActualEcObisId(byte[] obis) {
        this.actualEcObisId = obis;
    }

    public byte[] getActualEcObisId() {
        return this.actualEcObisId;
    }

    public void setActualEcValue(long ecValue) {
        this.actualEcValue = IsaEDL40Signature.longToBytes(ecValue);
    }

    public void setActualEcValue(byte[] ecValue) {
        this.actualEcValue = ecValue;
    }

    public byte[] getActualEcValue() {
        return this.actualEcValue;
    }

    public void setActualEcSignature(byte[] ecSignature) {
        this.actualEcSignature = ecSignature;
    }

    public byte[] getActualEcSignature() {
        return this.actualEcSignature;
    }

    @Override
    public byte[] getProvidedSignature() {
        return this.actualEcSignature;
    }

    @Override
    public byte[] getContractId() {
        return this.contractId;
    }

    @Override
    public void setContractId(byte[] contractId) throws SMLValidationException {
        this.setContractId(contractId, false);
    }

    @Override
    public void setContractId(byte[] contractId, boolean fillUp) throws SMLValidationException {
        if (contractId.length < 128 && fillUp) {
            byte[] fillUpData = new byte[128];
            System.arraycopy(contractId, 0, fillUpData, 0, contractId.length);
            this.contractId = fillUpData;
        } else {
            if (fillUp && contractId.length > 128 || contractId.length != 128) {
                throw new SMLValidationException("base signature not 128 bytes long");
            }
            this.contractId = contractId;
        }
    }

    @Override
    public byte[] getTimestampContractId() {
        return IsaEDL40Signature.timeToBytes(this.startEcTimeStamp);
    }

    @Override
    public OffsetDateTime getTimestampContractIdAsDate() {
        return this.startEcTimeStamp;
    }

    public void setTimestampContractId(OffsetDateTime timestampCustomerId) throws SMLValidationException {
        this.startEcTimeStamp = timestampCustomerId;
    }

    public void setStartEcTimestamp(OffsetDateTime timestamp) throws SMLValidationException {
        this.startEcTimeStamp = timestamp;
    }

    public byte[] getStartEcTimestamp() {
        return IsaEDL40Signature.timeToBytes(this.startEcTimeStamp);
    }

    public void setStartEcStatus(byte[] status) {
        this.startEcStatus = status;
    }

    public byte[] getStartEcStatus() {
        return this.startEcStatus;
    }

    public void setStartEcObisId(byte[] obis) {
        this.startEcObisId = obis;
    }

    public byte[] getStartEcObisId() {
        return this.startEcObisId;
    }

    public byte getStartEcUnit() {
        return this.startEcUnit;
    }

    public void setStartEcUnit(byte unit) {
        this.startEcUnit = unit;
    }

    public void setStartEcUnit(int unit) {
        this.startEcUnit = (byte)(unit & 0xFF);
    }

    public void setStartlEcScaler(byte scaler) {
        this.startEcScaler = scaler;
    }

    public byte getStartEcScaler() {
        return this.startEcScaler;
    }

    public void setStartEcValue(long ecValue) {
        this.startEcValue = IsaEDL40Signature.longToBytes(ecValue);
    }

    public void setStartEcValue(byte[] ecValue) {
        this.startEcValue = ecValue;
    }

    public byte[] getStartEcValue() {
        return this.startEcValue;
    }

    public long getStartEcValueAsLong() {
        return Utils.bytesToLong(Utils.reverseByteOrder(this.startEcValue));
    }

    public byte[] getEsth() {
        return this.esth;
    }

    public void setEsth(byte[] esth) {
        this.esth = esth;
    }

    @Override
    public byte[] getPagination() {
        return this.pagination;
    }

    @Override
    public void setPagination(int pagination) throws SMLValidationException {
        this.setPagination(Utils.reverseByteOrder(IsaEDL40Signature.intToBytes(pagination)));
    }

    @Override
    public void setPagination(byte[] pagination) throws SMLValidationException {
        if (pagination.length != 4) {
            throw new SMLValidationException("Pagination index was not 4 bytes long");
        }
        this.pagination = pagination;
    }

    @Override
    public byte[] getBytesLog() {
        return this.logEntryIndex;
    }

    @Override
    public void setBytesLog(byte[] bytesLog) throws SMLValidationException {
        if (bytesLog.length != 2) {
            throw new SMLValidationException("Logbook bytes not 2 bytes long");
        }
        this.logEntryIndex = bytesLog;
    }

    @Override
    public void setBytesLog(byte lowByte, byte highByte) {
        this.logEntryIndex = new byte[]{lowByte, highByte};
    }

    public void setListNameOfRes(byte[] listName) {
        this.listNameOfRes = listName;
    }

    public byte[] getListNameOfRes() {
        return this.listNameOfRes;
    }

    @Override
    public byte[] getTimestamp() {
        if (this.actualEcTimestamp == null) {
            return null;
        }
        return IsaEDL40Signature.timeToBytes(this.actualEcTimestamp);
    }

    @Override
    public OffsetDateTime getTimestampAsDate() {
        return this.actualEcTimestamp;
    }

    public void setLogEntryIndex(byte[] index) {
        this.logEntryIndex = index;
    }

    @Override
    public byte[] buildExtendedSignatureData() {
        byte[] signature = new byte[320];
        System.arraycopy(this.serverId, 0, signature, 0, 10);
        System.arraycopy(this.getActualEcTimestamp(), 0, signature, 10, 4);
        signature[14] = this.getActualEcStatus()[7];
        System.arraycopy(this.actualEcObisId, 0, signature, 15, 6);
        signature[21] = this.actualEcUnit;
        signature[22] = (byte)(this.actualEcScaler & 0xFF);
        System.arraycopy(Utils.reverseByteOrder(this.actualEcValue), 0, signature, 23, 8);
        System.arraycopy(this.logEntryIndex, 0, signature, 31, 2);
        System.arraycopy(this.actualEcSignature, 0, signature, 33, 66);
        System.arraycopy(this.contractId, 0, signature, 99, 128);
        System.arraycopy(this.getStartEcTimestamp(), 0, signature, 227, 4);
        System.arraycopy(this.esth, 0, signature, 231, 20);
        signature[251] = this.getStartEcStatus()[7];
        System.arraycopy(this.startEcObisId, 0, signature, 252, 6);
        signature[258] = this.startEcUnit;
        signature[259] = this.startEcScaler;
        System.arraycopy(Utils.reverseByteOrder(this.startEcValue), 0, signature, 260, 8);
        System.arraycopy(this.listNameOfRes, 0, signature, 268, 6);
        System.arraycopy(this.pagination, 0, signature, 274, 4);
        System.arraycopy(this.reserved, 0, signature, 278, 42);
        return signature;
    }

    @Override
    public boolean isDataComplete() throws SMLValidationException {
        if (this.getServerId() == null) {
            throw new SMLValidationException("SML field server id missing", "error.sml.missing.serverid");
        }
        if (this.getTimestamp() == null) {
            throw new SMLValidationException("SML field timestamp missing", "error.sml.missing.timestamp");
        }
        if (this.getPagination() == null) {
            throw new SMLValidationException("SML field pagination missing", "error.sml.missing.pagination");
        }
        if (this.getBytesLog() == null) {
            // empty if block
        }
        if (this.getContractId() == null) {
            // empty if block
        }
        return true;
    }

    private static byte[] longToBytes(long meterPosition) {
        return ByteBuffer.allocate(8).putLong(meterPosition).array();
    }
}

