/*
 * Decompiled with CFR 0.152.
 */
package de.safe_ev.transparenzsoftware.verification.format.sml.IsaEDL40;

import de.safe_ev.transparenzsoftware.Utils;
import de.safe_ev.transparenzsoftware.verification.ValidationException;
import de.safe_ev.transparenzsoftware.verification.format.sml.IsaEDL40.IsaEDL40Signature;
import de.safe_ev.transparenzsoftware.verification.format.sml.SMLConfig;
import de.safe_ev.transparenzsoftware.verification.format.sml.SMLSignature;
import de.safe_ev.transparenzsoftware.verification.format.sml.SMLUtils;
import de.safe_ev.transparenzsoftware.verification.format.sml.SMLValidationException;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openmuc.jsml.structures.ASNObject;
import org.openmuc.jsml.structures.Integer64;
import org.openmuc.jsml.structures.OctetString;
import org.openmuc.jsml.structures.SmlListEntry;
import org.openmuc.jsml.structures.SmlMessage;
import org.openmuc.jsml.structures.SmlTime;
import org.openmuc.jsml.structures.SmlTimestamp;
import org.openmuc.jsml.structures.SmlTimestampLocal;
import org.openmuc.jsml.structures.Unsigned32;
import org.openmuc.jsml.structures.Unsigned64;
import org.openmuc.jsml.structures.responses.SmlGetListRes;
import org.openmuc.jsml.structures.responses.SmlPublicCloseRes;
import org.openmuc.jsml.structures.responses.SmlPublicOpenRes;
import org.openmuc.jsml.transport.MessageExtractor;

public class IsaSMLReader {
    private static final Logger LOGGER = LogManager.getLogger(IsaSMLReader.class);
    private static final String TYPE_CONTRACT_ID = "81 82 81 54 01 FF";
    private static final String TYPE_START_EC_VALUE = "01 00 01 08 00 80";
    private static final String TYPE_PAGINATION = "81 80 C7 F0 40 FF";
    private static final String TYPE_ACTUAL_EC_VALUE = "01 00 01 08 00 FF";
    private static final String TYPE_ESTH = "81 80 81 61 01 FF";
    private static final String TYPE_MANUFACTURER_SPECIFIC = "81 80 81 61 01 FF";
    private static final String TYPE_SECONDS_INDEX = "81 00 60 08 00 01";

    private SMLSignature parseASNObject(ASNObject asnObject) throws ValidationException {
        IsaEDL40Signature parsedSml = null;
        if (asnObject instanceof SmlPublicOpenRes) {
            SmlPublicOpenRes openRes = (SmlPublicOpenRes)asnObject;
            if (SMLConfig.DEBUG_SML_MESSAGES) {
                LOGGER.debug("Found SmlPublicOpenRes message");
            }
        } else if (asnObject instanceof SmlGetListRes) {
            if (SMLConfig.DEBUG_SML_MESSAGES) {
                LOGGER.debug("Found SmlGetListRes message");
            }
            parsedSml = new IsaEDL40Signature();
            SmlGetListRes getListRes = (SmlGetListRes)asnObject;
            if (SMLConfig.DEBUG_SML_MESSAGES) {
                this.showDebugInformation(getListRes);
            }
            parsedSml.setServerId(getListRes.getServerId().getValue());
            parsedSml.setListNameOfRes(getListRes.getListName().getValue());
            byte[] originalSignature = getListRes.getListSignature().getValue();
            parsedSml.setBytesLog(originalSignature[originalSignature.length - 2], originalSignature[originalSignature.length - 1]);
            byte[] croppedSignature = Arrays.copyOfRange(originalSignature, 0, originalSignature.length - 2);
            parsedSml.setDataSignature(croppedSignature);
            block14: for (SmlListEntry smlEntry : getListRes.getValList().getValListEntry()) {
                LOGGER.debug("verify smlEntry " + String.valueOf(smlEntry.getObjName()));
                if (smlEntry.getObjName() == null) {
                    LOGGER.warn("Entry without an asnObject name found");
                    continue;
                }
                switch (smlEntry.getObjName().toHexString()) {
                    case "81 82 81 54 01 FF": {
                        if (!(smlEntry.getValue().getChoice() instanceof OctetString)) continue block14;
                        OctetString contractId = (OctetString)smlEntry.getValue().getChoice();
                        parsedSml.setContractId(contractId.getValue(), true);
                        continue block14;
                    }
                    case "01 00 01 08 00 80": {
                        ASNObject strtStatus;
                        if (smlEntry.getValTime().getChoice() instanceof SmlTimestampLocal) {
                            parsedSml.setStartEcTimestamp(SMLUtils.parseSmlTimestamp((SmlTimestampLocal)smlEntry.getValTime().getChoice()));
                        }
                        if (smlEntry.getValTime().getChoice() instanceof SmlTimestamp) {
                            parsedSml.setStartEcTimestamp(SMLUtils.parseSmlTimestamp((SmlTimestamp)smlEntry.getValTime().getChoice()));
                        }
                        if ((strtStatus = smlEntry.getStatus().getChoice()) instanceof Unsigned64) {
                            byte[] sArr = Utils.longToByteArray(((Unsigned64)strtStatus).getVal());
                            parsedSml.setStartEcStatus(sArr);
                        }
                        parsedSml.setStartEcObisId(smlEntry.getObjName().getValue());
                        parsedSml.setStartEcUnit(smlEntry.getUnit().getVal());
                        parsedSml.setStartlEcScaler(smlEntry.getScaler().getVal());
                        Integer64 sEcWh = (Integer64)smlEntry.getValue().getChoice();
                        parsedSml.setStartEcValue(sEcWh.getVal());
                        continue block14;
                    }
                    case "01 00 01 08 00 FF": {
                        ASNObject actStatus;
                        OctetString objName2 = smlEntry.getObjName();
                        byte[] data = smlEntry.getObjName().getValue();
                        parsedSml.setActualEcObisId(smlEntry.getObjName().getValue());
                        if (smlEntry.getValTime().getChoice() instanceof SmlTimestamp) {
                            parsedSml.setActualEcTimestamp(SMLUtils.parseSmlTimestamp((SmlTimestamp)smlEntry.getValTime().getChoice()));
                        }
                        if ((actStatus = smlEntry.getStatus().getChoice()) instanceof Unsigned64) {
                            byte[] sArr = Utils.longToByteArray(((Unsigned64)actStatus).getVal());
                            parsedSml.setActualEcStatus(sArr);
                        }
                        parsedSml.setActualEcUnit(smlEntry.getUnit().getVal());
                        parsedSml.setActualEcScaler(smlEntry.getScaler().getVal());
                        Integer64 wh2 = (Integer64)smlEntry.getValue().getChoice();
                        parsedSml.setActualEcValue(wh2.getVal());
                        parsedSml.setActualEcSignature(smlEntry.getValueSignature().getValue());
                        continue block14;
                    }
                    case "81 80 C7 F0 40 FF": {
                        OctetString objName3 = smlEntry.getObjName();
                        if (smlEntry.getValue().getChoice() instanceof Unsigned32) {
                            Unsigned32 paginationData = (Unsigned32)smlEntry.getValue().getChoice();
                            parsedSml.setPagination(paginationData.getVal());
                            continue block14;
                        }
                        throw new SMLValidationException("pagination data does not contain a unsigned integer");
                    }
                    case "81 80 81 61 01 FF": {
                        if (!(smlEntry.getValue().getChoice() instanceof OctetString)) continue block14;
                        OctetString esth = (OctetString)smlEntry.getValue().getChoice();
                        parsedSml.setEsth(esth.getValue());
                        continue block14;
                    }
                    default: {
                        LOGGER.warn("Unknown element " + smlEntry.getObjName().toHexString());
                    }
                }
            }
        } else if (asnObject instanceof SmlPublicCloseRes) {
            SmlPublicCloseRes closeRes = (SmlPublicCloseRes)asnObject;
            if (SMLConfig.DEBUG_SML_MESSAGES) {
                LOGGER.debug("Found SmlPublicCloseRes message");
            }
        } else {
            LOGGER.warn("Unknown sml object found: " + asnObject.getClass().getSimpleName());
        }
        return parsedSml;
    }

    private void showDebugInformation(SmlGetListRes getListRes) {
        LOGGER.debug("ServerID:\t" + String.valueOf(getListRes.getServerId()));
        LOGGER.debug("ListName:\t" + String.valueOf(getListRes.getListName()));
        LOGGER.debug("Signature:\t" + String.valueOf(getListRes.getListSignature()));
        SmlTime time = getListRes.getActSensorTime();
        LOGGER.debug("ActSensorTime:\t" + String.valueOf(time.getChoice()));
        for (SmlListEntry smlEntry : getListRes.getValList().getValListEntry()) {
            LOGGER.debug("------");
            LOGGER.debug("ObjName:\t" + String.valueOf(smlEntry.getObjName()));
            LOGGER.debug("Value:\t" + String.valueOf(smlEntry.getValue()));
            LOGGER.debug("Unit:\t" + String.valueOf(smlEntry.getUnit()));
            LOGGER.debug("Signature:\t" + String.valueOf(smlEntry.getValueSignature()));
            LOGGER.debug("Scaler:\t" + String.valueOf(smlEntry.getScaler()));
            LOGGER.debug("Status:\t" + String.valueOf(smlEntry.getStatus().getChoice()));
            if (smlEntry.getValTime() == null || !(smlEntry.getValTime().getChoice() instanceof SmlTimestampLocal)) continue;
            LOGGER.debug("Timestamp:\t" + String.valueOf(((SmlTimestampLocal)smlEntry.getValTime().getChoice()).getTimestamp()));
        }
    }

    private SMLSignature parseRawSMLBytes(byte[] payloadBytes) throws IOException, ValidationException {
        MessageExtractor messageExtractor = this.createMessageExtractor(payloadBytes);
        DataInputStream smlFileDis = this.convertMessageExtractorToSmlMessages(messageExtractor);
        ArrayList<SmlMessage> messages = new ArrayList<SmlMessage>();
        while (smlFileDis.available() > 0) {
            SmlMessage message = new SmlMessage();
            message.decode(smlFileDis);
            messages.add(message);
            Object obj = message.getMessageBody().getChoice();
            SMLSignature SMLSignature2 = this.parseASNObject((ASNObject)obj);
            if (SMLSignature2 == null) continue;
            return SMLSignature2;
        }
        return null;
    }

    private DataInputStream convertMessageExtractorToSmlMessages(MessageExtractor messageExtractor) throws IOException {
        byte[] smlFile = messageExtractor.getSmlMessage();
        ByteArrayInputStream bais = new ByteArrayInputStream(smlFile);
        return new DataInputStream(bais);
    }

    private MessageExtractor createMessageExtractor(byte[] payloadBytes) throws IOException {
        BufferedInputStream bis = new BufferedInputStream(new ByteArrayInputStream(payloadBytes));
        DataInputStream dis = new DataInputStream(bis);
        return new MessageExtractor(dis, 300L);
    }

    public SMLSignature parsePayloadData(byte[] smlData) throws ValidationException {
        try {
            SMLSignature smlSignature = this.parseRawSMLBytes(smlData);
            if (smlSignature == null) {
                throw new SMLValidationException("Could not read sml data incomplete data", "error.sml.incomplete");
            }
            smlSignature.isDataComplete();
            if (smlSignature.getUnit() != 30) {
                throw new SMLValidationException("Invalid unit present in sml data", "error.sml.invalid.unit");
            }
            return smlSignature;
        }
        catch (IOException e) {
            throw new SMLValidationException("Could not read sml data, invalid format", e);
        }
    }
}

