/*
 * Decompiled with CFR 0.152.
 */
package de.safe_ev.transparenzsoftware.verification.format.sml.IsaEDL40;

import de.safe_ev.transparenzsoftware.Utils;
import de.safe_ev.transparenzsoftware.verification.ValidationException;
import de.safe_ev.transparenzsoftware.verification.VerificationLogger;
import de.safe_ev.transparenzsoftware.verification.format.sml.IsaEDL40.IsaEDL40Signature;
import de.safe_ev.transparenzsoftware.verification.format.sml.SMLSignature;
import de.safe_ev.transparenzsoftware.verification.format.sml.SMLSignatureVerifier;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Security;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.Arrays;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class IsaSMLSignatureVerifier
extends SMLSignatureVerifier {
    private static final Logger LOGGER = LogManager.getLogger(IsaSMLSignatureVerifier.class);

    public IsaSMLSignatureVerifier() {
        Security.addProvider(new BouncyCastleProvider());
        this.PUBLIC_KEY_BYTES_LENGTH = 64;
        this.KEY_POINT_DATA_LENGTH = 32;
        this.ELLIPTIC_CURVE_ALGORITHM = "secp256r1";
        this.CROPPED_DATA_LENGTH = 32;
    }

    @Override
    public boolean verify(byte[] publicKey, byte[] signature, byte[] hashData) throws ValidationException {
        boolean verify;
        byte[] r = Arrays.copyOfRange(signature, 0, signature.length / 2);
        byte[] s2 = Arrays.copyOfRange(signature, signature.length / 2, signature.length);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ASN1OutputStream derOutputStream = ASN1OutputStream.create(byteArrayOutputStream, "DER");
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(new ASN1Integer(new BigInteger(this.PLUS_SIGN, r)));
        v.add(new ASN1Integer(new BigInteger(this.PLUS_SIGN, s2)));
        try {
            derOutputStream.writeObject(new DERSequence(v));
        }
        catch (IOException e) {
            throw new RuntimeException("Could not create DER sequence");
        }
        byte[] derSignature = byteArrayOutputStream.toByteArray();
        try {
            Signature signatureVerifier = this.initSignature(publicKey, hashData);
            verify = signatureVerifier.verify(derSignature);
            VerificationLogger.log("IsaSML", this.ELLIPTIC_CURVE_ALGORITHM, publicKey, hashData, derSignature, verify);
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException e) {
            throw new ValidationException("Failure on initialising the crypto algorithms", e);
        }
        catch (SignatureException e) {
            throw new ValidationException("Invalid signature supplied", e);
        }
        catch (InvalidKeyException e) {
            throw new ValidationException("Invalid public key supplied", e);
        }
        return verify;
    }

    @Override
    public boolean verify(byte[] publicKey, SMLSignature SMLSignature2) throws ValidationException {
        byte[] dataForHash = SMLSignature2.buildExtendedSignatureData();
        byte[] hashData = Utils.hashSHA256(dataForHash);
        byte[] signature = ((IsaEDL40Signature)SMLSignature2).getDataSignature();
        boolean verify = this.verify(publicKey, signature, hashData);
        return verify;
    }

    private Signature initSignature(byte[] publicKey, byte[] croppedPayloadData) throws NoSuchProviderException, NoSuchAlgorithmException, ValidationException, SignatureException, InvalidKeyException {
        assert (croppedPayloadData.length == this.CROPPED_DATA_LENGTH);
        Signature signatureVerifier = Signature.getInstance(this.SIGNATURE_ALGORITHM, "BC");
        signatureVerifier.initVerify(this.getPublicKeyFromBytes(publicKey));
        signatureVerifier.update(croppedPayloadData);
        return signatureVerifier;
    }

    private BigInteger getPointXKeyCurve(byte[] pubKey) {
        assert (pubKey.length == this.PUBLIC_KEY_BYTES_LENGTH);
        byte[] x = new byte[this.KEY_POINT_DATA_LENGTH];
        System.arraycopy(pubKey, 0, x, 0, this.KEY_POINT_DATA_LENGTH);
        return new BigInteger(this.PLUS_SIGN, x);
    }

    private BigInteger getPointYKeyCurve(byte[] pubKey) {
        assert (pubKey.length == this.PUBLIC_KEY_BYTES_LENGTH);
        byte[] y = new byte[this.KEY_POINT_DATA_LENGTH];
        System.arraycopy(pubKey, this.KEY_POINT_DATA_LENGTH, y, 0, this.KEY_POINT_DATA_LENGTH);
        return new BigInteger(this.PLUS_SIGN, y);
    }

    private ECPublicKeySpec initPublicKeyCryptoSpecs(byte[] pubKey) throws NoSuchProviderException, NoSuchAlgorithmException, InvalidParameterSpecException {
        assert (pubKey.length == this.PUBLIC_KEY_BYTES_LENGTH);
        AlgorithmParameters parameters = AlgorithmParameters.getInstance(this.KEY_ALGORITHM, "BC");
        parameters.init(new ECGenParameterSpec(this.ELLIPTIC_CURVE_ALGORITHM));
        ECParameterSpec ecParameterSpec = parameters.getParameterSpec(ECParameterSpec.class);
        ECPoint point = new ECPoint(this.getPointXKeyCurve(pubKey), this.getPointYKeyCurve(pubKey));
        return new ECPublicKeySpec(point, ecParameterSpec);
    }
}

