/*
 * Decompiled with CFR 0.152.
 */
package de.safe_ev.transparenzsoftware.verification.format.sml;

import de.safe_ev.transparenzsoftware.Utils;
import de.safe_ev.transparenzsoftware.verification.ValidationException;
import de.safe_ev.transparenzsoftware.verification.VerificationLogger;
import de.safe_ev.transparenzsoftware.verification.format.sml.SMLSignature;
import de.safe_ev.transparenzsoftware.verification.format.sml.Verifier;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import java.util.Arrays;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Hex;

public class SMLSignatureVerifier
implements Verifier {
    private static final Logger LOGGER = LogManager.getLogger(SMLSignatureVerifier.class);
    protected int PLUS_SIGN = 1;
    protected String SIGNATURE_ALGORITHM = "NonewithECDSA";
    protected int CROPPED_DATA_LENGTH = 24;
    protected String ELLIPTIC_CURVE_ALGORITHM = "secp192r1";
    protected String KEY_ALGORITHM = "EC";
    protected int KEY_POINT_DATA_LENGTH = 24;
    protected int PUBLIC_KEY_BYTES_LENGTH = 48;
    protected int CROPPED_HASH_LEN = 24;

    public SMLSignatureVerifier() {
        Security.addProvider(new BouncyCastleProvider());
    }

    @Override
    public boolean verify(byte[] publicKey, byte[] signature, byte[] payloadData) throws ValidationException {
        payloadData = Arrays.copyOfRange(payloadData, 0, this.CROPPED_DATA_LENGTH);
        byte[] derSignature = this.signatureToDER(signature);
        try {
            PublicKey parsed = this.getPublicKeyFromBytes(publicKey);
            Signature signatureVerifier = this.initSignature(parsed, payloadData);
            boolean result = signatureVerifier.verify(derSignature);
            VerificationLogger.log("SML", this.ELLIPTIC_CURVE_ALGORITHM, publicKey, payloadData, signature, result);
            return result;
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException e) {
            throw new ValidationException("Failure on initialising the crypto algorithms", e);
        }
        catch (SignatureException e) {
            VerificationLogger.log("SML", this.ELLIPTIC_CURVE_ALGORITHM, publicKey, payloadData, signature, false);
            throw new ValidationException("Invalid signature supplied", e);
        }
        catch (InvalidKeyException e) {
            throw new ValidationException("Invalid public key supplied", e);
        }
    }

    private Signature initSignature(PublicKey publicKey, byte[] croppedPayloadData) throws NoSuchProviderException, NoSuchAlgorithmException, ValidationException, SignatureException, InvalidKeyException {
        assert (croppedPayloadData.length == this.CROPPED_DATA_LENGTH);
        Signature signatureVerifier = Signature.getInstance(this.SIGNATURE_ALGORITHM, "BC");
        signatureVerifier.initVerify(publicKey);
        signatureVerifier.update(croppedPayloadData);
        return signatureVerifier;
    }

    public boolean verify(byte[] publicKeyBytes, SMLSignature signatureSML) throws ValidationException {
        int cutoff;
        byte[] providedData = signatureSML.buildExtendedSignatureData();
        LOGGER.info("Provided:    " + Hex.toHexString(providedData));
        byte[] hashedData = Utils.hashSHA256(providedData);
        byte[] hashedDataCropped = Arrays.copyOfRange(hashedData, 0, this.CROPPED_HASH_LEN);
        byte[] signatureData = signatureSML.getProvidedSignature();
        int n = cutoff = signatureSML.getVersion() == 4 ? 2 : 0;
        if (signatureData.length == 50) {
            cutoff = 2;
        }
        byte[] signatureCropped = Arrays.copyOfRange(signatureData, 0, signatureData.length - cutoff);
        return this.verify(publicKeyBytes, signatureCropped, hashedDataCropped);
    }

    public byte[] signatureToDER(byte[] signature) {
        byte[] r = Arrays.copyOfRange(signature, 0, signature.length / 2);
        byte[] s2 = Arrays.copyOfRange(signature, signature.length / 2, signature.length);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ASN1OutputStream derOutputStream = ASN1OutputStream.create(byteArrayOutputStream, "DER");
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(new ASN1Integer(new BigInteger(this.PLUS_SIGN, r)));
        v.add(new ASN1Integer(new BigInteger(this.PLUS_SIGN, s2)));
        try {
            derOutputStream.writeObject(new DERSequence(v));
        }
        catch (IOException e) {
            throw new RuntimeException("Could not create DER sequence");
        }
        return byteArrayOutputStream.toByteArray();
    }

    public PublicKey getPublicKeyFromBytes(byte[] pubKey) throws ValidationException {
        if (pubKey.length != this.PUBLIC_KEY_BYTES_LENGTH) {
            LOGGER.error("Invalid public key length received, expected: " + this.PUBLIC_KEY_BYTES_LENGTH + " but was " + pubKey.length);
            throw new ValidationException("Public key is not " + this.PUBLIC_KEY_BYTES_LENGTH + " bytes long", "error.invalid.public.key");
        }
        LOGGER.info("Trying " + this.KEY_ALGORITHM + " with " + this.PUBLIC_KEY_BYTES_LENGTH);
        try {
            KeyFactory kf = KeyFactory.getInstance(this.KEY_ALGORITHM, "BC");
            return kf.generatePublic(this.initPublicKeyCryptoSpecs(pubKey));
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException e) {
            LOGGER.error(e.getClass().getSimpleName() + " occurred when trying to get public key from raw bytes", (Throwable)e);
            throw new RuntimeException("Cannot calculate the public key failure in crypt library");
        }
        catch (InvalidKeySpecException | InvalidParameterSpecException e) {
            throw new ValidationException("Could not create a public key", "error.invalid.public.key", e);
        }
    }

    private ECPublicKeySpec initPublicKeyCryptoSpecs(byte[] pubKey) throws NoSuchProviderException, NoSuchAlgorithmException, InvalidParameterSpecException {
        assert (pubKey.length == this.PUBLIC_KEY_BYTES_LENGTH);
        AlgorithmParameters parameters = AlgorithmParameters.getInstance(this.KEY_ALGORITHM, "BC");
        parameters.init(new ECGenParameterSpec(this.ELLIPTIC_CURVE_ALGORITHM));
        ECParameterSpec ecParameterSpec = parameters.getParameterSpec(ECParameterSpec.class);
        ECPoint point = new ECPoint(this.getPointXKeyCurve(pubKey), this.getPointYKeyCurve(pubKey));
        return new ECPublicKeySpec(point, ecParameterSpec);
    }

    private BigInteger getPointXKeyCurve(byte[] pubKey) {
        assert (pubKey.length == this.PUBLIC_KEY_BYTES_LENGTH);
        byte[] x = new byte[this.KEY_POINT_DATA_LENGTH];
        System.arraycopy(pubKey, 0, x, 0, this.KEY_POINT_DATA_LENGTH);
        return new BigInteger(this.PLUS_SIGN, x);
    }

    private BigInteger getPointYKeyCurve(byte[] pubKey) {
        assert (pubKey.length == this.PUBLIC_KEY_BYTES_LENGTH);
        byte[] y = new byte[this.KEY_POINT_DATA_LENGTH];
        System.arraycopy(pubKey, this.KEY_POINT_DATA_LENGTH, y, 0, this.KEY_POINT_DATA_LENGTH);
        return new BigInteger(this.PLUS_SIGN, y);
    }
}

