/*
 * Decompiled with CFR 0.152.
 */
package de.safe_ev.transparenzsoftware.verification.format.sml;

import de.safe_ev.transparenzsoftware.Utils;
import de.safe_ev.transparenzsoftware.verification.EncodingType;
import de.safe_ev.transparenzsoftware.verification.ValidationException;
import de.safe_ev.transparenzsoftware.verification.VerificationParser;
import de.safe_ev.transparenzsoftware.verification.VerificationType;
import de.safe_ev.transparenzsoftware.verification.format.sml.SMLSignature;
import de.safe_ev.transparenzsoftware.verification.format.sml.SMLSignatureVerifier;
import de.safe_ev.transparenzsoftware.verification.format.sml.SMLVerifiedData;
import de.safe_ev.transparenzsoftware.verification.result.Error;
import de.safe_ev.transparenzsoftware.verification.result.IntrinsicVerified;
import de.safe_ev.transparenzsoftware.verification.result.VerificationResult;
import de.safe_ev.transparenzsoftware.verification.xml.VerifiedData;

public abstract class SMLVerificationParserBase
implements VerificationParser {
    protected SMLSignatureVerifier verifier = new SMLSignatureVerifier();
    protected SMLSignatureVerifier verifier2;

    protected SMLVerificationParserBase() {
    }

    public VerificationResult parseAndVerifyWithSmlData(SMLSignature smlSignature, VerificationType verificationType, EncodingType encodingType, byte[] publicKey, IntrinsicVerified intrinsicVerified) throws ValidationException {
        SMLVerifiedData verifiedData;
        block4: {
            verifiedData = new SMLVerifiedData(smlSignature, verificationType, encodingType, Utils.toFormattedHex(publicKey));
            if (intrinsicVerified.ok()) {
                return new VerificationResult((VerifiedData)verifiedData, intrinsicVerified);
            }
            try {
                if (this.verifier.verify(publicKey, smlSignature)) {
                    return new VerificationResult((VerifiedData)verifiedData, intrinsicVerified);
                }
            }
            catch (ValidationException e) {
                if (this.verifier2 == null || !this.verifier2.verify(publicKey, smlSignature)) break block4;
                return new VerificationResult((VerifiedData)verifiedData, intrinsicVerified);
            }
        }
        return new VerificationResult((VerifiedData)verifiedData, Error.withVerificationFailed());
    }

    @Override
    public Class getVerfiedDataClass() {
        return SMLVerifiedData.class;
    }
}

