/*
 * Decompiled with CFR 0.152.
 */
package de.safe_ev.transparenzsoftware.verification.format.sml.SignatureOnly;

import de.safe_ev.transparenzsoftware.Utils;
import de.safe_ev.transparenzsoftware.verification.ValidationException;
import de.safe_ev.transparenzsoftware.verification.format.sml.SMLSignature;
import de.safe_ev.transparenzsoftware.verification.format.sml.SMLValidationException;
import java.time.OffsetDateTime;

public class SMLSignatureOnly
extends SMLSignature {
    private byte[] timestamp;
    private byte[] timestampContractId;
    private byte[] providedSignature;

    protected SMLSignatureOnly() {
    }

    public SMLSignatureOnly(byte[] rawBytes) throws ValidationException {
        if (rawBytes.length != 320) {
            throw new ValidationException("Invalid length of data applied for signature data", "error.invalid.signature.length");
        }
        this.setServerId(Utils.copyFromWithLength(rawBytes, 0, 10));
        this.setTimestamp(Utils.copyFromWithLength(rawBytes, 10, 4));
        this.setStatus(rawBytes[14]);
        this.setSecondsIndex(Utils.copyFromWithLength(rawBytes, 15, 4));
        this.setPagination(Utils.copyFromWithLength(rawBytes, 19, 4));
        this.setObisNr(Utils.copyFromWithLength(rawBytes, 23, 6));
        this.setUnit(rawBytes[29]);
        this.setScaler(rawBytes[30]);
        this.setMeterPosition(Utils.copyFromWithLength(rawBytes, 31, 8), false);
        this.setBytesLog(Utils.copyFromWithLength(rawBytes, 39, 2));
        this.setContractId(Utils.copyFromWithLength(rawBytes, 41, 128), false);
        this.setTimestampContractId(Utils.copyFromWithLength(rawBytes, 169, 4));
    }

    public void setTimestampContractId(byte[] timestampContractId) throws SMLValidationException {
        if (timestampContractId.length != 4) {
            throw new SMLValidationException("Customer id timestamp is not 4 bytes long");
        }
        this.timestampContractId = timestampContractId;
    }

    public void setTimestamp(byte[] timestamp) throws SMLValidationException {
        if (timestamp.length != 4) {
            throw new SMLValidationException("Timestamp was not 4 bytes long");
        }
        this.timestamp = timestamp;
    }

    @Override
    public byte[] getTimestamp() {
        return this.timestamp;
    }

    @Override
    public OffsetDateTime getTimestampAsDate() {
        if (this.getTimestamp().length == 0) {
            return null;
        }
        return Utils.timeBytesToTimestamp(this.getTimestamp());
    }

    @Override
    public byte[] getTimestampContractId() {
        return this.timestampContractId;
    }

    @Override
    public OffsetDateTime getTimestampContractIdAsDate() {
        if (this.getTimestampContractId().length == 0) {
            return null;
        }
        return Utils.timeBytesToTimestamp(this.getTimestampContractId());
    }

    @Override
    public byte[] getProvidedSignature() {
        return this.providedSignature;
    }

    public void setProvidedSignature(byte[] providedSignature) {
        this.providedSignature = providedSignature;
    }
}

